/*
 * Decompiled with CFR 0.152.
 */
package rewim;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import rewim.BadFormatException;
import rewim.ProgressMonitor;
import rewim.cli.NullProgressMonitor;
import rewim.core.DirEntry;
import rewim.core.Header;
import rewim.core.Image;
import rewim.core.ResourceHeader;
import rewim.core.ResourceHeaderShort;
import rewim.core.SecurityBlock;
import rewim.core.xml.Wim;
import rewim.util.DecodeUtil;

public class WimParser {
    private File srcFile;
    private FileChannel srcChannel;
    private int fileCount;
    private int parsedFileCount;
    private Image image;
    private ProgressMonitor monitor = new NullProgressMonitor();

    public WimParser(String fileName) {
        this.srcFile = new File(fileName);
    }

    public Image parse() throws Exception {
        return this.parse(0);
    }

    public Image parse(int selectedIndex) throws Exception {
        this.monitor.init();
        this.image = new Image();
        this.srcChannel = new FileInputStream(this.srcFile).getChannel();
        ByteBuffer buffer = this.srcChannel.map(FileChannel.MapMode.READ_ONLY, 0L, 208L).order(ByteOrder.LITTLE_ENDIAN);
        Header header = new Header();
        header.read(buffer);
        this.image.setHeader(header);
        buffer = this.getBuffer(header.getXmlData());
        String xmlContent = Charset.forName("UnicodeLittle").decode(buffer).toString();
        this.image.setOrigXml(xmlContent);
        Wim xmlInfo = this.parseXML(xmlContent);
        this.image.setXml(xmlInfo);
        this.fileCount = 0;
        for (rewim.core.xml.Image img : xmlInfo.getImages()) {
            this.fileCount += img.getFileCount();
        }
        buffer = this.getBuffer(header.getOffsetTable());
        Map<Integer, ResourceHeader> lookupTable = this.image.getLookupTable();
        List<ResourceHeaderShort> imageRoots = this.image.getImageRoots();
        while (buffer.hasRemaining()) {
            ResourceHeader resHeader = new ResourceHeader();
            resHeader.read(buffer);
            ResourceHeaderShort headerShort = resHeader.getHeaderShort();
            if (headerShort.isMetadata()) {
                imageRoots.add(headerShort);
                continue;
            }
            lookupTable.put(resHeader.hashCode(), resHeader);
        }
        if (header.getImageCount() != imageRoots.size()) {
            throw new BadFormatException("The image count does not match the metadata");
        }
        int imageIndex = 1;
        for (ResourceHeaderShort resHeader : imageRoots) {
            if (selectedIndex == 0 | imageIndex == selectedIndex) {
                ByteBuffer metadataBuffer;
                buffer = this.srcChannel.map(FileChannel.MapMode.READ_ONLY, resHeader.getOffset(), resHeader.getSize() + 8L).order(ByteOrder.LITTLE_ENDIAN);
                if (resHeader.isCompressed()) {
                    metadataBuffer = ByteBuffer.allocate((int)resHeader.getOrigSize()).order(ByteOrder.LITTLE_ENDIAN);
                    DecodeUtil.decode(buffer, metadataBuffer, header.getCompressMode());
                } else {
                    metadataBuffer = buffer;
                }
                SecurityBlock securityBlock = new SecurityBlock();
                securityBlock.read(metadataBuffer);
                this.image.getSecurityBlocks().add(securityBlock);
                this.monitor.newProgress("Reading image " + imageIndex);
                DirEntry entry = this.parseDirEntry(metadataBuffer, imageIndex);
                entry.setFileName(String.valueOf(imageIndex++));
                this.monitor.finishProgress();
                this.image.getDirRoots().add(entry);
                continue;
            }
            this.image.getDirRoots().add(new DirEntry());
            ++imageIndex;
        }
        this.image.setSource(this.srcFile);
        this.srcChannel.close();
        buffer.clear();
        this.monitor.done();
        return this.image;
    }

    public Image liteParse() throws Exception {
        this.monitor.init();
        this.image = new Image();
        this.srcChannel = new FileInputStream(this.srcFile).getChannel();
        ByteBuffer buffer = this.srcChannel.map(FileChannel.MapMode.READ_ONLY, 0L, 208L).order(ByteOrder.LITTLE_ENDIAN);
        Header header = new Header();
        header.read(buffer);
        this.image.setHeader(header);
        buffer = this.getBuffer(header.getXmlData());
        String xmlContent = Charset.forName("UnicodeLittle").decode(buffer).toString();
        this.image.setOrigXml(xmlContent);
        Wim xmlInfo = this.parseXML(xmlContent);
        this.image.setXml(xmlInfo);
        this.fileCount = 0;
        for (rewim.core.xml.Image img : xmlInfo.getImages()) {
            this.fileCount += img.getFileCount();
        }
        this.srcChannel.close();
        buffer.clear();
        this.monitor.done();
        return this.image;
    }

    private DirEntry parseDirEntry(ByteBuffer buffer, int imageIndex) throws BadFormatException {
        long curOff;
        long len;
        DirEntry entry = new DirEntry();
        entry.read(buffer);
        entry.setImage(this.image);
        if (!entry.isDir()) {
            ++this.parsedFileCount;
            this.monitor.setValue(this.parsedFileCount * 100 / this.fileCount);
        }
        if ((len = entry.getLength()) > Integer.MAX_VALUE) {
            entry.setLength(len >>= 32);
        }
        if ((curOff = entry.getChildrenOffset()) > Integer.MAX_VALUE) {
            entry.setChildrenOffset(curOff >>= 32);
        }
        if (curOff != 0L) {
            buffer.position((int)curOff);
            while (buffer.getLong(buffer.position()) != 0L) {
                DirEntry child = this.parseDirEntry(buffer, imageIndex);
                entry.getChildren().add(child);
                child.setParent(entry);
            }
        }
        buffer.position((int)((long)entry.getOffset() + entry.getLength()));
        entry.setImageIndex(imageIndex);
        return entry;
    }

    private Wim parseXML(String content) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"rewim.core.xml");
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        return (Wim)((JAXBElement)unmarshaller.unmarshal((Reader)new StringReader(content))).getValue();
    }

    private ByteBuffer getBuffer(ResourceHeaderShort header) throws IOException {
        return this.srcChannel.map(FileChannel.MapMode.READ_ONLY, header.getOffset(), header.getSize()).order(ByteOrder.LITTLE_ENDIAN);
    }

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void release() {
        this.image = null;
        this.monitor = null;
        System.gc();
    }
}

