/*
 * Decompiled with CFR 0.152.
 */
package rewim;

import bsh2java.log;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import rewim.WimExtractor;
import rewim.WimParser;
import rewim.core.Image;

public class WimExtractorEx
extends WimExtractor {
    private File folderPeWIM;
    private String folderRoot = System.getProperty("appDir");
    private String locLanguage = "en-US";
    private WimParser parser;

    public void set7zip(boolean value) {
        this.use7zip = value;
    }

    public WimExtractorEx(String imageFile, int imageIndex) {
        super(null);
        File folderTarget = new File(this.folderRoot, "output");
        this.folderPeWIM = new File(folderTarget, "wim-boot");
        this.setDestRoot(this.folderPeWIM);
        this.parser = new WimParser(imageFile);
        this.imageIndex = imageIndex;
        try {
            Image img = this.parser.parse(imageIndex);
            this.setImage(img);
        }
        catch (Exception ex) {
            Logger.getLogger(WimExtractorEx.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void extractDir(String what) {
        this.extractDir(what, null, "*.*");
    }

    public void extractDir(String what, String pattern) {
        this.extractDir(what, null, pattern);
    }

    public void extractDir(String what, String where, String pattern) {
        this.setRecursive(true);
        this.extractFile(what + "\\" + pattern, where);
        this.setRecursive(false);
    }

    public void setSourceLanguage(String lang) {
        this.locLanguage = lang;
    }

    private String slash2back(String inp) {
        return this.doReplace(inp, "/", "\\");
    }

    private String back2slash(String inp) {
        return this.doReplace(inp, "\\", "/");
    }

    private String doReplace(String inp, String src, String trg) {
        int p;
        String result = inp;
        while ((p = result.indexOf(src)) != -1) {
            result = result.substring(0, p) + trg + result.substring(p + 1);
        }
        return result;
    }

    public boolean extractFile(String what) {
        return this.extractFile(what, null);
    }

    public boolean extractFile7(String what) {
        return this.extractFile7(what, null);
    }

    public boolean extractFile7(String what, String where) {
        this.set7zip(true);
        boolean result = this.extractFile(what, where);
        this.set7zip(false);
        return result;
    }

    public boolean extractFile(String what, String where) {
        File folderDestination;
        boolean isOk = false;
        if (where == null) {
            File fileDestination = this.isWindows ? new File(this.folderPeWIM, this.slash2back(what)) : new File(this.folderPeWIM, this.back2slash(what));
            folderDestination = fileDestination.getParentFile();
            this.setAltDest(null);
        } else {
            String newWhere = this.isWindows ? this.slash2back(where) : this.back2slash(where);
            if (newWhere.startsWith(this.folderRoot)) {
                newWhere = newWhere.substring(this.folderRoot.length() + 1);
                folderDestination = new File(this.folderRoot, newWhere);
            } else {
                folderDestination = new File(this.folderPeWIM, newWhere);
            }
            this.setAltDest(folderDestination);
        }
        try {
            this.setDest(folderDestination);
            this.setPath(this.slash2back(what));
            this.setSource(null);
            isOk = this.extract();
        }
        catch (Exception e) {
            log.write(-1, "WIM extraction error with file %1 with result: %2", what, e.toString());
        }
        return isOk;
    }

    public boolean extractMui7(String what) {
        this.set7zip(true);
        boolean result = this.extractMui(what);
        this.set7zip(false);
        return result;
    }

    public boolean extractMui(String what) {
        String windowsLike = this.slash2back(what);
        boolean res = this.extractFile(windowsLike, null);
        if (res) {
            int lastIndex = windowsLike.lastIndexOf("\\");
            String targetDir = windowsLike.substring(0, lastIndex + 1);
            String muiFile = windowsLike.substring(lastIndex + 1) + ".mui";
            String mui = targetDir + this.locLanguage + "\\" + muiFile;
            if (this.exists(mui)) {
                res = this.extractFile(mui, null);
            }
        }
        return res;
    }

    @Override
    public void release() {
        super.release();
        this.parser.release();
    }
}

