/*
 * Decompiled with CFR 0.152.
 */
package rewim;

import bsh2java.log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.sevenzipjbinding.SevenZipException;
import rewim.ProgressMonitor;
import rewim.SevenZipExtractor;
import rewim.cli.NullProgressMonitor;
import rewim.core.DirEntry;
import rewim.core.Image;
import rewim.core.ResourceHeader;
import rewim.core.ResourceHeaderShort;
import rewim.util.DecodeUtil;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;
import utils.currentOS;
import utils.files;

public class WimExtractor {
    protected Image image;
    protected FileChannel srcChannel;
    protected int imageIndex;
    private String path = "/";
    private DirEntry source;
    private File dest;
    private File altDest = null;
    private File destRoot;
    protected ProgressMonitor monitor = new NullProgressMonitor();
    private long totalBytes;
    private long extractedBytes;
    boolean isRecursive = false;
    boolean isWindows;
    private SevenZipExtractor sevenZipExtractor = null;
    protected boolean use7zip = false;

    public long getWimTime() {
        return new Date(this.image.getSource().lastModified()).getTime();
    }

    public WimExtractor(Image image) {
        this.setImage(image);
        this.isWindows = currentOS.isWindows();
    }

    public final void setImage(Image img) {
        this.image = img;
        if (this.image != null) {
            try {
                this.srcChannel = new FileInputStream(this.image.getSource()).getChannel();
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(WimExtractor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean exists(String path) {
        DirEntry ent = this.image.findEntry(this.imageIndex, path);
        return ent != null;
    }

    public void setRecursive(boolean val) {
        this.isRecursive = val;
    }

    private boolean extractWild(String target) {
        List<DirEntry> children;
        DirEntry ent;
        Pattern match;
        boolean isOK = false;
        String winSep = "\\";
        String linSep = "/";
        String regex = "\\\\";
        int p = target.lastIndexOf(winSep);
        String dir2 = target.substring(0, p);
        String fil = target.substring(p + 1);
        String[] parts = dir2.split(regex);
        String tst = "";
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].contains("*") | parts[i].contains("?")) {
                regex = parts[i].toLowerCase().replace(".", "\\.");
                regex = regex.replace("*", ".*");
                regex = regex.replace("?", ".");
                match = Pattern.compile(regex);
                ent = this.image.findEntry(this.imageIndex, tst);
                children = ent.getChildren();
                for (DirEntry child : children) {
                    Matcher m;
                    String name = child.getFileName();
                    if (!child.isDir() || !(m = match.matcher(name.toLowerCase())).matches()) continue;
                    String foundOne = tst + winSep + name;
                    for (int f = i + 1; f < parts.length; ++f) {
                        foundOne = foundOne + winSep;
                        foundOne = foundOne + parts[f];
                    }
                    foundOne = foundOne + winSep;
                    foundOne = foundOne + fil;
                    this.extractWild(foundOne);
                }
                continue;
            }
            if (!tst.equals("")) {
                tst = tst + winSep;
            }
            tst = tst + parts[i];
        }
        if (tst.equals(dir2)) {
            regex = fil.toLowerCase().replace(".", "\\.");
            regex = regex.replace("*", ".*");
            regex = regex.replace("?", ".");
            match = Pattern.compile(regex);
            ent = this.image.findEntry(this.imageIndex, tst);
            children = ent.getChildren();
            for (DirEntry child : children) {
                String name = child.getFileName();
                if (!child.isDir()) {
                    Matcher m = match.matcher(name.toLowerCase());
                    if (!m.matches()) continue;
                    this.source = this.image.findEntry(this.imageIndex, tst + winSep + name);
                    if (this.altDest == null) {
                        int i;
                        String tmp = this.source.getParent().getFullPath();
                        if (this.isWindows) {
                            i = tmp.indexOf(winSep);
                            tmp = this.destRoot.getAbsolutePath() + winSep + tmp.substring(i + 1);
                        } else {
                            i = tmp.indexOf(linSep);
                            tmp = this.destRoot.getAbsolutePath() + linSep + tmp.substring(i + 1);
                        }
                        this.dest = new File(tmp);
                    } else {
                        this.dest = this.altDest;
                    }
                    if (!this.dest.exists()) {
                        files.mkdirs(this.dest);
                    }
                    this.path = dir2 + winSep + this.source.getFileName();
                    isOK = this.extract();
                    continue;
                }
                if (!(child.isDir() & this.isRecursive)) continue;
                File save1 = this.altDest;
                File save2 = this.dest;
                if (this.altDest != null) {
                    this.altDest = new File(this.altDest.getAbsolutePath(), winSep + name);
                }
                this.dest = new File(this.dest.getAbsolutePath(), winSep + name);
                this.extractWild(tst + winSep + name + winSep + fil);
                this.altDest = save1;
                this.dest = save2;
            }
        }
        return isOK;
    }

    public boolean createFolderWIM(File toCreate, long wimTime) {
        if (!toCreate.getParentFile().exists()) {
            return this.createFolderWIM(toCreate.getParentFile(), wimTime);
        }
        toCreate.mkdir();
        toCreate.setLastModified(wimTime);
        toCreate.getParentFile().setLastModified(wimTime);
        return true;
    }

    public boolean extract() {
        boolean isOk = false;
        if (this.path.contains("*") | this.path.contains("?")) {
            boolean result = this.extractWild(this.path);
            return result;
        }
        if (this.source == null) {
            this.source = this.image.findEntry(this.imageIndex, this.path);
        }
        if (this.source == null) {
            log.write(-1, "The specified path does not exist: %1", this.path);
            return false;
        }
        this.totalBytes = this.source.getTotalBytes();
        this.monitor.init();
        isOk = this.extractFile(this.source, this.dest);
        this.monitor.done();
        return isOk;
    }

    private static void clean(ByteBuffer buf) {
        if (buf == null) {
            return;
        }
        Cleaner cleaner = ((DirectBuffer)((Object)buf)).cleaner();
        if (cleaner != null) {
            cleaner.clean();
        }
    }

    private boolean extractFile(DirEntry entry, File targetDir) {
        boolean ok = false;
        try {
            if (entry.isDir()) {
                File dir2 = new File(targetDir, entry.getFileName());
                dir2.mkdir();
                boolean dirok = true;
                for (DirEntry child : entry.getChildren()) {
                    dirok &= this.extractFile(child, dir2);
                }
                ok = dirok;
            } else {
                String nam = entry.getFileName();
                File targetFile = new File(targetDir, nam);
                targetFile.createNewFile();
                RandomAccessFile ra = new RandomAccessFile(targetFile, "rw");
                ra.setLength(0L);
                FileChannel destChannel = ra.getChannel();
                destChannel.truncate(0L);
                ResourceHeader header = this.image.getLookupTable().get(entry.hashCode());
                if (header == null) {
                    return false;
                }
                ResourceHeaderShort res = header.getHeaderShort();
                if (res.isCompressed()) {
                    if (!this.use7zip) {
                        ByteBuffer srcBuffer = this.srcChannel.map(FileChannel.MapMode.READ_ONLY, res.getOffset(), res.getSize()).order(ByteOrder.LITTLE_ENDIAN);
                        ByteBuffer destBuffer = destChannel.map(FileChannel.MapMode.READ_WRITE, 0L, res.getOrigSize()).order(ByteOrder.LITTLE_ENDIAN);
                        DecodeUtil.decode(srcBuffer, destBuffer, this.image.getHeader().getCompressMode());
                        WimExtractor.clean(srcBuffer);
                        WimExtractor.clean(destBuffer);
                    } else {
                        destChannel.close();
                        ra.close();
                        String fullPath = entry.getFullPath();
                        if (this.sevenZipExtractor == null) {
                            this.sevenZipExtractor = new SevenZipExtractor(this.image.getSource().getAbsolutePath());
                        }
                        this.sevenZipExtractor.extractFile(fullPath, targetFile.getAbsolutePath());
                    }
                } else {
                    this.srcChannel.transferTo(res.getOffset(), res.getSize(), destChannel);
                }
                this.extractedBytes += res.getOrigSize();
                this.monitor.setValue((int)(this.extractedBytes * 100L / this.totalBytes));
                destChannel.close();
                ra.close();
                ok = true;
            }
        }
        catch (Exception e) {
            log.write(-1, "Error processing file %1", entry.getFullPath());
        }
        return ok;
    }

    public WimExtractor setImageIndex(int imageIndex) {
        this.imageIndex = imageIndex;
        return this;
    }

    public WimExtractor setPath(String path) {
        this.path = path;
        return this;
    }

    public WimExtractor setSource(DirEntry source) {
        this.source = source;
        return this;
    }

    public WimExtractor setDest(File dest) {
        this.dest = dest;
        return this;
    }

    public WimExtractor setDestRoot(File destRoot) {
        this.destRoot = destRoot;
        return this;
    }

    public WimExtractor setAltDest(File altDest) {
        this.altDest = altDest;
        return this;
    }

    public WimExtractor setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public String showInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("[target] ").append(this.dest.getAbsolutePath()).append("\n").append("[index] ").append(this.imageIndex).append("\n").append("[path] ").append(this.path);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            if (this.srcChannel != null) {
                this.srcChannel.close();
            }
            if (this.sevenZipExtractor != null) {
                this.sevenZipExtractor.release();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(WimExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SevenZipException ex) {
            Logger.getLogger(WimExtractor.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.monitor = null;
            this.image = null;
        }
    }
}

