/*
 * Decompiled with CFR 0.152.
 */
package rewim;

import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import rewim.AbstractWimWriter;
import rewim.core.DirEntry;
import rewim.core.Image;
import rewim.core.ResourceHeader;
import rewim.core.ResourceHeaderShort;
import rewim.core.SecurityBlock;

public class WimEditor
extends AbstractWimWriter {
    private Map<String, DirEntry> addedEntry = new HashMap<String, DirEntry>();
    private List<String> operationLog = new LinkedList<String>();

    public WimEditor(Image image) {
        this.image = image;
    }

    public WimEditor add(File file, int index, String path) throws Exception {
        DirEntry parent = this.image.findEntry(index, path);
        if (parent == null) {
            throw new IllegalArgumentException("The specified path does not exist");
        }
        this.operationLog.add("add " + file.getAbsolutePath() + " to " + index + File.separator + path);
        this.add(file, parent, index);
        return this;
    }

    public WimEditor add(File file, DirEntry entry) throws Exception {
        if (entry.getImage() != this.image) {
            throw new IllegalStateException();
        }
        this.operationLog.add("add " + file.getAbsolutePath() + " to " + entry.getFullPath());
        this.add(file, entry, entry.getImageIndex());
        return this;
    }

    public WimEditor add(DirEntry entry, int index, String path) throws Exception {
        DirEntry parent = this.image.findEntry(index, path);
        if (parent == null) {
            throw new IllegalArgumentException("The specified path does not exist");
        }
        this.operationLog.add("add " + entry.getFullPath() + " to " + index + File.separator + path);
        parent.getChildren().add(entry);
        this.add(entry, parent, index);
        return this;
    }

    private void add(File file, DirEntry parent, int index) throws Exception {
        DirEntry entry = new DirEntry();
        entry.init();
        entry.setFile(file);
        entry.setAttribute(file.isDirectory() ? 16 : 0);
        Date time2 = new Date(file.lastModified());
        entry.setCreationTime(time2);
        entry.setLastAccessTime(time2);
        entry.setLastWriteTime(time2);
        entry.setFileName(file.getName());
        int len = 104 + entry.getFileNameLength() + 2;
        len = len + 6 & 0xFFFFFFF8;
        entry.setLength(len);
        entry.setParent(parent);
        entry.setImage(this.image);
        parent.getChildren().add(entry);
        if (file.isDirectory()) {
            entry.setHash(new byte[20]);
            this.image.getXml().getImages().get(index - 1).increaseDirCount();
            for (File child : file.listFiles()) {
                this.add(child, entry, index);
            }
        } else {
            this.addedEntry.put(entry.getFullPath(), entry);
            this.image.getXml().getImages().get(index - 1).increaseFileCount();
            this.image.getXml().getImages().get(index - 1).increaseTotalBytes(file.length());
        }
    }

    private void add(DirEntry entry, DirEntry parent, int index) throws Exception {
        if (entry.isDir()) {
            entry.setHash(new byte[20]);
            this.image.getXml().getImages().get(index - 1).increaseDirCount();
            for (DirEntry child : entry.getChildren()) {
                this.add(child, entry, index);
            }
        } else {
            this.addedEntry.put(entry.getFullPath(), entry);
            this.image.getXml().getImages().get(index - 1).increaseFileCount();
            this.image.getXml().getImages().get(index - 1).increaseTotalBytes(entry.getFileSize());
        }
    }

    public WimEditor remove(int index, String path) throws Exception {
        DirEntry parent = this.image.findEntry(index, path);
        if (parent == null) {
            throw new IllegalArgumentException("The specified path does not exist");
        }
        this.operationLog.add("remove " + index + File.separator + path);
        this.remove(parent, index);
        return this;
    }

    public WimEditor remove(DirEntry entry) throws Exception {
        if (entry.getImage() != this.image) {
            throw new IllegalStateException();
        }
        this.operationLog.add("remove " + entry.getFullPath());
        this.remove(entry, entry.getImageIndex());
        return this;
    }

    private void remove(DirEntry entry, int index) {
        entry.getParent().getChildren().remove(entry);
        if (entry.isDir()) {
            this.image.getXml().getImages().get(index - 1).decreaseDirCount();
            for (DirEntry child : entry.getChildren()) {
                this.remove(child, index);
            }
        } else {
            this.image.getXml().getImages().get(index - 1).decreaseFileCount();
            ResourceHeader header = this.image.getLookupTable().get(entry.hashCode());
            if (header != null) {
                this.image.getXml().getImages().get(index - 1).decreaseTotalBytes(header.getHeaderShort().getSize());
            }
        }
    }

    @Override
    protected void writeFileContents() throws Exception {
        long origSize = this.image.getImageRoots().get(0).getOffset() - 208L;
        FileChannel srcChannel = new RandomAccessFile(this.image.getSource(), "r").getChannel();
        srcChannel.transferTo(208L, origSize, this.channel);
        for (DirEntry entry : this.addedEntry.values()) {
            entry.setHash(this.storeEntry(entry));
        }
    }

    protected byte[] storeEntry(DirEntry entry) throws Exception {
        ResourceHeaderShort header = new ResourceHeaderShort();
        header.setOffset(this.channel.position());
        if (entry.getFile() != null) {
            FileChannel srcChannel = new FileInputStream(entry.getFile()).getChannel();
            long size = srcChannel.size();
            srcChannel.transferTo(0L, size, this.channel);
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(srcChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size));
            entry.setHash(md.digest());
            srcChannel.close();
            header.setSize(size);
            header.setOrigSize(size);
        } else if (entry.getImage() != null) {
            Image sourceImage = entry.getImage();
            FileChannel srcChannel = new FileInputStream(sourceImage.getSource()).getChannel();
            ResourceHeaderShort sourceHeader = sourceImage.getLookupTable().get(entry.hashCode()).getHeaderShort();
            srcChannel.transferTo(sourceHeader.getOffset(), sourceHeader.getSize(), this.channel);
            srcChannel.close();
            header.setSize(sourceHeader.getSize());
            header.setOrigSize(sourceHeader.getOrigSize());
            header.setFlag((byte)4);
        } else {
            throw new IllegalStateException("a entry must has at least one associated file or a image");
        }
        ResourceHeader res = new ResourceHeader();
        res.init();
        res.setHeaderShort(header);
        res.setHash(entry.getHash());
        this.image.getLookupTable().put(res.hashCode(), res);
        return entry.getHash();
    }

    @Override
    protected SecurityBlock getSecurityBlock(int index) {
        return this.image.getSecurityBlocks().get(index);
    }

    @Override
    protected DirEntry getDirRoot(int index) {
        return this.image.getDirRoots().get(index);
    }

    @Override
    protected String getXmlContent() throws Exception {
        StringWriter writer = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((String)"rewim.core.xml");
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        marshaller.marshal((Object)this.image.getXml(), (Writer)writer);
        return writer.toString();
    }

    public String preview() {
        StringBuilder sb = new StringBuilder();
        for (String log2 : this.operationLog) {
            sb.append(log2);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void commit(File dest) throws Exception {
        dest.delete();
        dest.createNewFile();
        this.channel = new RandomAccessFile(dest, "rw").getChannel();
        for (DirEntry root : this.image.getDirRoots()) {
            root.setFileName("");
        }
        this.write();
    }
}

