/*
 * Decompiled with CFR 0.152.
 */
package rewim;

import bsh2java.log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import rewim.core.CompressMode;
import rewim.core.DirEntry;
import rewim.core.Header;
import rewim.core.Image;
import rewim.core.ResourceHeader;
import rewim.core.ResourceHeaderShort;
import rewim.core.SecurityBlock;
import rewim.util.DecodeUtil;
import rewim.util.FileTimeUtil;

public class WimBuilder {
    private FileChannel destChannel;
    private RandomAccessFile raFile;
    private ConcurrentHashMap<Integer, ResourceHeader> lookupTable = new ConcurrentHashMap();
    private AtomicLong finishedTotalBytes = new AtomicLong();
    private AtomicLong nextLogBytes = new AtomicLong();
    private int finishedDirCount;
    private int finishedFileCount;
    private String imageName;
    private File source;
    private File dest;
    private Queue<DirEntry> storeQueue;
    private Queue<DirEntry> indexQueue;
    private int entryOffset = 8;
    private long totalBytes;
    private long reportedBytes;
    private int dirCount;
    private int fileCount;
    private String customXML;
    private boolean bootable;
    private CompressMode compressMode = CompressMode.NONE;
    private ExecutorService processWorker = Executors.newFixedThreadPool(1);
    private AtomicLong compressedBytes = new AtomicLong();
    private AtomicLong wroteBytes = new AtomicLong();
    private long start;
    private BlockingQueue<WriteReq> writeQueue = new LinkedBlockingQueue<WriteReq>();

    public void close() {
    }

    public WimBuilder(File source, File dest, String imageName) {
        this.source = source;
        this.dest = dest;
        this.imageName = imageName;
    }

    public WimBuilder(String source, String dest, String imageName) {
        this.source = new File(source);
        this.dest = new File(dest);
        this.imageName = imageName;
    }

    public Image build() throws Exception {
        Image img = new Image();
        Header header = new Header();
        header.init();
        header.setCompressMode(this.compressMode);
        if (!this.source.exists() || !this.source.isDirectory()) {
            throw new IOException("Source directory does not exist");
        }
        if (this.dest.exists()) {
            this.dest.delete();
        }
        this.dest.createNewFile();
        this.raFile = new RandomAccessFile(this.dest, "rw");
        this.destChannel = this.raFile.getChannel();
        this.destChannel.position(208L);
        this.totalBytes = this.calcSize(this.source);
        if (this.totalBytes == 0L) {
            this.totalBytes = 1L;
        }
        this.nextLogBytes.set(5L);
        this.start = System.currentTimeMillis();
        final WriteReq stopReq = new WriteReq(null, null);
        Thread writeThread = new Thread(){

            @Override
            public void run() {
                boolean stop = false;
                try {
                    while (!stop) {
                        long value;
                        long currentPos = WimBuilder.this.destChannel.position();
                        WriteReq req = (WriteReq)WimBuilder.this.writeQueue.take();
                        if (req == stopReq) {
                            stop = true;
                            continue;
                        }
                        ResourceHeaderShort resHead = req.getRes().getHeaderShort();
                        resHead.setOffset(currentPos);
                        WimBuilder.this.finishedTotalBytes.addAndGet(resHead.getOrigSize());
                        WimBuilder.this.destChannel.write(req.getBuffer());
                        long addIt = 10L;
                        String est = "";
                        long trigger = WimBuilder.this.nextLogBytes.longValue();
                        if (WimBuilder.this.compressMode.equals((Object)CompressMode.NONE)) {
                            value = WimBuilder.this.finishedTotalBytes.longValue() * 100L / WimBuilder.this.totalBytes;
                        } else {
                            value = WimBuilder.this.finishedTotalBytes.longValue() * 165L / WimBuilder.this.totalBytes;
                            if (value > 100L) {
                                value = 100L;
                            }
                            addIt = 5L;
                            est = "estimated ";
                        }
                        if (value < trigger) continue;
                        if (value != WimBuilder.this.reportedBytes) {
                            log.write(2, "%1%2% done", est, "" + value);
                        }
                        WimBuilder.this.reportedBytes = value;
                        WimBuilder.this.nextLogBytes.set(value);
                        WimBuilder.this.nextLogBytes.addAndGet(addIt);
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        };
        writeThread.start();
        this.buildEntries();
        this.processWorker.shutdown();
        this.processWorker.awaitTermination(1L, TimeUnit.DAYS);
        this.writeQueue.add(stopReq);
        writeThread.join();
        ResourceHeader metaData = this.buildMetadata();
        if (this.bootable) {
            header.setBootMetadata(metaData.getHeaderShort());
            header.setBootIndex((short)1);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.entryOffset).order(ByteOrder.LITTLE_ENDIAN);
        SecurityBlock block = new SecurityBlock();
        block.init();
        block.write(buffer);
        for (DirEntry entry : this.storeQueue) {
            entry.write(buffer);
        }
        buffer.clear();
        MessageDigest md = MessageDigest.getInstance("sha-1");
        md.update(buffer);
        buffer.clear();
        byte[] hash = md.digest();
        metaData.setHash(hash);
        long metaSize = this.entryOffset;
        switch (this.compressMode) {
            case NONE: {
                this.destChannel.write(buffer);
                break;
            }
            case XPRESS: {
                ByteBuffer compressedBuffer = ByteBuffer.allocateDirect(this.entryOffset).order(ByteOrder.LITTLE_ENDIAN);
                DecodeUtil.encode(buffer, compressedBuffer, this.compressMode);
                metaSize = compressedBuffer.position();
                compressedBuffer.flip();
                this.destChannel.write(compressedBuffer);
            }
        }
        metaData.getHeaderShort().setSize(metaSize);
        metaData.getHeaderShort().setCompressed(metaSize != (long)this.entryOffset);
        long startPos = this.destChannel.position();
        long siz = (this.lookupTable.size() + 1) * 50;
        ResourceHeaderShort offsetTable = new ResourceHeaderShort();
        offsetTable.setOffset(startPos);
        offsetTable.setSize(siz);
        offsetTable.setOrigSize(siz);
        offsetTable.setFlag((byte)2);
        header.setOffsetTable(offsetTable);
        buffer = this.destChannel.map(FileChannel.MapMode.READ_WRITE, startPos, siz).order(ByteOrder.LITTLE_ENDIAN);
        for (ResourceHeader res : this.lookupTable.values()) {
            res.write(buffer);
        }
        metaData.write(buffer);
        long pos = startPos + siz;
        byte[] xmlBytes = this.generateXML().getBytes("UnicodeLittle");
        ResourceHeaderShort xmlData = new ResourceHeaderShort();
        xmlData.setFlag((byte)2);
        xmlData.setOffset(pos);
        xmlData.setSize(xmlBytes.length);
        xmlData.setOrigSize(xmlBytes.length);
        header.setXmlData(xmlData);
        MappedByteBuffer xmlBuffer = this.destChannel.map(FileChannel.MapMode.READ_WRITE, pos, xmlBytes.length);
        xmlBuffer.put(xmlBytes);
        ByteBuffer headerBuffer = this.destChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 208L).order(ByteOrder.LITTLE_ENDIAN);
        header.write(headerBuffer);
        this.raFile.close();
        return img;
    }

    private ResourceHeader buildMetadata() throws Exception {
        ResourceHeaderShort headerShort = new ResourceHeaderShort();
        headerShort.setFlag((byte)2);
        headerShort.setOffset(this.destChannel.position());
        headerShort.setSize(this.entryOffset);
        headerShort.setOrigSize(this.entryOffset);
        ResourceHeader res = new ResourceHeader();
        res.init();
        res.setHeaderShort(headerShort);
        return res;
    }

    private void buildEntries() throws Exception {
        MyComparator comp = new MyComparator();
        this.storeQueue = new LinkedList<DirEntry>();
        this.indexQueue = new LinkedList<DirEntry>();
        DirEntry endOfDir = new DirEntry(){

            @Override
            public void write(ByteBuffer buffer) {
                buffer.putLong(0L);
            }
        };
        DirEntry root = this.buildEntry(this.source);
        this.storeQueue.add(root);
        this.indexQueue.add(root);
        this.entryOffset += 8;
        this.storeQueue.add(endOfDir);
        while (!this.indexQueue.isEmpty()) {
            DirEntry entry = this.indexQueue.poll();
            entry.setChildrenOffset(this.entryOffset);
            File[] files2 = entry.getFile().listFiles();
            Arrays.sort(files2, comp);
            for (File file : files2) {
                DirEntry child = this.buildEntry(file);
                this.storeQueue.add(child);
                if (!child.isDir()) continue;
                this.indexQueue.add(child);
            }
            this.entryOffset += 8;
            this.storeQueue.add(endOfDir);
        }
    }

    private DirEntry buildEntry(File file) throws Exception {
        int len = 104;
        DirEntry entry = new DirEntry();
        entry.init();
        entry.setFile(file);
        entry.setOffset(this.entryOffset);
        entry.setAttribute(file.isDirectory() ? 10256 : 10272);
        Date time2 = new Date(file.lastModified());
        entry.setCreationTime(time2);
        entry.setLastAccessTime(time2);
        entry.setLastWriteTime(time2);
        if (file != this.source) {
            entry.setFileName(file.getName());
            len += entry.getFileNameLength() + 2;
        }
        len = len + 6 & 0xFFFFFFF8;
        entry.setLength(len);
        this.entryOffset += len;
        entry.setHash(new byte[20]);
        if (file.isDirectory()) {
            ++this.finishedDirCount;
        } else {
            ++this.finishedFileCount;
            this.processWorker.submit(new StoreTask(file, entry));
        }
        return entry;
    }

    private long calcSize(File file) {
        if (file.isFile()) {
            ++this.fileCount;
            return file.length();
        }
        if (file.isDirectory()) {
            ++this.dirCount;
            long count = 0L;
            for (File child : file.listFiles()) {
                count += this.calcSize(child);
            }
            return count;
        }
        return 0L;
    }

    private String generateXML() throws Exception {
        long time2 = FileTimeUtil.systemTimeToFileTime(this.source.lastModified());
        String lowPart = "0x" + Long.toHexString(time2 & 0xFFFFFFFFL).toUpperCase();
        String hiPart = "0x" + Long.toHexString(time2 >> 32 & 0xFFFFFFFFL).toUpperCase();
        StringBuilder sb = new StringBuilder();
        sb.append("<WIM>");
        sb.append("<TOTALBYTES>");
        sb.append(this.destChannel.position());
        sb.append("</TOTALBYTES>");
        sb.append("<IMAGE INDEX=\"1\">");
        sb.append("<NAME>");
        sb.append(this.imageName);
        sb.append("</NAME>");
        sb.append("<DIRCOUNT>");
        sb.append(this.finishedDirCount);
        sb.append("</DIRCOUNT>");
        sb.append("<FILECOUNT>");
        sb.append(this.finishedFileCount);
        sb.append("</FILECOUNT>");
        sb.append("<TOTALBYTES>");
        sb.append(this.finishedTotalBytes);
        sb.append("</TOTALBYTES>");
        sb.append("<CREATIONTIME>");
        sb.append("<HIGHPART>");
        sb.append(hiPart);
        sb.append("</HIGHPART>");
        sb.append("<LOWPART>");
        sb.append(lowPart);
        sb.append("</LOWPART>");
        sb.append("</CREATIONTIME>");
        sb.append("<LASTMODIFICATIONTIME>");
        sb.append("<HIGHPART>");
        sb.append(hiPart);
        sb.append("</HIGHPART>");
        sb.append("<LOWPART>");
        sb.append(lowPart);
        sb.append("</LOWPART>");
        sb.append("</LASTMODIFICATIONTIME>");
        String customContent = this.readCustomXML();
        if (customContent != null) {
            sb.append(customContent);
        }
        sb.append("</IMAGE>");
        sb.append("</WIM>");
        return sb.toString();
    }

    private String readCustomXML() {
        if (this.customXML == null) {
            return null;
        }
        File file = new File(this.customXML);
        if (!file.exists() || !file.isFile()) {
            log.write(26, "Specified custom XML file does not exist, ignored");
            if (!this.customXML.isEmpty()) {
                return this.customXML;
            }
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.write(-1, "Reading of the custom XML file failed");
            return null;
        }
    }

    public String showInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("[capture] ").append(this.source.getAbsolutePath()).append("\n").append("[target] ").append(this.dest.getAbsolutePath()).append("\n").append("[name] ").append(this.imageName).append("\n").append("[custom] ").append(this.customXML).append("\n").append("[bootable] ").append(this.bootable).append("\n");
        return "";
    }

    public WimBuilder setCustomXML(String customXML) {
        this.customXML = customXML;
        return this;
    }

    public WimBuilder setBootable(boolean bootable) {
        this.bootable = bootable;
        return this;
    }

    public WimBuilder setCompressMode(CompressMode compressMode) {
        this.compressMode = compressMode;
        return this;
    }

    private static class WriteReq {
        private ByteBuffer buffer;
        private ResourceHeader res;

        public WriteReq(ByteBuffer buffer, ResourceHeader res) {
            this.buffer = buffer;
            this.res = res;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public ResourceHeader getRes() {
            return this.res;
        }
    }

    private class StoreTask
    implements Runnable {
        private File file;
        private DirEntry entry;

        public StoreTask(File file, DirEntry entry) {
            this.file = file;
            this.entry = entry;
        }

        @Override
        public void run() {
            long size = 0L;
            try {
                RandomAccessFile rf = new RandomAccessFile(this.file, "r");
                FileChannel srcChannel = rf.getChannel();
                size = srcChannel.size();
                MessageDigest md = MessageDigest.getInstance("SHA1");
                ByteBuffer srcBuffer = ByteBuffer.allocateDirect((int)srcChannel.size()).order(ByteOrder.LITTLE_ENDIAN);
                srcBuffer.clear();
                srcChannel.read(srcBuffer);
                rf.close();
                srcBuffer.clear();
                md.update(srcBuffer);
                srcBuffer.clear();
                byte[] hash = md.digest();
                this.entry.setHash(hash);
                int hashCode = Arrays.hashCode(hash);
                ResourceHeader res = new ResourceHeader();
                ResourceHeader existent = WimBuilder.this.lookupTable.putIfAbsent(hashCode, res);
                if (existent != null) {
                    existent.incrRefCount();
                    WimBuilder.this.finishedTotalBytes.addAndGet(size);
                    return;
                }
                ResourceHeaderShort header = new ResourceHeaderShort();
                res.setHash(hash);
                res.setHeaderShort(header);
                long compressSize = size;
                header.setOrigSize(size);
                switch (WimBuilder.this.compressMode) {
                    case NONE: {
                        header.setSize(size);
                        header.setCompressed(false);
                        WimBuilder.this.writeQueue.add(new WriteReq(srcBuffer, res));
                        break;
                    }
                    case XPRESS: {
                        try {
                            ByteBuffer destBuffer = ByteBuffer.allocateDirect((int)size).order(ByteOrder.LITTLE_ENDIAN);
                            DecodeUtil.encode(srcBuffer, destBuffer, WimBuilder.this.compressMode);
                            compressSize = destBuffer.position();
                            destBuffer.flip();
                            header.setSize(compressSize);
                            header.setCompressed(true);
                            WimBuilder.this.writeQueue.add(new WriteReq(destBuffer, res));
                        }
                        catch (Exception e) {
                            srcBuffer.clear();
                            header.setSize(size);
                            header.setCompressed(false);
                            WimBuilder.this.writeQueue.add(new WriteReq(srcBuffer, res));
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger(WimBuilder.class.getCanonicalName()).log(Level.SEVERE, "failed to process file", e);
            }
        }
    }

    final class MyComparator
    implements Comparator,
    Serializable {
        MyComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            try {
                File file1 = (File)obj1;
                File file2 = (File)obj2;
                if (file1.isDirectory() && !file2.isDirectory()) {
                    return -1;
                }
                if (!file1.isDirectory() && file2.isDirectory()) {
                    return 1;
                }
                return file1.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
            }
            catch (ClassCastException classCastException) {
                return 0;
            }
        }
    }
}

