/*
 * Decompiled with CFR 0.152.
 */
package rewim;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.sevenzipjbinding.ArchiveFormat;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.ISevenZipInArchive;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;

public class SevenZipExtractor {
    private RandomAccessFile randomInputFile = null;
    private ISevenZipInArchive inArchive = null;
    private FileOutputStream outStream = null;

    public SevenZipExtractor(String wimPath) throws FileNotFoundException, SevenZipException {
        this.randomInputFile = new RandomAccessFile(wimPath, "r");
        this.inArchive = SevenZip.openInArchive(ArchiveFormat.WIM, new RandomAccessFileInStream(this.randomInputFile));
    }

    public void release() throws SevenZipException, IOException {
        if (this.inArchive != null) {
            this.inArchive.close();
        }
        if (this.randomInputFile != null) {
            this.randomInputFile.close();
        }
        if (this.outStream != null) {
            this.outStream.close();
        }
    }

    public void extractFile(String extractPath, String targetPath) throws FileNotFoundException, SevenZipException {
        try {
            this.outStream = new FileOutputStream(targetPath);
            int count = this.inArchive.getNumberOfItems();
            ArrayList<Integer> itemsToExtract = new ArrayList<Integer>();
            for (int i = 0; i < count; ++i) {
                String pth = this.inArchive.getProperty(i, PropID.PATH).toString();
                if (!pth.equalsIgnoreCase(extractPath)) continue;
                itemsToExtract.add(i);
            }
            int[] items = new int[itemsToExtract.size()];
            int i = 0;
            for (Integer integer : itemsToExtract) {
                items[i++] = integer;
            }
            MyExtractCallback callBack = new MyExtractCallback(this.inArchive, this.outStream);
            this.inArchive.extract(items, false, callBack);
        }
        catch (Exception e) {
            System.err.println("Error occurs: " + e);
        }
    }

    public static class MyExtractCallback
    implements IArchiveExtractCallback {
        private ISevenZipInArchive inArchive = null;
        private FileOutputStream outStream = null;
        private int index;

        public MyExtractCallback(ISevenZipInArchive inArchive, FileOutputStream outStream) {
            this.inArchive = inArchive;
            this.outStream = outStream;
        }

        @Override
        public ISequentialOutStream getStream(int index, ExtractAskMode extractAskMode) throws SevenZipException {
            this.index = index;
            if (extractAskMode != ExtractAskMode.EXTRACT) {
                return null;
            }
            return new ISequentialOutStream(){

                @Override
                public int write(byte[] data) throws SevenZipException {
                    try {
                        MyExtractCallback.this.outStream.write(data);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SevenZipExtractor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return data.length;
                }
            };
        }

        @Override
        public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
        }

        @Override
        public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
            if (extractOperationResult != ExtractOperationResult.OK) {
                System.err.println(String.format("Extraction error: %s", this.inArchive.getProperty(this.index, PropID.PATH)));
            }
        }

        @Override
        public void setCompleted(long completeValue) throws SevenZipException {
        }

        @Override
        public void setTotal(long total) throws SevenZipException {
        }
    }
}

