/*
 * Decompiled with CFR 0.152.
 */
package rewim;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.List;
import rewim.core.DirEntry;
import rewim.core.Header;
import rewim.core.Image;
import rewim.core.ResourceHeader;
import rewim.core.ResourceHeaderShort;
import rewim.core.SecurityBlock;

public abstract class AbstractWimWriter {
    protected FileChannel channel;
    protected Image image;
    private List<ResourceHeader> metadatas = new LinkedList<ResourceHeader>();
    protected int[] fileCount;
    protected int[] dirCount;
    protected long[] totalBytes;

    protected void write() throws Exception {
        this.channel.position(208L);
        this.writeFileContents();
        int imageCount = this.image.getHeader().getImageCount();
        this.fileCount = new int[imageCount];
        this.dirCount = new int[imageCount];
        this.totalBytes = new long[imageCount];
        for (int i = 0; i < imageCount; ++i) {
            this.metadatas.add(this.writeDir(i));
        }
        Header header = this.image.getHeader();
        if (header.getBootIndex() > 0) {
            header.setBootMetadata(this.metadatas.get(header.getBootIndex() - 1).getHeaderShort());
        }
        this.image.getHeader().setOffsetTable(this.writeLookupTable());
        this.image.getHeader().setXmlData(this.writeXmlData());
        this.channel.position(0L);
        ByteBuffer buffer = this.getBuffer(208L);
        this.image.getHeader().write(buffer);
        this.channel.close();
    }

    protected ByteBuffer getBuffer(long size) throws IOException {
        ByteBuffer buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, this.channel.position(), size).order(ByteOrder.LITTLE_ENDIAN);
        this.channel.position(this.channel.position() + size);
        return buffer;
    }

    protected abstract void writeFileContents() throws Exception;

    private ResourceHeader writeDir(int index) throws Exception {
        SecurityBlock securityBlock = this.getSecurityBlock(index);
        long offset = securityBlock.getTotalLength();
        DirEntry root = this.getDirRoot(index);
        LinkedList<DirEntry> dirQueue = new LinkedList<DirEntry>();
        LinkedList<DirEntry> storeQueue = new LinkedList<DirEntry>();
        DirEntry endOfDir = new DirEntry(){

            @Override
            public void write(ByteBuffer buffer) {
                buffer.putLong(0L);
            }
        };
        dirQueue.add(root);
        storeQueue.add(root);
        storeQueue.add(endOfDir);
        offset += root.getLength();
        offset += 8L;
        while (!dirQueue.isEmpty()) {
            DirEntry entry = (DirEntry)dirQueue.poll();
            entry.setChildrenOffset(offset);
            for (DirEntry child : entry.getChildren()) {
                child.setOffset((int)offset);
                offset += child.getLength();
                storeQueue.add(child);
                if (child.isDir()) {
                    int n = index;
                    this.dirCount[n] = this.dirCount[n] + 1;
                    dirQueue.add(child);
                    continue;
                }
                int n = index;
                this.fileCount[n] = this.fileCount[n] + 1;
            }
            offset += 8L;
            storeQueue.add(endOfDir);
        }
        ResourceHeaderShort headerShort = new ResourceHeaderShort();
        headerShort.setFlag((byte)2);
        headerShort.setOffset(this.channel.position());
        headerShort.setSize(offset);
        headerShort.setOrigSize(offset);
        ResourceHeader metadata = new ResourceHeader();
        metadata.init();
        metadata.setHeaderShort(headerShort);
        ByteBuffer buffer = this.getBuffer(offset);
        securityBlock.write(buffer);
        for (DirEntry entry : storeQueue) {
            entry.write(buffer);
        }
        buffer.clear();
        MessageDigest md = MessageDigest.getInstance("sha-1");
        md.update(buffer);
        byte[] hash = md.digest();
        metadata.setHash(hash);
        return metadata;
    }

    protected byte[] storeFile(File file) throws Exception {
        ResourceHeaderShort header = new ResourceHeaderShort();
        header.setOffset(this.channel.position());
        FileChannel srcChannel = new FileInputStream(file).getChannel();
        long size = srcChannel.size();
        srcChannel.transferTo(0L, size, this.channel);
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(srcChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size));
        byte[] hash = md.digest();
        srcChannel.close();
        header.setSize(size);
        header.setOrigSize(size);
        ResourceHeader res = new ResourceHeader();
        res.init();
        res.setHeaderShort(header);
        res.setHash(hash);
        this.image.getLookupTable().put(res.hashCode(), res);
        return hash;
    }

    private ResourceHeaderShort writeLookupTable() throws Exception {
        long size = (this.image.getLookupTable().size() + this.metadatas.size()) * 50;
        ResourceHeaderShort header = new ResourceHeaderShort();
        header.setFlag((byte)2);
        header.setOffset(this.channel.position());
        header.setSize(size);
        header.setOrigSize(size);
        ByteBuffer buffer = this.getBuffer(size);
        for (ResourceHeader res : this.image.getLookupTable().values()) {
            res.write(buffer);
        }
        for (ResourceHeader res : this.metadatas) {
            res.write(buffer);
        }
        return header;
    }

    private ResourceHeaderShort writeXmlData() throws Exception {
        String xmlContent = this.getXmlContent();
        byte[] xmlBytes = xmlContent.getBytes("UnicodeLittle");
        ResourceHeaderShort header = new ResourceHeaderShort();
        header.setFlag((byte)2);
        header.setOffset(this.channel.position());
        header.setSize(xmlBytes.length);
        header.setOrigSize(xmlBytes.length);
        ByteBuffer buffer = this.getBuffer(xmlBytes.length);
        buffer.put(xmlBytes);
        return header;
    }

    protected abstract SecurityBlock getSecurityBlock(int var1);

    protected abstract DirEntry getDirRoot(int var1);

    protected abstract String getXmlContent() throws Exception;
}

