/*
 * Decompiled with CFR 0.152.
 */
package relink.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Utils {
    public static byte[] toBytesStr(String string, boolean isUnicode, boolean isNULTerminated) {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        try {
            if (isUnicode) {
                buff.write(string.getBytes("UTF-16LE"));
                if (isNULTerminated) {
                    try {
                        buff.write(new byte[]{0, 0});
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else {
                buff.write(string.getBytes());
                if (isNULTerminated) {
                    buff.write(new byte[]{0});
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return buff.toByteArray();
    }

    public static int readStringNULTerminated(StringBuilder builder, byte[] data, int offset, boolean isUnicode) {
        int i = offset;
        while (true) {
            char c;
            if ((c = (char)data[i]) == '\u0000') {
                if (!isUnicode || (char)data[i + 1] != '\u0000') break;
                break;
            }
            builder.append(c);
            ++i;
        }
        return i - offset + (isUnicode ? 2 : 1);
    }

    public static String readUnicodeString(byte[] data, int offset, int length) {
        byte[] chars = Utils.getBytes(data, offset, length * 2);
        try {
            return new String(chars, "UTF-16LE");
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("unknown error, check this");
            return null;
        }
    }

    public static boolean[] getBitsRevr(byte[] data) {
        StringBuilder bitStringBldr = new StringBuilder();
        StringBuilder reverser = new StringBuilder();
        for (int n : data) {
            reverser.replace(0, 8, Integer.toBinaryString(256 + (n &= 0xFF)).substring(1));
            bitStringBldr.append((CharSequence)reverser.reverse());
        }
        byte[] bools = bitStringBldr.toString().getBytes();
        boolean[] rtnBools = new boolean[bools.length];
        for (int i = 0; i < bools.length; ++i) {
            rtnBools[i] = bools[i] != 48;
        }
        return rtnBools;
    }

    public static byte[] getBytes(byte[] data, int offset, int length) {
        byte[] rtnBytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            rtnBytes[i] = data[offset + i];
        }
        return rtnBytes;
    }

    public static long toInt64(byte[] bytes, int offset) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value += ((long)bytes[offset + i] & 0xFFL) << 8 * i;
        }
        return value;
    }

    public static byte[] fromInt64(long value) {
        byte[] arr = new byte[8];
        for (int i = 0; i < 8; ++i) {
            arr[i] = (byte)(value >> 8 * i);
        }
        return arr;
    }

    public static int toInt32(byte[] bytes, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value += (bytes[offset + i] & 0xFF) << 8 * i;
        }
        return value;
    }

    public static byte[] fromInt32(int value) {
        byte[] arr = new byte[4];
        for (int i = 0; i < 4; ++i) {
            arr[i] = (byte)(value >> 8 * i);
        }
        return arr;
    }

    public static int toInt16(byte[] bytes, int offset) {
        int value = 0;
        for (int i = 0; i < 2; ++i) {
            value += (bytes[offset + i] & 0xFF) << 8 * i;
        }
        return value;
    }

    public static byte[] fromInt16(int value) {
        byte[] arr = new byte[2];
        for (int i = 0; i < 2; ++i) {
            arr[i] = (byte)(value >>> 8 * i);
        }
        return arr;
    }

    public static int toInt8(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF;
    }

    public static byte fromInt8(int value) {
        return (byte)value;
    }

    public static String toGUIDFormat(byte[] bytes) {
        byte[] switched = new byte[]{bytes[3], bytes[2], bytes[1], bytes[0], bytes[5], bytes[4], bytes[7], bytes[6], bytes[8], bytes[9], bytes[10], bytes[11], bytes[12], bytes[13], bytes[14], bytes[15]};
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        Formatter formatter = new Formatter(sb);
        for (byte b : switched) {
            formatter.format("%02x", b);
        }
        sb.insert(8, "-");
        sb.insert(13, "-");
        sb.insert(18, "-");
        sb.insert(23, "-");
        return sb.toString().toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileBytes(File file) throws IOException {
        ByteArrayOutputStream ous = null;
        InputStream ios = null;
        try {
            int read;
            byte[] buffer = new byte[4096];
            ous = new ByteArrayOutputStream();
            ios = new FileInputStream(file);
            while ((read = ios.read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
        }
        finally {
            try {
                if (ous != null) {
                    ous.close();
                }
            }
            catch (IOException e) {}
            try {
                if (ios != null) {
                    ios.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ous.toByteArray();
    }

    public static byte[] allocate(int length) {
        return new byte[length];
    }

    public static byte[] concat(byte[] ... arrays) {
        int totalLength = 0;
        for (int i = 0; i < arrays.length; ++i) {
            totalLength += arrays[i].length;
        }
        byte[] result = new byte[totalLength];
        int currentIndex = 0;
        for (int i = 0; i < arrays.length; ++i) {
            System.arraycopy(arrays[i], 0, result, currentIndex, arrays[i].length);
            currentIndex += arrays[i].length;
        }
        return result;
    }

    public static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        String[] base = basePath.split(Pattern.quote(pathSeparator), -1);
        String[] target = targetPath.split(Pattern.quote(pathSeparator), 0);
        String common2 = "";
        int commonIndex = 0;
        for (int i = 0; i < target.length && i < base.length && target[i].equals(base[i]); ++i) {
            common2 = common2 + target[i] + pathSeparator;
            ++commonIndex;
        }
        if (commonIndex == 0) {
            return targetPath;
        }
        String relative = "";
        if (base.length != commonIndex) {
            int numDirsUp = base.length - commonIndex - 1;
            for (int i = 1; i <= numDirsUp; ++i) {
                relative = relative + ".." + pathSeparator;
            }
        }
        relative = relative + targetPath.substring(common2.length());
        return relative;
    }

    public static byte[] bitsToBytes(byte[] bits, int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = Utils.bitsToByteRevr(bits, i * 8);
        }
        return bytes;
    }

    private static byte bitsToByteRevr(byte[] bits, int offset) {
        byte b = 0;
        if (bits[offset + 0] == 1) {
            b = (byte)(b + 1);
        }
        if (bits[offset + 1] == 1) {
            b = (byte)(b + 2);
        }
        if (bits[offset + 2] == 1) {
            b = (byte)(b + 4);
        }
        if (bits[offset + 3] == 1) {
            b = (byte)(b + 8);
        }
        if (bits[offset + 4] == 1) {
            b = (byte)(b + 16);
        }
        if (bits[offset + 5] == 1) {
            b = (byte)(b + 32);
        }
        if (bits[offset + 6] == 1) {
            b = (byte)(b + 64);
        }
        if (bits[offset + 7] == 1) {
            b = (byte)(b + 128);
        }
        return b;
    }
}

