/*
 * Decompiled with CFR 0.152.
 */
package relink.info;

import java.util.Formatter;
import relink.utils.Utils;

public class VolumeID {
    public int VolumeIDSize;
    public int DriveType;
    public byte[] DriveSerialNumber;
    public int VolumeLabelOffset;
    public int VolumeLabelOffsetUnicode;
    public String VolumeLabel;
    public static final int DRIVE_UNKNOWN = 0;
    public static final int DRIVE_NO_ROOT_DIR = 1;
    public static final int DRIVE_REMOVABLE = 2;
    public static final int DRIVE_FIXED = 3;
    public static final int DRIVE_REMOTE = 4;
    public static final int DRIVE_CDROM = 5;
    public static final int DRIVE_RAMDISK = 6;

    public VolumeID(byte[] data, int offset) {
        int initialOffset = offset;
        this.VolumeIDSize = Utils.toInt32(data, offset);
        this.DriveType = Utils.toInt32(data, offset += 4);
        this.DriveSerialNumber = Utils.getBytes(data, offset += 4, 4);
        this.VolumeLabelOffset = Utils.toInt32(data, offset += 4);
        this.VolumeLabelOffsetUnicode = Utils.toInt32(data, offset += 4);
        StringBuilder builder = new StringBuilder();
        if (this.VolumeLabelOffset == 20) {
            Utils.readStringNULTerminated(builder, data, initialOffset + this.VolumeLabelOffsetUnicode, true);
            this.VolumeLabel = builder.toString();
        } else {
            Utils.readStringNULTerminated(builder, data, initialOffset + this.VolumeLabelOffset, false);
            this.VolumeLabel = builder.toString();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Volume ID Size: ").append(this.VolumeIDSize).append("\n");
        sb.append("Drive Type: ").append(this.DriveType);
        switch (this.DriveType) {
            case 0: {
                sb.append(" (DRIVE_UNKNOWN)");
                break;
            }
            case 1: {
                sb.append(" (DRIVE_NO_ROOT_DIR)");
                break;
            }
            case 2: {
                sb.append(" (DRIVE_REMOVABLE)");
                break;
            }
            case 3: {
                sb.append(" (DRIVE_FIXED)");
                break;
            }
            case 4: {
                sb.append(" (DRIVE_REMOTE)");
                break;
            }
            case 5: {
                sb.append(" (DRIVE_CDROM)");
                break;
            }
            case 6: {
                sb.append(" ");
            }
        }
        sb.append("\n");
        sb.append("Drive Serial Number: ").append(this.getDriveSerialNumberFormat()).append("\n");
        sb.append("Volume Label Offset: ").append(this.VolumeLabelOffset).append("\n");
        sb.append("Volume Label Offset Unicode: ").append(this.VolumeLabelOffsetUnicode).append("\n");
        sb.append("Volume Label: ").append(this.VolumeLabel);
        return sb.toString();
    }

    public String getDriveSerialNumberFormat() {
        int[] revBytes = new int[]{this.DriveSerialNumber[3] & 0xFF, this.DriveSerialNumber[2] & 0xFF, this.DriveSerialNumber[1] & 0xFF, this.DriveSerialNumber[0] & 0xFF};
        StringBuilder sb = new StringBuilder(this.DriveSerialNumber.length * 2);
        Formatter formatter = new Formatter(sb);
        for (int b : revBytes) {
            formatter.format("%02x", b);
        }
        sb.insert(4, "-");
        return sb.toString().toUpperCase();
    }
}

