/*
 * Decompiled with CFR 0.152.
 */
package relink.info;

import java.nio.ByteBuffer;
import relink.info.CommonNetworkRelativeLink;
import relink.info.LinkInfoFlags;
import relink.info.VolumeID;
import relink.utils.Utils;

public class LinkInfo {
    public int LinkInfoSize;
    public int LinkInfoHeaderSize;
    public LinkInfoFlags LinkInfoFlags;
    public int VolumeIDOffset;
    public int LocalBasePathOffset;
    public int CommonNetworkRelativeLinkOffset;
    public int CommonPathSuffixOffset;
    public int LocalBasePathOffsetUnicode;
    public int CommonPathSuffixOffsetUnicode;
    public VolumeID VolumeID;
    public String LocalBasePath;
    public CommonNetworkRelativeLink CommonNetworkRelativeLink;
    public String CommonPathSuffix;
    public String LocalBasePathUnicode;
    public String CommonPathSuffixUnicode;

    public LinkInfo() {
        this.LinkInfoHeaderSize = 28;
    }

    public LinkInfo(byte[] data) {
        StringBuilder builder;
        int offset = 0;
        this.LinkInfoSize = Utils.toInt32(data, offset);
        this.LinkInfoHeaderSize = Utils.toInt32(data, offset += 4);
        this.LinkInfoFlags = new LinkInfoFlags(Utils.getBytes(data, offset += 4, 4));
        this.VolumeIDOffset = Utils.toInt32(data, offset += 4);
        this.LocalBasePathOffset = Utils.toInt32(data, offset += 4);
        this.CommonNetworkRelativeLinkOffset = Utils.toInt32(data, offset += 4);
        this.CommonPathSuffixOffset = Utils.toInt32(data, offset += 4);
        if (this.LinkInfoHeaderSize >= 36) {
            this.LocalBasePathOffsetUnicode = Utils.toInt32(data, offset += 4);
            this.CommonPathSuffixOffsetUnicode = Utils.toInt32(data, offset += 4);
        }
        if (this.LinkInfoFlags.VolumeIDAndLocalBasePath) {
            this.VolumeID = new VolumeID(data, this.VolumeIDOffset);
            if (this.LinkInfoHeaderSize >= 36) {
                offset = this.LocalBasePathOffsetUnicode;
                builder = new StringBuilder();
                offset += Utils.readStringNULTerminated(builder, data, offset, true);
                this.LocalBasePathUnicode = builder.toString();
            } else {
                offset = this.LocalBasePathOffset;
                builder = new StringBuilder();
                offset += Utils.readStringNULTerminated(builder, data, offset, false);
                this.LocalBasePath = builder.toString();
            }
        }
        if (this.LinkInfoFlags.CommonNetworkRelativeLinkAndPathSuffix) {
            this.CommonNetworkRelativeLink = new CommonNetworkRelativeLink(data, this.CommonNetworkRelativeLinkOffset);
            if (this.LinkInfoHeaderSize >= 36) {
                offset = this.CommonPathSuffixOffsetUnicode;
                builder = new StringBuilder();
                Utils.readStringNULTerminated(builder, data, offset, true);
                this.CommonPathSuffixUnicode = builder.toString();
            } else {
                offset = this.CommonPathSuffixOffset;
                builder = new StringBuilder();
                Utils.readStringNULTerminated(builder, data, offset, false);
                this.CommonPathSuffix = builder.toString();
            }
        }
    }

    public byte[] toBytes() {
        ByteBuffer buff = ByteBuffer.allocate(this.LinkInfoSize);
        try {
            buff.put(Utils.allocate(4));
            buff.put(Utils.fromInt32(this.LinkInfoHeaderSize));
            buff.put(this.LinkInfoFlags.toBytes());
            buff.put(Utils.allocate(4));
            buff.put(Utils.allocate(4));
            buff.put(Utils.allocate(4));
            buff.put(Utils.allocate(4));
            if (this.LinkInfoHeaderSize >= 36) {
                buff.put(Utils.allocate(4));
                buff.put(Utils.allocate(4));
            }
            if (this.LinkInfoFlags.VolumeIDAndLocalBasePath) {
                buff.put(Utils.fromInt32(buff.position()), 12, 4);
                if (this.LinkInfoHeaderSize >= 36) {
                    buff.put(Utils.fromInt32(buff.position()), 28, 4);
                    buff.put(Utils.toBytesStr(this.LocalBasePathUnicode, true, true));
                } else {
                    buff.put(Utils.fromInt32(buff.position()), 16, 4);
                    buff.put(Utils.toBytesStr(this.LocalBasePath, false, true));
                }
            }
            if (this.LinkInfoFlags.CommonNetworkRelativeLinkAndPathSuffix) {
                buff.put(Utils.fromInt32(buff.position()), 20, 4);
                if (this.LinkInfoHeaderSize >= 36) {
                    buff.put(Utils.fromInt32(buff.position()), 32, 4);
                    buff.put(Utils.toBytesStr(this.CommonPathSuffixUnicode, true, true));
                } else {
                    buff.put(Utils.fromInt32(buff.position()), 24, 4);
                    buff.put(Utils.toBytesStr(this.CommonPathSuffix, false, true));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff.array();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Link Info Size: ").append(this.LinkInfoSize).append("\n");
        sb.append("Link Info Header Size: ").append(this.LinkInfoHeaderSize).append("\n");
        sb.append("Link Info Flags\n[\n").append(this.LinkInfoFlags.toString()).append("\n]\n");
        sb.append("Local Base Path Offset: ").append(this.LocalBasePathOffset).append("\n");
        sb.append("Common Network Relative Link Offset: ").append(this.CommonNetworkRelativeLinkOffset).append("\n");
        sb.append("Common Path Suffix Offset: ").append(this.CommonPathSuffixOffset).append("\n");
        sb.append("Volume ID\n[\n").append(this.VolumeID.toString()).append("\n]\n");
        sb.append("Local Base Path: ").append(this.LocalBasePath).append("\n");
        sb.append("Common Network Relative Link: ").append(this.CommonNetworkRelativeLink).append("\n");
        sb.append("Common Path Suffix: ").append(this.CommonPathSuffix).append("\n");
        sb.append("Local Base Path Unicode: ").append(this.LocalBasePathUnicode).append("\n");
        sb.append("Common Path Suffix Unicode: ").append(this.CommonPathSuffixUnicode);
        return sb.toString();
    }
}

