/*
 * Decompiled with CFR 0.152.
 */
package relink.info;

import relink.info.CommonNetworkRelativeLinkFlags;
import relink.utils.Utils;

public class CommonNetworkRelativeLink {
    public int CommonNetworkRelativeLinkSize;
    public CommonNetworkRelativeLinkFlags CommonNetworkRelativeLinkFlags;
    public int NetNameOffset;
    public int DeviceNameOffset;
    public int NetworkProviderType;
    public int NetNameOffsetUnicode;
    public int DeviceNameOffsetUnicode;
    public String NetName;
    public String DeviceName;
    public String NetNameUnicode;
    public String DeviceNameUnicode;
    public static final int WNNC_NET_MSNET = 65536;
    public static final int WNNC_NET_LANMAN = 131072;
    public static final int WNNC_NET_NETWARE = 196608;
    public static final int WNNC_NET_VINES = 262144;
    public static final int WNNC_NET_10NET = 327680;
    public static final int WNNC_NET_LOCUS = 393216;
    public static final int WNNC_NET_SUN_PC_NFS = 458752;
    public static final int WNNC_NET_LANSTEP = 524288;
    public static final int WNNC_NET_9TILES = 589824;
    public static final int WNNC_NET_LANTASTIC = 655360;
    public static final int WNNC_NET_AS400 = 720896;
    public static final int WNNC_NET_FTP_NFS = 786432;
    public static final int WNNC_NET_PATHWORKS = 851968;
    public static final int WNNC_NET_LIFENET = 917504;
    public static final int WNNC_NET_POWERLAN = 983040;
    public static final int WNNC_NET_BWNFS = 0x100000;
    public static final int WNNC_NET_COGENT = 0x110000;
    public static final int WNNC_NET_FARALLON = 0x120000;
    public static final int WNNC_NET_APPLETALK = 0x130000;
    public static final int WNNC_NET_INTERGRAPH = 0x140000;
    public static final int WNNC_NET_SYMFONET = 0x150000;
    public static final int WNNC_NET_CLEARCASE = 0x160000;
    public static final int WNNC_NET_FRONTIER = 0x170000;
    public static final int WNNC_NET_BMC = 0x180000;
    public static final int WNNC_NET_DCE = 0x190000;
    public static final int WNNC_NET_AVID = 0x1A0000;
    public static final int WNNC_NET_DOCUSPACE = 0x1B0000;
    public static final int WNNC_NET_MANGOSOFT = 0x1C0000;
    public static final int WNNC_NET_SERNET = 0x1D0000;
    public static final int WNNC_NET_RIVERFRONT1 = 0x1E0000;
    public static final int WNNC_NET_RIVERFRONT2 = 0x1F0000;
    public static final int WNNC_NET_DECORB = 0x200000;
    public static final int WNNC_NET_PROTSTOR = 0x210000;
    public static final int WNNC_NET_FJ_REDIR = 0x220000;
    public static final int WNNC_NET_DISTINCT = 0x230000;
    public static final int WNNC_NET_TWINS = 0x240000;
    public static final int WNNC_NET_RDR2SAMPLE = 0x250000;
    public static final int WNNC_NET_CSC = 0x260000;
    public static final int WNNC_NET_3IN1 = 0x270000;
    public static final int WNNC_NET_EXTENDNET = 0x290000;
    public static final int WNNC_NET_STAC = 0x2A0000;
    public static final int WNNC_NET_FOXBAT = 0x2B0000;
    public static final int WNNC_NET_YAHOO = 0x2C0000;
    public static final int WNNC_NET_EXIFS = 0x2D0000;
    public static final int WNNC_NET_DAV = 0x2E0000;
    public static final int WNNC_NET_KNOWARE = 0x2F0000;
    public static final int WNNC_NET_OBJECT_DIRE = 0x300000;
    public static final int WNNC_NET_MASFAX = 0x310000;
    public static final int WNNC_NET_HOB_NFS = 0x320000;
    public static final int WNNC_NET_SHIVA = 0x330000;
    public static final int WNNC_NET_IBMAL = 0x340000;
    public static final int WNNC_NET_LOCK = 0x350000;
    public static final int WNNC_NET_TERMSRV = 0x360000;
    public static final int WNNC_NET_SRT = 0x370000;
    public static final int WNNC_NET_QUINCY = 0x380000;
    public static final int WNNC_NET_OPENAFS = 0x390000;
    public static final int WNNC_NET_AVID1 = 0x3A0000;
    public static final int WNNC_NET_DFS = 0x3B0000;
    public static final int WNNC_NET_KWNP = 0x3C0000;
    public static final int WNNC_NET_ZENWORKS = 0x3D0000;
    public static final int WNNC_NET_DRIVEONWEB = 0x3E0000;
    public static final int WNNC_NET_VMWARE = 0x3F0000;
    public static final int WNNC_NET_RSFX = 0x400000;
    public static final int WNNC_NET_MFILES = 0x410000;
    public static final int WNNC_NET_MS_NFS = 0x420000;
    public static final int WNNC_NET_GOOGLE = 0x430000;

    public CommonNetworkRelativeLink(byte[] data, int offset) {
        int baseOffset = offset;
        this.CommonNetworkRelativeLinkSize = Utils.toInt32(data, offset);
        this.CommonNetworkRelativeLinkFlags = new CommonNetworkRelativeLinkFlags(Utils.getBytes(data, offset += 4, 4));
        this.NetNameOffset = Utils.toInt32(data, offset += 4);
        this.DeviceNameOffset = Utils.toInt32(data, offset += 4);
        this.NetworkProviderType = Utils.toInt32(data, offset += 4);
        if (this.NetNameOffset > 20) {
            this.NetNameOffsetUnicode = Utils.toInt32(data, offset += 4);
            this.DeviceNameOffsetUnicode = Utils.toInt32(data, offset += 4);
            offset = baseOffset + this.NetNameOffsetUnicode;
            StringBuilder builder = new StringBuilder();
            offset += Utils.readStringNULTerminated(builder, data, offset, true);
            this.NetNameUnicode = builder.toString();
            if (this.CommonNetworkRelativeLinkFlags.ValidDevice) {
                offset = baseOffset + this.DeviceNameOffsetUnicode;
                builder = new StringBuilder();
                offset += Utils.readStringNULTerminated(builder, data, offset, true);
                this.NetNameUnicode = builder.toString();
            }
        } else {
            offset = baseOffset + this.NetNameOffset;
            StringBuilder builder = new StringBuilder();
            offset += Utils.readStringNULTerminated(builder, data, offset, false);
            this.NetName = builder.toString();
            if (this.CommonNetworkRelativeLinkFlags.ValidDevice) {
                offset = baseOffset + this.DeviceNameOffset;
                builder = new StringBuilder();
                offset += Utils.readStringNULTerminated(builder, data, offset, false);
                this.DeviceName = builder.toString();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Common Network Relative Link Size: ").append(this.CommonNetworkRelativeLinkSize).append("\n");
        sb.append("Common Network Relative Link Flags\n[\n").append(this.CommonNetworkRelativeLinkFlags.toString()).append("\n]\n");
        sb.append("Net Name Offset: ").append(this.NetNameOffset).append("\n");
        sb.append("Device Name Offset: ").append(this.DeviceNameOffset).append("\n");
        sb.append("Network Provider Type: ").append(this.NetworkProviderType).append("\n");
        sb.append("Net Name Offset Unicode: ").append(this.NetNameOffsetUnicode).append("\n");
        sb.append("Device Name Offset Unicode: ").append(this.DeviceNameOffsetUnicode).append("\n");
        sb.append("Net Name: ").append(this.NetName).append("\n");
        sb.append("Device Name: ").append(this.DeviceName).append("\n");
        sb.append("Net Name Unicode: ").append(this.NetNameUnicode).append("\n");
        sb.append("Device Name Unicode: ").append(this.DeviceNameUnicode);
        return sb.toString();
    }
}

