/*
 * Decompiled with CFR 0.152.
 */
package relink.idlist;

import java.io.ByteArrayOutputStream;
import java.util.Date;
import relink.idlist.ItemID;
import relink.utils.FileTimeUtil;
import relink.utils.Utils;

public class PathItem
implements ItemID {
    public int pathType;
    public int pathSize;
    public Date ModifiedTime;
    public String pathName;
    public Date CreationTime;
    public Date AccessTime;
    public String fullPathName;
    public static final int TYPE_FOLDER = 49;
    public static final int TYPE_FILE = 50;
    public static final int TYPE_FOLDER_UNICODE = 53;
    public static final int TYPE_FILE_UNICODE = 54;

    public PathItem(String path, boolean isDirectory) {
        this.pathType = isDirectory ? 49 : 50;
        this.pathSize = 0;
        this.CreationTime = this.AccessTime = new Date(FileTimeUtil.millisToFiletime(0L));
        this.ModifiedTime = this.AccessTime;
        int lastIndex = path.lastIndexOf("\\");
        this.pathName = this.fullPathName = path.substring(lastIndex + 1);
    }

    @Override
    public byte[] toBytes() {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        try {
            buff.write(Utils.fromInt16(this.pathType));
            buff.write(Utils.fromInt32(this.pathSize));
            buff.write(Utils.fromInt32((int)FileTimeUtil.millisToFiletime(this.ModifiedTime.getTime())));
            if (this.pathSize == 0) {
                buff.write(Utils.fromInt16(16));
            } else {
                buff.write(Utils.fromInt16(32));
            }
            buff.write(Utils.toBytesStr(this.pathName, false, true));
            int indicator = 24 + 2 * this.pathName.length();
            buff.write(Utils.fromInt16(indicator));
            buff.write(Utils.fromInt16(3));
            buff.write(Utils.fromInt16(4));
            buff.write(Utils.fromInt16(48879));
            buff.write(Utils.fromInt32((int)FileTimeUtil.millisToFiletime(this.CreationTime.getTime())));
            buff.write(Utils.fromInt32((int)FileTimeUtil.millisToFiletime(this.AccessTime.getTime())));
            buff.write(Utils.fromInt16(20));
            buff.write(Utils.fromInt16(0));
            buff.write(Utils.toBytesStr(this.fullPathName, true, true));
            buff.write(Utils.fromInt16(14 + this.pathName.length() + 1));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff.toByteArray();
    }
}

