/*
 * Decompiled with CFR 0.152.
 */
package relink.idlist;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import relink.idlist.DriveItem;
import relink.idlist.ItemID;
import relink.idlist.PathItem;
import relink.idlist.RootItem;
import relink.utils.Utils;

public class LinkTargetIDList {
    public int IDListSize;
    public ArrayList<ItemID> ItemIDList = new ArrayList();

    public LinkTargetIDList(String targetFile, boolean isDirectory) {
        String[] path = targetFile.split("\\\\");
        this.ItemIDList.add(new RootItem("MY_COMPUTER"));
        this.ItemIDList.add(new DriveItem(targetFile.charAt(0)));
        for (int i = 1; i < path.length; ++i) {
            String currentPath = "";
            for (int z = 0; z <= i; ++z) {
                currentPath = currentPath + path[z] + (z == i ? "" : "\\");
            }
            this.ItemIDList.add(new PathItem(currentPath, isDirectory ? true : i != path.length - 1));
        }
    }

    public LinkTargetIDList(byte[] data) {
        int size;
        this.IDListSize = Utils.toInt16(data, 0);
        for (int offset = 2; offset < data.length; offset += size) {
            size = Utils.toInt16(data, offset);
        }
    }

    public byte[] toBytes() {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < this.ItemIDList.size(); ++i) {
                byte[] bytes = this.ItemIDList.get(i).toBytes();
                buff.write(Utils.fromInt16(bytes.length + 2));
                buff.write(bytes);
            }
            buff.write(new byte[]{0, 0});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID List Size: ").append(this.IDListSize);
        for (int i = 0; i < this.ItemIDList.size(); ++i) {
            sb.append("\nItemID\n[\n").append(this.ItemIDList.get(i).toString()).append("\n]");
        }
        return sb.toString();
    }
}

