/*
 * Decompiled with CFR 0.152.
 */
package relink.header;

import java.nio.ByteBuffer;
import java.util.Date;
import relink.header.FileAttributesFlags;
import relink.header.HotKeyFlags;
import relink.header.LinkFlags;
import relink.utils.FileTimeUtil;
import relink.utils.Utils;

public class ShellLinkHeader {
    public int HeaderSize;
    public byte[] LinkCLSID;
    public LinkFlags LinkFlags;
    public FileAttributesFlags FileAttributes;
    public Date CreationTime;
    public Date AccessTime;
    public Date WriteTime;
    public long FileSize;
    public int IconIndex;
    public int ShowCommand;
    public HotKeyFlags HotKey;
    public byte[] Reserved1;
    public byte[] Reserved2;
    public byte[] Reserved3;
    private final byte[] DEFAULT_CLSID = new byte[]{1, 20, 2, 0, 0, 0, 0, 0, -64, 0, 0, 0, 0, 0, 0, 70};
    public static final int SW_SHOWNORMAL = 1;
    public static final int SW_SHOWMAXIMIZED = 3;
    public static final int SW_SHOWMINNOACTIVE = 7;

    public ShellLinkHeader() {
        this.HeaderSize = 76;
        this.LinkCLSID = this.DEFAULT_CLSID;
        this.LinkFlags = new LinkFlags();
        this.FileAttributes = new FileAttributesFlags();
        this.CreationTime = new Date(System.currentTimeMillis());
        this.AccessTime = new Date(System.currentTimeMillis());
        this.WriteTime = new Date(System.currentTimeMillis());
        this.ShowCommand = 1;
        this.HotKey = new HotKeyFlags();
        this.Reserved1 = new byte[]{0, 0};
        this.Reserved2 = new byte[]{0, 0, 0, 0};
        this.Reserved3 = new byte[]{0, 0, 0, 0};
    }

    public ShellLinkHeader(byte[] data) {
        int offset = 0;
        this.HeaderSize = Utils.toInt32(data, offset);
        this.LinkCLSID = Utils.getBytes(data, offset += 4, 16);
        this.LinkFlags = new LinkFlags(Utils.getBytes(data, offset += 16, 4));
        this.FileAttributes = new FileAttributesFlags(Utils.getBytes(data, offset += 4, 4));
        this.CreationTime = this.toDate(Utils.getBytes(data, offset += 4, 8));
        this.AccessTime = this.toDate(Utils.getBytes(data, offset += 8, 8));
        this.WriteTime = this.toDate(Utils.getBytes(data, offset += 8, 8));
        this.FileSize = Utils.toInt32(data, offset += 8);
        this.IconIndex = Utils.toInt32(data, offset += 4);
        this.ShowCommand = Utils.toInt32(data, offset += 4);
        this.HotKey = new HotKeyFlags(Utils.getBytes(data, offset += 4, 2));
        this.Reserved1 = Utils.getBytes(data, offset += 2, 2);
        this.Reserved2 = Utils.getBytes(data, offset += 2, 4);
        this.Reserved3 = Utils.getBytes(data, offset += 4, 4);
    }

    private Date toDate(byte[] bytes) {
        long l = Utils.toInt64(bytes, 0);
        l = FileTimeUtil.filetimeToMillis(l);
        return new Date(l);
    }

    public byte[] toBytes() {
        ByteBuffer bb = ByteBuffer.allocate(76);
        bb.put(Utils.fromInt32(this.HeaderSize));
        bb.put(this.LinkCLSID);
        bb.put(this.LinkFlags.toBytes());
        bb.put(this.FileAttributes.toBytes());
        bb.put(Utils.fromInt64(FileTimeUtil.millisToFiletime(this.CreationTime.getTime())));
        bb.put(Utils.fromInt64(FileTimeUtil.millisToFiletime(this.AccessTime.getTime())));
        bb.put(Utils.fromInt64(FileTimeUtil.millisToFiletime(this.WriteTime.getTime())));
        bb.put(Utils.fromInt32((int)this.FileSize));
        bb.put(Utils.fromInt32(this.IconIndex));
        bb.put(Utils.fromInt32(this.ShowCommand));
        bb.put(this.HotKey.toBytes());
        bb.put(this.Reserved1);
        bb.put(this.Reserved2);
        bb.put(this.Reserved3);
        return bb.array();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Header Size: ").append(this.HeaderSize).append("\n");
        sb.append("LinkCLSID: ").append(Utils.toGUIDFormat(this.LinkCLSID)).append("\n");
        sb.append("Link Flags\n[\n").append(this.LinkFlags.toString()).append("\n]\n");
        sb.append("File Attributes Flags\n[\n").append(this.FileAttributes.toString()).append("\n]\n");
        sb.append("Creation Time: ").append(this.CreationTime.toString()).append("\n");
        sb.append("Access Time: ").append(this.CreationTime.toString()).append("\n");
        sb.append("Write Time: ").append(this.CreationTime.toString()).append("\n");
        sb.append("File Size: ").append(this.FileSize).append("\n");
        sb.append("Icon Index: ").append(this.IconIndex).append("\n");
        sb.append("Show Command: ").append(this.ShowCommand);
        switch (this.ShowCommand) {
            case 1: {
                sb.append(" (SW_SHOWNORMAL)");
                break;
            }
            case 3: {
                sb.append(" (SW_SHOWMAXIMIZED)");
                break;
            }
            case 7: {
                sb.append(" (SW_SHOWMINNOACTIVE)");
                break;
            }
            default: {
                sb.append(" (Unknown)");
            }
        }
        sb.append("\n");
        sb.append("Hot Key Flags\n[\n").append(this.HotKey.toString()).append("\n]");
        return sb.toString();
    }
}

