/*
 * Decompiled with CFR 0.152.
 */
package relink.header;

import relink.utils.Utils;

public class FileAttributesFlags {
    public boolean FILE_ATTRIBUTE_READONLY;
    public boolean FILE_ATTRIBUTE_HIDDEN;
    public boolean FILE_ATTRIBUTE_SYSTEM;
    public boolean Reserved1;
    public boolean FILE_ATTRIBUTE_DIRECTORY;
    public boolean FILE_ATTRIBUTE_ARCHIVE;
    public boolean Reserved2;
    public boolean FILE_ATTRIBUTE_NORMAL;
    public boolean FILE_ATTRIBUTE_TEMPORARY;
    public boolean FILE_ATTRIBUTE_SPARSE_FILE;
    public boolean FILE_ATTRIBUTE_REPARSE_POINT;
    public boolean FILE_ATTRIBUTE_COMPRESSED;
    public boolean FILE_ATTRIBUTE_OFFLINE;
    public boolean FILE_ATTRIBUTE_NOT_CONTENT_INDEXED;
    public boolean FILE_ATTRIBUTE_ENCRYPTED;

    public FileAttributesFlags() {
        this.FILE_ATTRIBUTE_ARCHIVE = true;
    }

    public FileAttributesFlags(byte[] data) {
        boolean[] bools = Utils.getBitsRevr(data);
        int i = 0;
        this.FILE_ATTRIBUTE_READONLY = bools[i++];
        this.FILE_ATTRIBUTE_HIDDEN = bools[i++];
        this.FILE_ATTRIBUTE_SYSTEM = bools[i++];
        this.Reserved1 = bools[i++];
        this.FILE_ATTRIBUTE_DIRECTORY = bools[i++];
        this.FILE_ATTRIBUTE_ARCHIVE = bools[i++];
        this.Reserved2 = bools[i++];
        this.FILE_ATTRIBUTE_NORMAL = bools[i++];
        this.FILE_ATTRIBUTE_TEMPORARY = bools[i++];
        this.FILE_ATTRIBUTE_SPARSE_FILE = bools[i++];
        this.FILE_ATTRIBUTE_REPARSE_POINT = bools[i++];
        this.FILE_ATTRIBUTE_COMPRESSED = bools[i++];
        this.FILE_ATTRIBUTE_OFFLINE = bools[i++];
        this.FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = bools[i++];
        this.FILE_ATTRIBUTE_ENCRYPTED = bools[i++];
    }

    public byte[] toBytes() {
        byte[] bits = new byte[32];
        if (this.FILE_ATTRIBUTE_READONLY) {
            bits[0] = 1;
        }
        if (this.FILE_ATTRIBUTE_HIDDEN) {
            bits[1] = 1;
        }
        if (this.FILE_ATTRIBUTE_SYSTEM) {
            bits[2] = 1;
        }
        if (this.Reserved1) {
            bits[3] = 1;
        }
        if (this.FILE_ATTRIBUTE_DIRECTORY) {
            bits[4] = 1;
        }
        if (this.FILE_ATTRIBUTE_ARCHIVE) {
            bits[5] = 1;
        }
        if (this.Reserved2) {
            bits[6] = 1;
        }
        if (this.FILE_ATTRIBUTE_NORMAL) {
            bits[7] = 1;
        }
        if (this.FILE_ATTRIBUTE_TEMPORARY) {
            bits[8] = 1;
        }
        if (this.FILE_ATTRIBUTE_SPARSE_FILE) {
            bits[9] = 1;
        }
        if (this.FILE_ATTRIBUTE_REPARSE_POINT) {
            bits[10] = 1;
        }
        if (this.FILE_ATTRIBUTE_COMPRESSED) {
            bits[11] = 1;
        }
        if (this.FILE_ATTRIBUTE_OFFLINE) {
            bits[12] = 1;
        }
        if (this.FILE_ATTRIBUTE_NOT_CONTENT_INDEXED) {
            bits[13] = 1;
        }
        if (this.FILE_ATTRIBUTE_ENCRYPTED) {
            bits[14] = 1;
        }
        return Utils.bitsToBytes(bits, 4);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.FILE_ATTRIBUTE_READONLY) {
            sb.append(",FILE_ATTRIBUTE_READONLY");
        }
        if (this.FILE_ATTRIBUTE_HIDDEN) {
            sb.append(",FILE_ATTRIBUTE_HIDDEN");
        }
        if (this.FILE_ATTRIBUTE_SYSTEM) {
            sb.append(",FILE_ATTRIBUTE_SYSTEM");
        }
        if (this.Reserved1) {
            sb.append(",Reserved1");
        }
        if (this.FILE_ATTRIBUTE_DIRECTORY) {
            sb.append(",FILE_ATTRIBUTE_DIRECTORY");
        }
        if (this.FILE_ATTRIBUTE_ARCHIVE) {
            sb.append(",FILE_ATTRIBUTE_ARCHIVE");
        }
        if (this.Reserved2) {
            sb.append(",Reserved2");
        }
        if (this.FILE_ATTRIBUTE_NORMAL) {
            sb.append(",FILE_ATTRIBUTE_NORMAL");
        }
        if (this.FILE_ATTRIBUTE_TEMPORARY) {
            sb.append(",FILE_ATTRIBUTE_TEMPORARY");
        }
        if (this.FILE_ATTRIBUTE_SPARSE_FILE) {
            sb.append(",FILE_ATTRIBUTE_SPARSE_FILE");
        }
        if (this.FILE_ATTRIBUTE_REPARSE_POINT) {
            sb.append(",FILE_ATTRIBUTE_REPARSE_POINT");
        }
        if (this.FILE_ATTRIBUTE_COMPRESSED) {
            sb.append(",FILE_ATTRIBUTE_COMPRESSED");
        }
        if (this.FILE_ATTRIBUTE_OFFLINE) {
            sb.append(",FILE_ATTRIBUTE_OFFLINE");
        }
        if (this.FILE_ATTRIBUTE_NOT_CONTENT_INDEXED) {
            sb.append(",FILE_ATTRIBUTE_NOT_CONTENT_INDEXED");
        }
        if (this.FILE_ATTRIBUTE_ENCRYPTED) {
            sb.append(",FILE_ATTRIBUTE_ENCRYPTED");
        }
        return sb.toString().substring(sb.length() == 0 ? 0 : 1);
    }
}

