/*
 * Decompiled with CFR 0.152.
 */
package relink.data.extra;

import java.util.Formatter;
import relink.data.extra.DataBlock;
import relink.utils.Utils;

public class TrackerDataBlock
extends DataBlock {
    public int Length;
    public int Version;
    public String MachineID;
    public byte[] Droid;
    public byte[] DroidBirth;

    public TrackerDataBlock(byte[] data, boolean isUnicode) {
        super(data);
        this.Length = Utils.toInt32(data, this.offset);
        this.Version = Utils.toInt32(data, this.offset += 4);
        StringBuilder builder = new StringBuilder();
        int len = Utils.readStringNULTerminated(builder, data, this.offset += 4, isUnicode);
        this.offset += len;
        this.MachineID = builder.toString();
        this.Droid = Utils.getBytes(data, this.offset, 32);
        this.DroidBirth = Utils.getBytes(data, this.offset += 32, 32);
        this.offset += 32;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Length: ").append(this.Length).append("\n");
        sb.append("Version: ").append(this.Version).append("\n");
        sb.append("Machine ID: ").append(this.MachineID.toUpperCase()).append("\n");
        String droid1 = this.droidToString(Utils.getBytes(this.DroidBirth, 0, 16));
        String droid2 = this.droidToString(Utils.getBytes(this.DroidBirth, 16, 16));
        sb.append("Droid: {").append(droid1).append(", ").append(droid2).append("}\n");
        String droidBirth1 = this.droidToString(Utils.getBytes(this.DroidBirth, 0, 16));
        String droidBirth2 = this.droidToString(Utils.getBytes(this.DroidBirth, 16, 16));
        sb.append("Droid Birth: {").append(droidBirth1).append(", ").append(droidBirth2).append("}");
        return sb.toString();
    }

    private String droidToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        Formatter formatter = new Formatter(sb);
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return sb.toString().toUpperCase();
    }
}

