/*
 * Decompiled with CFR 0.152.
 */
package relink.data.extra;

import relink.data.extra.DataBlock;
import relink.utils.Utils;

public class ConsoleDataBlock
extends DataBlock {
    public int FillAttributes;
    public int PopupFillAttributes;
    public int ScreenBufferSizeX;
    public int ScreenBufferSizeY;
    public int WindowSizeX;
    public int WindowSizeY;
    public int WindowOriginX;
    public int WindowOriginY;
    public byte[] Unused1;
    public byte[] Unused2;
    public int FontSize;
    public int FontFamily;
    public int FontWeight;
    public String FaceName;
    public int CursorSize;
    public int FullScreen;
    public int QuickEdit;
    public int InsertMode;
    public int AutoPosition;
    public int HistoryBufferSize;
    public int NumberOfHistoryBuffers;
    public int HistoryNoDup;
    public byte[] ColorTable;
    public static final int FOREGROUND_BLUE = 1;
    public static final int FOREGROUND_GREEN = 2;
    public static final int FOREGROUND_RED = 4;
    public static final int FOREGROUND_INTENSITY = 8;
    public static final int BACKGROUND_BLUE = 16;
    public static final int BACKGROUND_GREEN = 32;
    public static final int BACKGROUND_RED = 64;
    public static final int BACKGROUND_INTENSITY = 128;
    public static final int FF_DONTCARE = 0;
    public static final int FF_ROMAN = 16;
    public static final int FF_SWISS = 32;
    public static final int FF_MODERN = 48;
    public static final int FF_SCRIPT = 64;
    public static final int FF_DECORATIVE = 80;

    public ConsoleDataBlock(byte[] data) {
        super(data);
        this.FillAttributes = Utils.toInt16(data, this.offset);
        this.PopupFillAttributes = Utils.toInt16(data, this.offset += 2);
        this.ScreenBufferSizeX = Utils.toInt16(data, this.offset += 2);
        this.ScreenBufferSizeY = Utils.toInt16(data, this.offset += 2);
        this.WindowSizeX = Utils.toInt16(data, this.offset += 2);
        this.WindowSizeY = Utils.toInt16(data, this.offset += 2);
        this.WindowOriginX = Utils.toInt16(data, this.offset += 2);
        this.WindowOriginY = Utils.toInt16(data, this.offset += 2);
        this.Unused1 = new byte[4];
        this.Unused2 = new byte[4];
        this.offset += 8;
        this.FontSize = Utils.toInt32(data, this.offset);
        this.FontFamily = Utils.toInt32(data, this.offset += 4);
        this.FontWeight = Utils.toInt16(data, this.offset += 4);
        this.FaceName = Utils.readUnicodeString(data, this.offset, 32);
        this.CursorSize = Utils.toInt32(data, this.offset += 64);
        this.FullScreen = Utils.toInt32(data, this.offset += 4);
        this.QuickEdit = Utils.toInt32(data, this.offset += 4);
        this.InsertMode = Utils.toInt32(data, this.offset += 4);
        this.AutoPosition = Utils.toInt32(data, this.offset += 4);
        this.HistoryBufferSize = Utils.toInt32(data, this.offset += 4);
        this.NumberOfHistoryBuffers = Utils.toInt32(data, this.offset += 4);
        this.HistoryNoDup = Utils.toInt32(data, this.offset += 4);
        this.ColorTable = Utils.getBytes(data, this.offset += 4, 64);
        this.offset += 64;
    }

    public boolean isBoldFont() {
        return this.FontWeight >= 700;
    }

    public boolean isQuickEditModeEnabled() {
        return this.QuickEdit != 0;
    }

    public boolean isInsertModeEnabled() {
        return this.InsertMode != 0;
    }

    public boolean isAutoPosition() {
        return this.AutoPosition != 0;
    }
}

