/*
 * Decompiled with CFR 0.152.
 */
package relink.data;

import java.io.ByteArrayOutputStream;
import relink.header.LinkFlags;
import relink.utils.Utils;

public class StringData {
    public String COMMENT;
    public String RELATIVE_PATH;
    public String WORKING_DIR;
    public String COMMAND_LINE_ARGUMENTS;
    public String ICON_LOCATION;
    public int newOffset;

    public StringData() {
    }

    public StringData(byte[] data, int offset, LinkFlags flags) {
        int size;
        if (flags.HasName) {
            size = Utils.toInt16(data, offset);
            this.COMMENT = Utils.readUnicodeString(data, offset += 2, size);
            offset += size * 2;
        }
        if (flags.HasRelativePath) {
            size = Utils.toInt16(data, offset);
            this.RELATIVE_PATH = Utils.readUnicodeString(data, offset += 2, size);
            offset += size * 2;
        }
        if (flags.HasWorkingDir) {
            size = Utils.toInt16(data, offset);
            this.WORKING_DIR = Utils.readUnicodeString(data, offset += 2, size);
            offset += size * 2;
        }
        if (flags.HasArguments) {
            size = Utils.toInt16(data, offset);
            this.COMMAND_LINE_ARGUMENTS = Utils.readUnicodeString(data, offset += 2, size);
            offset += size * 2;
        }
        if (flags.HasIconLocation) {
            size = Utils.toInt16(data, offset);
            this.ICON_LOCATION = Utils.readUnicodeString(data, offset += 2, size);
            offset += size * 2;
        }
        this.newOffset = offset;
    }

    public byte[] toBytes(LinkFlags flags) {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        try {
            if (flags.HasName) {
                buff.write(Utils.fromInt16(this.COMMENT.length()));
                buff.write(Utils.toBytesStr(this.COMMENT, true, false));
            }
            if (flags.HasRelativePath) {
                buff.write(Utils.fromInt16(this.RELATIVE_PATH.length()));
                buff.write(Utils.toBytesStr(this.RELATIVE_PATH, true, false));
            }
            if (flags.HasWorkingDir) {
                buff.write(Utils.fromInt16(this.WORKING_DIR.length()));
                buff.write(Utils.toBytesStr(this.WORKING_DIR, true, false));
            }
            if (flags.HasArguments) {
                buff.write(Utils.fromInt16(this.COMMAND_LINE_ARGUMENTS.length()));
                buff.write(Utils.toBytesStr(this.COMMAND_LINE_ARGUMENTS, true, false));
            }
            if (flags.HasIconLocation) {
                buff.write(Utils.fromInt16(this.ICON_LOCATION.length()));
                buff.write(Utils.toBytesStr(this.ICON_LOCATION, true, false));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buff.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Comment: ").append(this.COMMENT).append("\n");
        sb.append("Relative Path: ").append(this.RELATIVE_PATH).append("\n");
        sb.append("Working Directory: ").append(this.WORKING_DIR).append("\n");
        sb.append("Command Line Arguments: ").append(this.COMMAND_LINE_ARGUMENTS).append("\n");
        sb.append("Icon Location: ").append(this.ICON_LOCATION);
        return sb.toString();
    }
}

