/*
 * Decompiled with CFR 0.152.
 */
package relink.data;

import relink.data.extra.ConsoleDataBlock;
import relink.data.extra.ConsoleFEDataBlock;
import relink.data.extra.DarwinDataBlock;
import relink.data.extra.EnvironmentVariableDataBlock;
import relink.data.extra.IconEnvironmentDataBlock;
import relink.data.extra.KnownFolderDataBlock;
import relink.data.extra.PropertyStoreDataBlock;
import relink.data.extra.ShimDataBlock;
import relink.data.extra.SpecialFolderDataBlock;
import relink.data.extra.TrackerDataBlock;
import relink.data.extra.VistaAndAboveIDListDataBlock;
import relink.utils.Utils;

public class ExtraData {
    public ConsoleDataBlock CONSOLE_PROPS;
    public ConsoleFEDataBlock CONSOLE_FE_PROPS;
    public DarwinDataBlock DARWIN_PROPS;
    public EnvironmentVariableDataBlock ENVIRONMENT_PROPS;
    public IconEnvironmentDataBlock ICON_ENVIRONMENT_PROPS;
    public KnownFolderDataBlock KNOWN_FOLDER_PROPS;
    public PropertyStoreDataBlock PROPERTY_STORE_PROPS;
    public ShimDataBlock SHIM_PROPS;
    public SpecialFolderDataBlock SPECIAL_FOLDER_PROPS;
    public TrackerDataBlock TRACKER_PROPS;
    public VistaAndAboveIDListDataBlock VISTA_AND_ABOVE_IDLIST_PROPS;
    public static final int ENVIRONMENT_VARIABLE_DATA_BLOCK_SIG = -1610612735;
    public static final int CONSOLE_DATA_BLOCK_SIG = -1610612734;
    public static final int TRACKER_DATA_BLOCK_SIG = -1610612733;
    public static final int CONSOLE_FE_DATA_BLOCK_SIG = -1610612732;
    public static final int SPECIAL_FOLDER_DATA_BLOCK_SIG = -1610612731;
    public static final int DARWIN_DATA_BLOCK_SIG = -1610612730;
    public static final int ICON_ENVIRONMENT_DATA_BLOCK_SIG = -1610612729;
    public static final int SHIM_DATA_BLOCK_SIG = -1610612728;
    public static final int PROPERTY_STORE_DATA_BLOCK_SIG = -1610612727;
    public static final int KNOWN_FOLDER_DATA_BLOCK_SIG = -1610612725;
    public static final int VISTA_AND_ABOVE_IDLIST_DATA_BLOCK_SIG = -1610612724;

    public ExtraData() {
    }

    public ExtraData(byte[] data, int offset, boolean isUnicode) {
        while (!this.isTerminalBlock(data, offset)) {
            int blockSize = Utils.toInt32(data, offset);
            int blockSignature = Utils.toInt32(data, offset + 4);
            byte[] blockData = Utils.getBytes(data, offset, blockSize);
            switch (blockSignature) {
                case -1610612734: {
                    this.CONSOLE_PROPS = new ConsoleDataBlock(blockData);
                    break;
                }
                case -1610612732: {
                    this.CONSOLE_FE_PROPS = new ConsoleFEDataBlock(blockData);
                    break;
                }
                case -1610612730: {
                    this.DARWIN_PROPS = new DarwinDataBlock(blockData);
                    break;
                }
                case -1610612735: {
                    this.ENVIRONMENT_PROPS = new EnvironmentVariableDataBlock(blockData);
                    break;
                }
                case -1610612729: {
                    this.ICON_ENVIRONMENT_PROPS = new IconEnvironmentDataBlock(blockData);
                    break;
                }
                case -1610612725: {
                    this.KNOWN_FOLDER_PROPS = new KnownFolderDataBlock(blockData);
                    break;
                }
                case -1610612727: {
                    this.PROPERTY_STORE_PROPS = new PropertyStoreDataBlock(blockData);
                    break;
                }
                case -1610612728: {
                    this.SHIM_PROPS = new ShimDataBlock(blockData);
                    break;
                }
                case -1610612731: {
                    this.SPECIAL_FOLDER_PROPS = new SpecialFolderDataBlock(blockData);
                    break;
                }
                case -1610612733: {
                    this.TRACKER_PROPS = new TrackerDataBlock(blockData, isUnicode);
                    break;
                }
                case -1610612724: {
                    this.VISTA_AND_ABOVE_IDLIST_PROPS = new VistaAndAboveIDListDataBlock(blockData);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            offset += blockSize;
        }
    }

    private boolean isTerminalBlock(byte[] data, int offset) {
        return data[offset] == 0 && data[offset + 1] == 0 && data[offset + 2] == 0 && data[offset + 3] == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Console Data Block\n[\n").append(this.CONSOLE_PROPS).append("\n]\n");
        sb.append("Console FE Data Block\n[\n").append(this.CONSOLE_FE_PROPS).append("\n]\n");
        sb.append("Darwin Data Block\n[\n").append(this.DARWIN_PROPS).append("\n]\n");
        sb.append("Environment Variable Data Block\n[\n").append(this.ENVIRONMENT_PROPS).append("\n]\n");
        sb.append("Icon Environment Data Block\n[\n").append(this.ICON_ENVIRONMENT_PROPS).append("\n]\n");
        sb.append("Known Folder Data Block\n[\n").append(this.KNOWN_FOLDER_PROPS).append("\n]\n");
        sb.append("Property Store Data Block\n[\n").append(this.PROPERTY_STORE_PROPS).append("\n]\n");
        sb.append("Shim Data Block\n[\n").append(this.SHIM_PROPS).append("\n]\n");
        sb.append("Special Folder Data Block\n[\n").append(this.SPECIAL_FOLDER_PROPS).append("\n]\n");
        sb.append("Tracker Data Block\n[\n").append(this.TRACKER_PROPS).append("\n]\n");
        sb.append("Vista And Above IDList Data Block\n[\n").append(this.VISTA_AND_ABOVE_IDLIST_PROPS).append("\n]");
        return sb.toString();
    }
}

