/*
 * Decompiled with CFR 0.152.
 */
package relink;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import relink.InvalidLinkException;
import relink.data.ExtraData;
import relink.data.StringData;
import relink.header.ShellLinkHeader;
import relink.idlist.LinkTargetIDList;
import relink.info.LinkInfo;
import relink.utils.Utils;

public class MSlink {
    private ShellLinkHeader linkHeader;
    private LinkTargetIDList idList;
    private LinkInfo linkInfo;
    private StringData stringData;
    private ExtraData extraData;
    private String target;
    private boolean isRelativeTarget;
    public static final int SW_SHOWNORMAL = 1;
    public static final int SW_SHOWMAXIMIZED = 3;
    public static final int SW_SHOWMINNOACTIVE = 7;

    public static void main(String[] args) throws IOException {
        new File("Test File.txt").createNewFile();
        MSlink newLink = new MSlink();
        newLink.setTarget("C:\\Dokumente und Einstellungen\\Peter\\Desktop\\Test File.cmd", false);
        newLink.setComment("Test Comment");
        newLink.setArguments("Hello");
        newLink.setShowWindowMode(7);
        newLink.setIcon("C:\\WINDOWS\\system32\\shell32.dll");
        newLink.setIconIndex(7);
        newLink.setWorkingDir("C:\\Dokumente und Einstellungen\\Peter");
        newLink.save(new File("C:\\Dokumente und Einstellungen\\Peter\\Desktop\\Test Link2.lnk"));
    }

    public MSlink() {
        this.linkHeader = new ShellLinkHeader();
        this.stringData = new StringData();
    }

    public MSlink(File file) {
        byte[] data;
        try {
            data = Utils.getFileBytes(file);
        }
        catch (FileNotFoundException ex) {
            System.out.println("File (" + file.getAbsolutePath() + ") does not exist!");
            return;
        }
        catch (IOException ex) {
            System.out.println("Could not read file: " + file.getAbsolutePath());
            return;
        }
        if (data[0] != 76) {
            throw new InvalidLinkException("File (" + file.getAbsolutePath() + ") is not a valid .lnk file!");
        }
        this.parse(data);
    }

    public void setIconIndex(int index) {
        this.linkHeader.IconIndex = index;
    }

    public void setArguments(String arguments) {
        this.linkHeader.LinkFlags.HasArguments = true;
        this.stringData.COMMAND_LINE_ARGUMENTS = arguments;
    }

    public void setWorkingDir(String dir2) {
        this.linkHeader.LinkFlags.HasRelativePath = false;
        this.isRelativeTarget = false;
        this.linkHeader.LinkFlags.HasWorkingDir = true;
        this.stringData.WORKING_DIR = dir2;
    }

    public void setHeaderFlag() {
    }

    public void setComment(String comment) {
        this.linkHeader.LinkFlags.HasName = true;
        this.stringData.COMMENT = comment;
    }

    public void setTarget(String target, boolean isDirectory) {
        boolean setRelative;
        this.isRelativeTarget = setRelative = true;
        this.linkHeader.LinkFlags.HasRelativePath = setRelative;
        this.linkHeader.FileAttributes.FILE_ATTRIBUTE_DIRECTORY = isDirectory;
        this.linkHeader.FileSize = 0L;
        this.linkHeader.AccessTime = new Date(System.currentTimeMillis());
        this.linkHeader.CreationTime = new Date(System.currentTimeMillis());
        this.linkHeader.WriteTime = new Date(System.currentTimeMillis());
        this.target = target;
        this.idList = new LinkTargetIDList(target, isDirectory);
    }

    public void setIcon(String iconLocation) {
        this.linkHeader.LinkFlags.HasIconLocation = true;
        this.stringData.ICON_LOCATION = iconLocation;
    }

    public void setShowWindowMode(int mode) {
        this.linkHeader.ShowCommand = mode;
    }

    public void save(File saveLocation) {
        if (this.isRelativeTarget) {
            int lastIndex = this.target.lastIndexOf("\\");
            String targetDir = this.target.substring(0, lastIndex);
            String targetFile = this.target.substring(lastIndex + 1);
            String targetPath = targetDir + "\\";
            String relativePath = Utils.getRelativePath(targetPath, saveLocation.getAbsolutePath(), "\\");
            if (!relativePath.startsWith(".")) {
                relativePath = ".\\" + relativePath;
            }
            this.stringData.RELATIVE_PATH = relativePath + targetFile;
            this.linkHeader.LinkFlags.HasWorkingDir = true;
            this.stringData.WORKING_DIR = targetDir;
        }
        try {
            if (!saveLocation.exists()) {
                saveLocation.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(saveLocation);
            out.write(this.linkHeader.toBytes());
            if (this.linkHeader.LinkFlags.HasLinkTargetIDList) {
                byte[] bytes = this.idList.toBytes();
                out.write(Utils.fromInt16(bytes.length));
                out.write(bytes);
            }
            out.write(this.stringData.toBytes(this.linkHeader.LinkFlags));
            out.write(new byte[]{0, 0, 0, 0});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse(byte[] data) {
        ByteBuffer buff = ByteBuffer.wrap(data);
        byte[] buffArr = new byte[76];
        buff.get(buffArr);
        this.linkHeader = new ShellLinkHeader(buffArr);
        if (this.linkHeader.LinkFlags.HasLinkTargetIDList) {
            buffArr = new byte[Utils.toInt16(data, buff.position())];
            buff.get(buffArr);
            this.idList = new LinkTargetIDList(buffArr);
            assert (buff.get() == 0);
            assert (buff.get() == 0);
        }
        if (this.linkHeader.LinkFlags.HasLinkInfo) {
            buffArr = new byte[Utils.toInt16(data, buff.position())];
            buff.get(buffArr);
            this.linkInfo = new LinkInfo(buffArr);
        }
        this.stringData = new StringData(data, buff.position(), this.linkHeader.LinkFlags);
        buff.position(this.stringData.newOffset);
        this.extraData = new ExtraData(data, buff.position(), this.linkHeader.LinkFlags.IsUnicode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Shell Link Header").append("\n[\n");
        sb.append(this.linkHeader).append("\n]\n");
        sb.append("Link Target IDList").append("\n[\n");
        sb.append(this.idList).append("\n]\n");
        sb.append("Link Info").append("\n[\n");
        sb.append(this.linkInfo).append("\n]\n");
        sb.append("String Data").append("\n[\n");
        sb.append(this.stringData).append("\n]\n");
        sb.append("Extra Data").append("\n[\n");
        sb.append(this.extraData).append("\n]");
        return sb.toString();
    }
}

