/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.util.Vector;
import reg.Converter;
import reg.RegCell;
import reg.RegHeader;
import reg.RegVal;

public class RegValList
extends RegCell {
    private Vector<Integer> localOffs;
    private int entNum;
    private Vector<RegVal> values;

    public RegValList(RegHeader head, RegCell theParent, byte[] buff, int offset, int num) {
        this.header = head;
        this.owner = theParent;
        if (this.header == null) {
            this.entNum = 1;
        }
        this.entNum = num;
        this.read(buff, offset);
        this.values = new Vector(this.entNum);
        for (int i = 0; i < this.entNum; ++i) {
            this.values.add(new RegVal(this.header, this.owner, buff, 4096 + this.localOffs.elementAt(i)));
        }
        this.sort();
    }

    public RegValList(RegHeader head, RegCell theParent, RegVal val) {
        this.header = head;
        this.owner = theParent;
        if (this.header == null) {
            this.entNum = 1;
        }
        this.entNum = 1;
        this.values = new Vector();
        this.values.add(val);
        this.localOffs = new Vector();
        this.localOffs.add(val.getOffset() - 4096);
        this.size = -8;
    }

    @Override
    public void read(byte[] buff, int offset) {
        super.read(buff, offset);
        this.localOffs = new Vector(this.entNum);
        for (int i = 0; i < this.entNum; ++i) {
            this.localOffs.add(Converter.byteArrayToInt(buff, offset + 4 + i * 4));
        }
    }

    @Override
    public void write(byte[] buff, int offset) {
        super.write(buff, offset);
        for (int i = 0; i < this.localOffs.size(); ++i) {
            Converter.intToByteArray(this.localOffs.elementAt(i), buff, offset + 4 + i * 4);
        }
    }

    public RegVal getVal(String name) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.values.elementAt(i).getName().equals(name)) continue;
            return this.values.elementAt(i);
        }
        return null;
    }

    public Vector<RegVal> getVals() {
        return this.values;
    }

    public void addValue(RegVal val) {
        if (val == null) {
            throw new NullPointerException();
        }
        String cmp = val.getName();
        boolean inserted = false;
        for (int j = 0; j < this.entNum; ++j) {
            if (cmp.compareToIgnoreCase(this.values.elementAt(j).getName()) >= 0) continue;
            this.values.insertElementAt(val, j);
            this.localOffs.insertElementAt(val.getOffset() - 4096, j);
            inserted = true;
            break;
        }
        if (!inserted) {
            this.values.add(val);
            this.localOffs.add(val.getOffset() - 4096);
        }
        ++this.entNum;
        this.size = -Converter.round8(4 + 4 * this.entNum);
    }

    public void removeValue(String name) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.values.elementAt(i).getName().equals(name)) continue;
            this.localOffs.remove(i);
            this.values.remove(i);
            --this.entNum;
            this.size = -Converter.round8(4 + 4 * this.entNum);
            return;
        }
    }

    public void cleanup() {
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.elementAt(i).cleanup();
        }
        this.deallocate();
    }

    public void commit(byte[] buffer) {
        this.write(buffer, this.absOffset);
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.elementAt(i).commit(buffer);
        }
    }

    public RegVal getVal(int index) {
        if (index >= 0 && index < this.values.size()) {
            return this.values.elementAt(index);
        }
        return null;
    }

    public int getNumEntries() {
        return this.entNum;
    }

    public void sort() {
        for (int i = 0; i < this.values.size() - 1; ++i) {
            int min = i;
            for (int j = min + 1; j < this.values.size(); ++j) {
                if (this.values.elementAt(min).getName().compareToIgnoreCase(this.values.elementAt(j).getName()) <= 0) continue;
                min = j;
            }
            if (min == i) continue;
            RegVal tmpv = this.values.elementAt(min);
            int tmpi = this.localOffs.elementAt(min);
            this.localOffs.removeElementAt(min);
            this.values.removeElementAt(min);
            this.localOffs.insertElementAt(tmpi, i);
            this.values.insertElementAt(tmpv, i);
        }
    }
}

