/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.Vector;
import reg.Converter;
import reg.RegCell;
import reg.RegData;
import reg.RegHeader;

public class RegVal
extends RegCell {
    private short nameLen;
    private int dataLen;
    private int dataOff;
    private int dataType;
    private short flags;
    private String valName;
    private RegData data;
    private byte[] rawoffset = new byte[8];
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_LITTLE_ENDIAN = 4;
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    public static final int REG_LINK = 6;
    public static final int REG_MULTI_SZ = 7;
    public static final int REG_RESOURCE_LIST = 8;
    public static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    public static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    public static final int REG_QWORD = 11;

    public RegVal(RegHeader head, RegCell myParent, String name, RegData data, int type, int len) {
        this.header = head;
        this.owner = myParent;
        if (name == null) {
            throw new NullPointerException();
        }
        this.nameLen = (short)name.length();
        this.dataLen = len;
        if (data != null) {
            this.dataOff = data.getOffset() - 4096;
        }
        this.dataType = type;
        this.flags = 1;
        this.valName = name;
        this.data = data;
        this.size = -Converter.round8(24 + this.nameLen);
    }

    public RegVal(RegHeader head, RegCell myParent, String name, int type, byte[] newBytes) {
        this.header = head;
        this.owner = myParent;
        if (name == null) {
            throw new NullPointerException();
        }
        this.nameLen = (short)name.length();
        this.dataLen = newBytes.length | Integer.MIN_VALUE;
        System.arraycopy(newBytes, 0, this.rawoffset, 0, newBytes.length);
        this.dataOff = Converter.byteArrayToInt(newBytes);
        this.dataType = type;
        this.flags = 1;
        this.valName = name;
        this.data = null;
        this.getValue();
        this.size = -Converter.round8(24 + this.nameLen);
    }

    public RegVal(RegHeader head, RegCell myParent, byte[] buff, int offset) {
        this.read(buff, offset);
        this.header = head;
        this.owner = myParent;
        this.data = this.dataLen <= 0 ? null : new RegData(this.header, buff, 4096 + this.dataOff, this.dataLen);
    }

    @Override
    public void read(byte[] buff, int offset) {
        super.read(buff, offset);
        this.nameLen = Converter.byteArrayToShort(buff, offset + 6);
        this.dataLen = Converter.byteArrayToInt(buff, offset + 8);
        this.dataOff = Converter.byteArrayToInt(buff, offset + 12);
        this.dataType = Converter.byteArrayToInt(buff, offset + 16);
        this.flags = Converter.byteArrayToShort(buff, offset + 20);
        this.valName = new String(buff, offset + 24, (int)this.nameLen);
        System.arraycopy(buff, offset + 12, this.rawoffset, 0, 8);
    }

    @Override
    public void write(byte[] buff, int offset) {
        super.write(buff, offset);
        Converter.shortToByteArray((short)27510, buff, offset + 4);
        Converter.shortToByteArray(this.nameLen, buff, offset + 6);
        Converter.intToByteArray(this.dataLen, buff, offset + 8);
        Converter.intToByteArray(this.dataOff, buff, offset + 12);
        Converter.intToByteArray(this.dataType, buff, offset + 16);
        Converter.shortToByteArray(this.flags, buff, offset + 20);
        try {
            byte[] arr = this.valName.getBytes("US-ASCII");
            System.arraycopy(arr, 0, buff, offset + 24, this.nameLen);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.valName;
    }

    public void setName(String valName) {
        this.valName = valName;
        this.nameLen = (short)valName.length();
    }

    public void setDataOffset(int off) {
        this.dataOff = off;
    }

    public int getType() {
        return this.dataType;
    }

    public RegVal getClone() {
        byte[] bytes = this.getValueRaw();
        RegData actData = new RegData(this.header, bytes);
        actData.allocate();
        RegVal result = new RegVal(this.header, this.owner, this.valName, actData, this.getType(), this.dataLen);
        result.allocate();
        return result;
    }

    public String toString() {
        Object bytedata = this.getValue();
        switch (this.dataType) {
            case 0: 
            case 3: {
                return Converter.byteArrayToHexString((byte[])bytedata, this.dataLen & Integer.MAX_VALUE);
            }
            case 4: 
            case 5: {
                Integer i = (Integer)bytedata;
                return Converter.decimalToHexNumber(i.longValue(), this.dataLen) + " (" + i.toString() + ")";
            }
            case 11: {
                Long l = (Long)bytedata;
                return Converter.decimalToHexNumber(l, this.dataLen) + " (" + l.toString() + ")";
            }
            case 1: 
            case 2: 
            case 6: {
                if (bytedata != null) {
                    return bytedata.toString();
                }
                return null;
            }
            case 7: {
                String result = "";
                Vector tmp = (Vector)bytedata;
                for (int j = 0; j < tmp.size(); ++j) {
                    if (!result.equals("")) {
                        result = result + ", ";
                    }
                    result = result + tmp.elementAt(j);
                }
                return result;
            }
        }
        return null;
    }

    public void cleanup() {
        if (this.data != null) {
            this.data.cleanup();
        }
        this.deallocate();
    }

    public void commit(byte[] buffer) {
        this.write(buffer, this.absOffset);
        if (this.data != null) {
            this.data.commit(buffer);
        }
    }

    public String typeString() {
        return this.typeString(this.dataType);
    }

    public String typeString(int typ) {
        switch (typ) {
            case 0: {
                return "REG_NONE";
            }
            case 1: {
                return "REG_SZ";
            }
            case 2: {
                return "REG_EXPAND_SZ";
            }
            case 3: {
                return "REG_BINARY";
            }
            case 4: {
                return "REG_DWORD";
            }
            case 5: {
                return "REG_DWORD_BIG_ENDIAN";
            }
            case 6: {
                return "REG_LINK";
            }
            case 7: {
                return "REG_MULTI_SZ";
            }
            case 8: {
                return "REG_RESOURCE_LIST";
            }
            case 9: {
                return "REG_FULL_RESOURCE_DESCRIPTOR";
            }
            case 10: {
                return "REG_RESOURCE_REQUIREMENTS_LIST";
            }
            case 11: {
                return "REG_QWORD";
            }
        }
        return "";
    }

    public final Object getValue() {
        Object bytedata = null;
        byte[] raw = this.data == null ? this.rawoffset : this.data.getData();
        switch (this.dataType) {
            case 0: 
            case 3: {
                return raw;
            }
            case 4: 
            case 5: {
                bytedata = new Integer(Converter.byteArrayToInt(raw, 0));
                return bytedata;
            }
            case 1: 
            case 2: 
            case 6: {
                int len = 0;
                while (!(raw[len] == 0 & raw[len + 1] == 0) && (len += 2) != raw.length) {
                }
                byte[] trimmed = new byte[len];
                System.arraycopy(raw, 0, trimmed, 0, len);
                try {
                    CharsetDecoder dec = Charset.forName("UTF-16LE").newDecoder();
                    bytedata = dec.decode(ByteBuffer.wrap(trimmed)).toString();
                    return bytedata;
                }
                catch (CharacterCodingException e) {
                    // empty catch block
                }
            }
            case 11: {
                bytedata = new Long(Converter.byteArrayToLong(raw, 0));
                return bytedata;
            }
            case 7: {
                Vector<String> lst = new Vector<String>();
                CharsetDecoder dec = Charset.forName("UTF-16LE").newDecoder();
                int start = 0;
                int end = 0;
                try {
                    do {
                        for (int i = start; i < raw.length - 1; i += 2) {
                            if (raw[i] != 0 || raw[i + 1] != 0) continue;
                            end = i;
                            break;
                        }
                        if (end == 0) {
                            end = raw.length - 2;
                        }
                        byte[] tmp = Arrays.copyOfRange(raw, start, end);
                        lst.add(dec.decode(ByteBuffer.wrap(tmp)).toString());
                        start = end + 2;
                        end = 0;
                    } while (start < raw.length - 1 && (raw[start] != 0 || raw[start + 1] != 0));
                }
                catch (CharacterCodingException e) {
                    e.printStackTrace();
                }
                return lst;
            }
        }
        return null;
    }

    public byte[] getValueRaw() {
        if (this.data == null) {
            int actLen = this.dataLen & Integer.MAX_VALUE;
            byte[] returnBytes = new byte[actLen];
            System.arraycopy(this.rawoffset, 0, returnBytes, 0, actLen);
            return returnBytes;
        }
        byte[] returnBytes = new byte[this.dataLen];
        System.arraycopy(this.data.getData(), 0, returnBytes, 0, this.dataLen);
        return returnBytes;
    }

    public void replaceDataRecord(byte[] newBytes) {
        this.data.replaceDataRecord(newBytes);
    }
}

