/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.util.Vector;
import reg.Converter;
import reg.RegCell;
import reg.RegHeader;
import reg.RegKey;
import reg.RegKeyList;
import reg.RegKeyListLF;
import reg.RegKeyListLH;
import reg.RegKeyListLI;

public class RegKeyListRI
extends RegKeyList {
    private Vector<Integer> localOffs;
    private Vector<RegKeyList> childList;

    public RegKeyListRI(RegHeader head, RegKey myParent, byte[] buff, int offset) {
        super(buff, offset);
        this.header = head;
        this.owner = myParent;
        this.read(buff, offset);
        this.childList = new Vector(this.entNum);
        block5: for (int i = 0; i < this.entNum; ++i) {
            int theOffset = 4096 + this.localOffs.elementAt(i);
            int sklType = RegCell.identify(buff, theOffset);
            switch (sklType) {
                case 3: {
                    this.childList.add(new RegKeyListLF(this.header, this, buff, theOffset));
                    continue block5;
                }
                case 4: {
                    this.childList.add(new RegKeyListLH(this.header, this, buff, theOffset));
                    continue block5;
                }
                case 6: {
                    this.childList.add(new RegKeyListLI(this.header, this, buff, theOffset));
                }
            }
        }
    }

    @Override
    public RegKey getKey(String name) {
        for (int i = 0; i < this.childList.size(); ++i) {
            RegKey tmp = this.childList.elementAt(i).getKey(name);
            if (tmp == null) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public void read(byte[] buff, int offset) {
        super.read(buff, offset);
        this.localOffs = new Vector(this.entNum);
        for (int i = 0; i < this.entNum; ++i) {
            this.localOffs.add(new Integer(Converter.byteArrayToInt(buff, offset + 8 + i * 4)));
        }
    }

    @Override
    public void write(byte[] buff, int offset) {
        super.write(buff, offset);
        Converter.shortToByteArray((short)26994, buff, offset + 4);
        for (int i = 0; i < this.localOffs.size(); ++i) {
            Converter.intToByteArray(this.localOffs.elementAt(i), buff, offset + 8 + i * 4);
        }
    }

    @Override
    public Vector<RegKey> getSubkeys() {
        Vector<RegKey> retval = new Vector<RegKey>(this.childList.size() * 5);
        for (int i = 0; i < this.childList.size(); ++i) {
            retval.addAll(this.childList.elementAt(i).getSubkeys());
        }
        return retval;
    }

    @Override
    public void addKey(RegKey key) {
        Vector<RegKey> act;
        String actName;
        int idx;
        String keyName = key.getKeyName().toUpperCase();
        RegKeyList theItem = null;
        for (idx = 0; idx < this.childList.size() && (actName = (act = (theItem = this.childList.elementAt(idx)).getSubkeys()).elementAt(act.size() - 1).getKeyName()).toUpperCase().compareTo(keyName) <= 0; ++idx) {
        }
        if (theItem != null) {
            theItem.addKey(key);
            theItem.reallocate();
            this.localOffs.setElementAt(theItem.getOffset() - 4096, idx);
        }
    }

    @Override
    public void removeKey(String name) {
        int idx;
        RegKeyList theItem = null;
        boolean found = false;
        for (idx = 0; idx < this.childList.size(); ++idx) {
            theItem = this.childList.elementAt(idx);
            Vector<RegKey> act = theItem.getSubkeys();
            for (int i = 0; i < act.size(); ++i) {
                String actName = act.elementAt(i).getKeyName();
                if (!actName.equalsIgnoreCase(name)) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (theItem != null) {
            theItem.removeKey(name);
            theItem.reallocate();
            this.localOffs.setElementAt(theItem.getOffset() - 4096, idx);
        }
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < this.childList.size(); ++i) {
            this.childList.elementAt(i).cleanup();
        }
        this.deallocate();
    }

    @Override
    public void commit(byte[] buffer) {
        this.write(buffer, this.absOffset);
        for (int i = 0; i < this.childList.size(); ++i) {
            this.childList.elementAt(i).commit(buffer);
        }
    }

    @Override
    public void moveKey(String newKeyName) {
    }
}

