/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.util.Vector;
import reg.Converter;
import reg.RegCell;
import reg.RegHeader;
import reg.RegKey;
import reg.RegKeyList;

public class RegKeyListLI
extends RegKeyList {
    private Vector<Integer> localOffs;
    private Vector<RegKey> subkeys;

    public RegKeyListLI(RegHeader head, RegCell myParent, byte[] buff, int offset) {
        super(buff, offset);
        this.header = head;
        this.owner = myParent;
        this.read(buff, offset);
        this.subkeys = new Vector(this.entNum);
        for (int i = 0; i < this.entNum; ++i) {
            this.subkeys.add(new RegKey(this.header, this.owner, buff, 4096 + this.localOffs.elementAt(i)));
        }
    }

    public RegKeyListLI(RegHeader head, RegKey key) {
        this.header = head;
        if (key == null) {
            this.localOffs = null;
            this.subkeys = null;
            return;
        }
        this.localOffs = new Vector();
        this.localOffs.add(key.getOffset() - 4096);
        this.subkeys = new Vector();
        this.subkeys.add(key);
        this.entNum = 1;
        this.size = -Converter.round8(12);
    }

    @Override
    public RegKey getKey(String name) {
        for (int i = 0; i < this.subkeys.size(); ++i) {
            if (!this.subkeys.elementAt(i).getKeyName().equals(name)) continue;
            return this.subkeys.elementAt(i);
        }
        return null;
    }

    @Override
    public void read(byte[] buff, int offset) {
        super.read(buff, offset);
        this.localOffs = new Vector(this.entNum);
        for (int i = 0; i < this.entNum; ++i) {
            this.localOffs.add(Converter.byteArrayToInt(buff, offset + 8 + i * 4));
        }
    }

    @Override
    public void write(byte[] buff, int offset) {
        super.write(buff, offset);
        Converter.shortToByteArray((short)26988, buff, offset + 4);
        for (int i = 0; i < this.localOffs.size(); ++i) {
            Converter.intToByteArray(this.localOffs.elementAt(i), buff, offset + 8 + i * 4);
        }
    }

    @Override
    public Vector<RegKey> getSubkeys() {
        return this.subkeys;
    }

    @Override
    public void addKey(RegKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String cmp = key.getKeyName();
        boolean inserted = false;
        for (int j = 0; j < this.entNum; ++j) {
            if (cmp.compareToIgnoreCase(this.subkeys.elementAt(j).getKeyName()) >= 0) continue;
            this.subkeys.insertElementAt(key, j);
            this.localOffs.insertElementAt(key.getOffset() - 4096, j);
            inserted = true;
            break;
        }
        if (!inserted) {
            this.subkeys.add(key);
            this.localOffs.add(key.getOffset() - 4096);
        }
        this.entNum = (short)(this.entNum + 1);
        this.size = -Converter.round8(8 + 4 * this.entNum);
    }

    @Override
    public void removeKey(String name) {
        for (int i = 0; i < this.subkeys.size(); ++i) {
            if (!this.subkeys.elementAt(i).getKeyName().equals(name)) continue;
            this.localOffs.remove(i);
            this.subkeys.remove(i);
            this.entNum = (short)(this.entNum - 1);
            this.size = -Converter.round8(8 + 4 * this.entNum);
            return;
        }
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < this.subkeys.size(); ++i) {
            this.subkeys.elementAt(i).cleanup();
        }
        this.deallocate();
    }

    @Override
    public void commit(byte[] buffer) {
        this.write(buffer, this.absOffset);
        for (int i = 0; i < this.subkeys.size(); ++i) {
            this.subkeys.elementAt(i).commit(buffer);
        }
    }

    @Override
    public void moveKey(String newKeyName) {
        RegKey tmpk = null;
        for (int j = 0; j < this.entNum; ++j) {
            if (newKeyName.compareToIgnoreCase(this.subkeys.elementAt(j).getKeyName()) != 0) continue;
            tmpk = this.subkeys.elementAt(j);
            this.localOffs.removeElementAt(j);
            this.subkeys.removeElementAt(j);
            break;
        }
        boolean inserted = false;
        for (int j = 0; j < this.entNum - 1; ++j) {
            if (newKeyName.compareToIgnoreCase(this.subkeys.elementAt(j).getKeyName()) >= 0) continue;
            this.subkeys.insertElementAt(tmpk, j);
            this.localOffs.insertElementAt(tmpk.getOffset() - 4096, j);
            inserted = true;
            break;
        }
        if (!inserted) {
            this.subkeys.add(tmpk);
            this.localOffs.add(tmpk.getOffset() - 4096);
        }
    }
}

