/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.util.Vector;
import reg.Converter;
import reg.RegCell;
import reg.RegHeader;
import reg.RegKey;
import reg.RegKeyList;

public class RegKeyListLF
extends RegKeyList {
    private Vector<Integer> localOffs;
    private Vector<String> hash;
    private Vector<RegKey> subkeys;

    @Override
    public RegKey getKey(String name) {
        for (int i = 0; i < this.subkeys.size(); ++i) {
            if (!this.subkeys.elementAt(i).getKeyName().equals(name)) continue;
            return this.subkeys.elementAt(i);
        }
        return null;
    }

    public RegKeyListLF(RegHeader head, RegCell myParent, byte[] buff, int offset) {
        super(buff, offset);
        this.header = head;
        this.owner = myParent;
        this.read(buff, offset);
        this.subkeys = new Vector(this.entNum);
        for (int i = 0; i < this.entNum; ++i) {
            this.subkeys.add(new RegKey(this.header, this.owner, buff, 4096 + this.localOffs.elementAt(i)));
        }
    }

    @Override
    public void read(byte[] buff, int offset) {
        super.read(buff, offset);
        this.localOffs = new Vector(this.entNum);
        this.hash = new Vector(this.entNum);
        for (int i = 0; i < this.entNum; ++i) {
            this.localOffs.add(Converter.byteArrayToInt(buff, offset + 8 + i * 8));
            this.hash.add(Converter.byteArrayToStr(buff, offset + 12 + i * 8));
        }
    }

    @Override
    public void write(byte[] buff, int offset) {
        super.write(buff, offset);
        Converter.shortToByteArray((short)26220, buff, offset + 4);
        for (int i = 0; i < this.localOffs.size(); ++i) {
            Converter.intToByteArray(this.localOffs.elementAt(i), buff, offset + 8 + i * 8);
            Converter.strToByteArray(this.hash.elementAt(i), buff, offset + 12 + i * 8);
        }
    }

    @Override
    public Vector<RegKey> getSubkeys() {
        return this.subkeys;
    }

    @Override
    public void addKey(RegKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String cmp = key.getKeyName();
        boolean inserted = false;
        for (int j = 0; j < this.entNum; ++j) {
            if (cmp.compareToIgnoreCase(this.subkeys.elementAt(j).getKeyName()) >= 0) continue;
            this.subkeys.insertElementAt(key, j);
            this.localOffs.insertElementAt(key.getOffset() - 4096, j);
            this.hash.insertElementAt(String.format("%1$-4s", key.getKeyName()).replace(' ', '\u0000'), j);
            inserted = true;
            break;
        }
        if (!inserted) {
            this.subkeys.add(key);
            this.localOffs.add(key.getOffset() - 4096);
            this.hash.add(String.format("%1$-4s", key.getKeyName()).replace(' ', '\u0000'));
        }
        this.entNum = (short)(this.entNum + 1);
        this.size -= 8;
    }

    @Override
    public void removeKey(String name) {
        for (int i = 0; i < this.subkeys.size(); ++i) {
            if (!this.subkeys.elementAt(i).getKeyName().equals(name)) continue;
            this.localOffs.remove(i);
            this.hash.remove(i);
            this.subkeys.remove(i);
            this.entNum = (short)(this.entNum - 1);
            this.size += 8;
            return;
        }
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < this.subkeys.size(); ++i) {
            this.subkeys.elementAt(i).cleanup();
        }
        this.deallocate();
    }

    @Override
    public void commit(byte[] buffer) {
        this.write(buffer, this.absOffset);
        for (int i = 0; i < this.subkeys.size(); ++i) {
            this.subkeys.elementAt(i).commit(buffer);
        }
    }

    @Override
    public void moveKey(String newKeyName) {
        RegKey tmpk = null;
        for (int j = 0; j < this.entNum; ++j) {
            if (newKeyName.compareToIgnoreCase(this.subkeys.elementAt(j).getKeyName()) != 0) continue;
            tmpk = this.subkeys.elementAt(j);
            this.hash.removeElementAt(j);
            this.localOffs.removeElementAt(j);
            this.subkeys.removeElementAt(j);
            break;
        }
        boolean inserted = false;
        for (int j = 0; j < this.entNum - 1; ++j) {
            if (newKeyName.compareToIgnoreCase(this.subkeys.elementAt(j).getKeyName()) >= 0) continue;
            this.subkeys.insertElementAt(tmpk, j);
            this.localOffs.insertElementAt(tmpk.getOffset() - 4096, j);
            this.hash.insertElementAt(String.format("%1$-4s", newKeyName).replace(' ', '\u0000'), j);
            inserted = true;
            break;
        }
        if (!inserted) {
            this.subkeys.add(tmpk);
            this.localOffs.add(tmpk.getOffset() - 4096);
            this.hash.add(String.format("%1$-4s", newKeyName).replace(' ', '\u0000'));
        }
    }
}

