/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import reg.Converter;
import reg.RegCell;
import reg.RegData;
import reg.RegEntity;
import reg.RegExport;
import reg.RegHeader;
import reg.RegKeyList;
import reg.RegKeyListLF;
import reg.RegKeyListLH;
import reg.RegKeyListLI;
import reg.RegKeyListRI;
import reg.RegVal;
import reg.RegValList;

public class RegKey
extends RegCell {
    private short flags;
    private long time;
    private int parentOff;
    private int childNum;
    private int childListOff;
    private int valNum;
    private int valListOff;
    private int skOff;
    private int classNameOff;
    private short keyNameLen;
    private short classNameLen;
    private String keyName;
    private String className;
    private RegKeyList childList = null;
    private RegValList valList = null;

    public RegKey(RegHeader head, RegCell myParent, String name, RegData className) {
        this.header = head;
        this.owner = myParent;
        this.flags = (short)32;
        this.time = Converter.systemTimeToFileTime(Calendar.getInstance().getTimeInMillis());
        this.parentOff = this.owner.getOffset() - 4096;
        this.childNum = 0;
        this.childListOff = -1;
        this.valNum = 0;
        this.valListOff = -1;
        this.skOff = ((RegKey)this.owner).skOff;
        this.keyName = name;
        this.keyNameLen = (short)name.length();
        if (className != null) {
            this.classNameOff = className.getOffset() - 4096;
            this.classNameLen = (short)(className.getSize() - 4);
            this.className = new String(className.getData(), 0, className.getSize() - 4);
        } else {
            this.classNameOff = -1;
            this.classNameLen = 0;
            this.className = null;
        }
        this.size = -Converter.round8(80 + this.keyNameLen);
        this.owner = myParent;
    }

    public RegKey(RegHeader head, RegCell myParent, byte[] buff, int offset) {
        this.owner = myParent;
        this.header = head;
        this.read(buff, offset);
        if (this.childNum > 0) {
            int sklType = RegEntity.identify(buff, 4096 + this.childListOff);
            switch (sklType) {
                case 3: {
                    this.childList = new RegKeyListLF(this.header, this, buff, 4096 + this.childListOff);
                    break;
                }
                case 4: {
                    this.childList = new RegKeyListLH(this.header, this, buff, 4096 + this.childListOff);
                    break;
                }
                case 6: {
                    this.childList = new RegKeyListLI(this.header, this, buff, 4096 + this.childListOff);
                    break;
                }
                case 5: {
                    this.childList = new RegKeyListRI(this.header, this, buff, 4096 + this.childListOff);
                }
            }
        }
        if (this.valNum > 0) {
            this.valList = new RegValList(this.header, this, buff, 4096 + this.valListOff, this.valNum);
        }
    }

    public RegKey(RegHeader head, byte[] buff, int offset) {
        this(head, null, buff, offset);
    }

    @Override
    public void read(byte[] buff, int offset) {
        super.read(buff, offset);
        this.flags = Converter.byteArrayToShort(buff, offset + 6);
        this.time = Converter.byteArrayToLong(buff, offset + 8);
        this.parentOff = Converter.byteArrayToInt(buff, offset + 20);
        this.childNum = Converter.byteArrayToInt(buff, offset + 24);
        this.childListOff = Converter.byteArrayToInt(buff, offset + 32);
        this.valNum = Converter.byteArrayToInt(buff, offset + 40);
        this.valListOff = Converter.byteArrayToInt(buff, offset + 44);
        this.skOff = Converter.byteArrayToInt(buff, offset + 48);
        this.classNameOff = Converter.byteArrayToInt(buff, offset + 52);
        this.keyNameLen = Converter.byteArrayToShort(buff, offset + 76);
        this.classNameLen = Converter.byteArrayToShort(buff, offset + 78);
        this.keyName = new String(buff, offset + 80, (int)this.keyNameLen);
        int something0x1C = Converter.byteArrayToInt(buff, offset + 28);
        int something0x24 = Converter.byteArrayToInt(buff, offset + 36);
        int something0x38 = Converter.byteArrayToInt(buff, offset + 56);
        int something0x3C = Converter.byteArrayToInt(buff, offset + 60);
        int something0x40 = Converter.byteArrayToInt(buff, offset + 64);
        int something0x44 = Converter.byteArrayToInt(buff, offset + 68);
        int something0x48 = Converter.byteArrayToInt(buff, offset + 72);
        if (this.classNameLen > 0) {
            this.className = new String(buff, this.classNameOff + 4096, (int)this.classNameLen);
        }
    }

    @Override
    public void write(byte[] buff, int offset) {
        super.write(buff, offset);
        Converter.shortToByteArray((short)27502, buff, offset + 4);
        Converter.shortToByteArray(this.flags, buff, offset + 6);
        Converter.longToByteArray(this.time, buff, offset + 8);
        Converter.intToByteArray(0, buff, offset + 12);
        Converter.intToByteArray(this.parentOff, buff, offset + 20);
        Converter.intToByteArray(this.childNum, buff, offset + 24);
        Converter.intToByteArray(0, buff, offset + 28);
        Converter.intToByteArray(this.childListOff, buff, offset + 32);
        Converter.intToByteArray(-1, buff, offset + 36);
        Converter.intToByteArray(this.valNum, buff, offset + 40);
        Converter.intToByteArray(this.valListOff, buff, offset + 44);
        Converter.intToByteArray(this.skOff, buff, offset + 48);
        Converter.intToByteArray(this.classNameOff, buff, offset + 52);
        Converter.intToByteArray(0, buff, offset + 56);
        Converter.intToByteArray(0, buff, offset + 60);
        Converter.shortToByteArray(this.keyNameLen, buff, offset + 76);
        Converter.shortToByteArray(this.classNameLen, buff, offset + 78);
        try {
            byte[] arr = this.keyName.getBytes("US-ASCII");
            System.arraycopy(arr, 0, buff, offset + 80, arr.length);
            if (this.className != null) {
                arr = this.className.getBytes("US-ASCII");
                System.arraycopy(arr, 0, buff, this.classNameOff + 4096, this.classNameLen);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public RegVal renameValue(String actValName, String newValName) {
        RegVal actVal = this.getVal(actValName);
        if (newValName != null && !newValName.equals(actValName)) {
            actVal.setName(newValName);
            actVal.reallocate();
            this.valList.sort();
            this.valList.reallocate();
            this.reallocate();
            this.header.makeDirty();
        }
        return actVal;
    }

    public RegKey rename(String actKeyName, String newKeyName) {
        if (newKeyName != null && !newKeyName.equals(actKeyName)) {
            int delta = newKeyName.length() - this.keyNameLen;
            this.setKeyName(newKeyName);
            this.size = -Converter.round8(80 + this.keyNameLen);
            this.reallocate();
            RegKeyList theList = ((RegKey)this.owner).getChildList();
            theList.moveKey(newKeyName);
            theList.reallocate();
            this.header.makeDirty();
        }
        return this;
    }

    public RegKey getKey(String name) {
        String locCopy = Converter.preformatPath(name);
        if (locCopy.indexOf(92) == -1 && !locCopy.isEmpty() && this.keyName.equals(locCopy)) {
            return this;
        }
        String first = locCopy.substring(0, locCopy.indexOf(92));
        if (!first.equals(this.keyName)) {
            return null;
        }
        if (this.childList == null) {
            return null;
        }
        String second = (locCopy = locCopy.substring(locCopy.indexOf(92) + 1)).indexOf(92) == -1 ? locCopy : locCopy.substring(0, locCopy.indexOf(92));
        RegKey child = this.childList.getKey(second);
        if (child == null) {
            return null;
        }
        return child.getKey(locCopy);
    }

    public RegVal getVal(String name) {
        String locCopy = Converter.preformatPath(name);
        if (this.valList == null) {
            return null;
        }
        return this.valList.getVal(locCopy);
    }

    public String getPath() {
        String res = this.getKeyName();
        RegKey loopKey = this;
        while ((loopKey = loopKey.getParent()) != null) {
            res = loopKey.getKeyName() + "\\" + res;
        }
        return res;
    }

    public RegKey getParent() {
        if (this.owner instanceof RegKeyListRI) {
            return (RegKey)this.owner.owner;
        }
        return (RegKey)this.owner;
    }

    public boolean regExport(String theExport) {
        return this.regExport(new File(theExport));
    }

    public boolean regExport(File theExport) {
        RegExport exporter = new RegExport(this, theExport);
        boolean result = exporter.action();
        exporter.close();
        return result;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
        this.keyNameLen = (short)keyName.length();
    }

    public String toString() {
        return this.keyName;
    }

    private void updateTime() {
        this.time = Converter.systemTimeToFileTime(Calendar.getInstance().getTimeInMillis());
    }

    public boolean addKey(RegKey key) {
        if (this.childList == null) {
            RegKeyListLI list = new RegKeyListLI(this.header, key);
            this.childList = list;
            this.childList.allocate();
        } else {
            this.childList.addKey(key);
        }
        ++this.childNum;
        if (!(this.childList instanceof RegKeyListRI)) {
            this.childList.reallocate();
            this.childListOff = this.childList.getOffset() - 4096;
        }
        return true;
    }

    public boolean removeKey(String name) {
        RegKey target = this.childList.getKey(name);
        if (target == null) {
            return false;
        }
        this.childList.removeKey(name);
        if (this.childNum == 1) {
            this.childListOff = -1;
            this.childList.deallocate();
            this.childList = null;
        } else if (!(this.childList instanceof RegKeyListRI)) {
            this.childList.reallocate();
            this.childListOff = this.childList.getOffset() - 4096;
        }
        --this.childNum;
        target.cleanup();
        return true;
    }

    public void addValue(RegVal value) {
        if (this.valList == null || this.valNum == 0) {
            this.valList = new RegValList(this.header, this, value);
            this.valList.allocate();
        } else {
            this.valList.addValue(value);
        }
        this.valList.reallocate();
        this.valListOff = this.valList.getOffset() - 4096;
        ++this.valNum;
    }

    public void removeValue(String name) {
        RegVal target = this.valList.getVal(name);
        if (target == null) {
            return;
        }
        this.valList.removeValue(name);
        --this.valNum;
        if (this.valNum == 0) {
            this.valListOff = -1;
            this.valList.deallocate();
        } else {
            this.valList.reallocate();
            this.valListOff = this.valList.getOffset() - 4096;
        }
        target.cleanup();
    }

    public void cleanup() {
        if (this.childNum > 0) {
            this.childList.cleanup();
        }
        if (this.valNum > 0) {
            this.valList.cleanup();
        }
        this.deallocate();
    }

    public void commit(byte[] buffer) {
        this.write(buffer, this.absOffset);
        if (this.valList != null) {
            this.valList.commit(buffer);
        }
        if (this.childList != null) {
            this.childList.commit(buffer);
        }
    }

    public RegValList getValList() {
        return this.valList;
    }

    public RegKeyList getChildList() {
        return this.childList;
    }
}

