/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class RegImport {
    private File regFile;
    private ByteBuffer buffer;
    private boolean validReg = false;
    String actLine;
    String actKey;
    String actValue;
    Object actData;
    String actHive;
    byte[] actRawData;
    int actType;
    final String tagLine = "Windows Registry Editor Version 5.00";
    final String headUser = "HKEY_CURRENT_USER\\";
    final String headMachine = "HKEY_LOCAL_MACHINE\\";
    final String headSystem = "SYSTEM\\";
    final String headSoftware = "SOFTWARE\\";
    final String tag00 = "hex(0):";
    final String tag02 = "hex(2):";
    final String tag02a = "hex(02):";
    final String tag03 = "hex:";
    final String tag03a = "hex(3):";
    final String tag03b = "hex(03):";
    final String tag04 = "dword:";
    final String tag07 = "hex(7):";
    final String tagbad = "hex(";

    public RegImport(String fileName) throws FileNotFoundException, IOException {
        this.regFile = new File(fileName);
        if (this.regFile.exists()) {
            FileChannel srcChannel = new FileInputStream(this.regFile).getChannel();
            this.buffer = srcChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.regFile.length()).order(ByteOrder.LITTLE_ENDIAN);
            srcChannel.close();
            short x = this.buffer.getShort();
            if (x == -257) {
                this.getNextLine();
                this.validReg = this.actLine.equals("Windows Registry Editor Version 5.00");
            }
        }
    }

    public String getNextLine() {
        StringBuilder stringBuffer = new StringBuilder();
        String tmpLine = "\\";
        while (tmpLine.endsWith("\\")) {
            stringBuffer.delete(0, stringBuffer.length());
            tmpLine = tmpLine.substring(0, tmpLine.length() - 1);
            char ch = 'x';
            while (ch != '\n') {
                ch = this.buffer.getChar();
                stringBuffer.append(ch);
                if (this.buffer.position() != this.buffer.capacity()) continue;
                this.validReg = false;
                break;
            }
            if (stringBuffer.length() <= 1) continue;
            tmpLine = tmpLine + stringBuffer.substring(0, stringBuffer.length() - 2).trim();
        }
        this.actLine = tmpLine;
        return this.actLine;
    }

    public boolean isValid() {
        return this.validReg;
    }

    String noQuotes(String inp) {
        if (inp.equals("\"")) {
            return "";
        }
        if (inp.equals("\"\"")) {
            return "";
        }
        if (inp.startsWith("\"") && inp.endsWith("\"")) {
            return inp.substring(1, inp.length() - 1);
        }
        return inp;
    }

    byte[] hexToByteArray(String inp) {
        String hex = inp.replace(",", "");
        byte[] res = new byte[hex.length() / 2];
        int bi = 0;
        for (int i = 0; i < hex.length() - 1; i += 2) {
            String output = hex.substring(i, i + 2);
            int decimal = Integer.parseInt(output, 16);
            res[bi++] = (byte)decimal;
        }
        return res;
    }

    public LineType getLineType() {
        LineType returnType = LineType.UNKNOWN;
        if (this.actLine.equals("")) {
            return LineType.EMPTY;
        }
        if (this.actLine.startsWith("[")) {
            this.actKey = this.actLine.substring(1, this.actLine.length() - 1);
            if (this.actKey.toUpperCase().startsWith("HKEY_CURRENT_USER\\")) {
                this.actKey = this.actKey.substring("HKEY_CURRENT_USER\\".length());
                this.actHive = "defaultHive";
            } else if (this.actKey.toUpperCase().startsWith("HKEY_LOCAL_MACHINE\\")) {
                this.actKey = this.actKey.substring("HKEY_LOCAL_MACHINE\\".length());
                if (this.actKey.toUpperCase().startsWith("SYSTEM\\")) {
                    this.actKey = this.actKey.substring("SYSTEM\\".length());
                    this.actHive = "systemHive";
                } else if (this.actKey.toUpperCase().startsWith("SOFTWARE\\")) {
                    this.actKey = this.actKey.substring("SOFTWARE\\".length());
                    this.actHive = "softwareHive";
                }
            }
            returnType = LineType.KEY;
        } else if (this.actLine.contains("=")) {
            String tmp;
            this.actLine = this.actLine.replace("\\\\", "\\");
            int pos = this.actLine.indexOf("=");
            this.actValue = this.noQuotes(this.actLine.substring(0, pos));
            if (this.actValue.equals("@")) {
                this.actValue = "";
            }
            if ((tmp = this.noQuotes(this.actLine.substring(pos + 1))).startsWith("hex(0):")) {
                this.actType = 0;
                this.actRawData = this.hexToByteArray(tmp.substring("hex(0):".length()));
            } else if (tmp.startsWith("hex(2):")) {
                this.actType = 2;
                this.actRawData = this.hexToByteArray(tmp.substring("hex(2):".length()));
            } else if (tmp.startsWith("hex(02):")) {
                this.actType = 2;
                this.actRawData = this.hexToByteArray(tmp.substring("hex(02):".length()));
            } else if (tmp.startsWith("hex:")) {
                this.actType = 3;
                this.actRawData = this.hexToByteArray(tmp.substring("hex:".length()));
            } else if (tmp.startsWith("hex(3):")) {
                this.actType = 3;
                this.actRawData = this.hexToByteArray(tmp.substring("hex(3):".length()));
            } else if (tmp.startsWith("hex(03):")) {
                this.actType = 3;
                this.actRawData = this.hexToByteArray(tmp.substring("hex(03):".length()));
            } else if (tmp.startsWith("dword:")) {
                this.actType = 4;
                int dat = (int)Long.parseLong(tmp.substring("dword:".length()), 16);
                this.actData = dat;
            } else if (tmp.startsWith("hex(7):")) {
                this.actType = 7;
                this.actRawData = this.hexToByteArray(tmp.substring("hex(7):".length()));
            } else if (tmp.startsWith("hex(")) {
                this.actType = 0;
                this.actData = null;
            } else {
                this.actType = 1;
                this.actData = this.noQuotes(tmp);
            }
            returnType = LineType.VALUE;
        } else if (this.actLine.equals("Windows Registry Editor Version 5.00")) {
            returnType = LineType.HEADER;
        }
        return returnType;
    }

    public String getActKey() {
        return this.actKey;
    }

    public String getActValue() {
        return this.actValue;
    }

    public Object getActData() {
        return this.actData;
    }

    public byte[] getActRawData() {
        return this.actRawData;
    }

    public int getActType() {
        return this.actType;
    }

    public String getHive() {
        return this.actHive;
    }

    public void reset() {
        try {
            FileChannel srcChannel = new FileInputStream(this.regFile).getChannel();
            this.buffer = srcChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.regFile.length()).order(ByteOrder.LITTLE_ENDIAN);
            srcChannel.close();
            short x = this.buffer.getShort();
            if (x == -257) {
                this.getNextLine();
                this.validReg = this.actLine.equals("Windows Registry Editor Version 5.00");
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static enum LineType {
        HEADER,
        KEY,
        VALUE,
        EMPTY,
        UNKNOWN;

    }
}

