/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import reg.Converter;
import reg.RegBin;
import reg.RegCell;
import reg.RegData;
import reg.RegEntity;
import reg.RegImport;
import reg.RegKey;
import reg.RegKeyList;
import reg.RegVal;
import reg.RegValList;

public class RegHeader
extends RegEntity {
    protected boolean keyExists;
    protected boolean valExists;
    protected boolean lockFunctionText = false;
    protected String infoValName;
    protected String completeKeyPath;
    protected String partKeyPath;
    protected String functionText;
    protected String hiveWinName;
    protected RegKey valParentKey;
    protected RegKey newKey;
    protected HiveError errorCode = HiveError.Success;
    protected boolean isDirty = false;
    protected RegHeader otherHive;
    private int seq1;
    private int seq2;
    private long time;
    private int majorV;
    private int minorV;
    private int rootOff;
    private int lastHbinOff;
    private String name;
    private int checksum;
    byte[] buffer = null;
    RegKey root = null;
    Vector<RegBin> storage = null;
    int mark;
    boolean isEnlarged = false;
    protected String filename;
    protected String savename;
    private AllowOverwrite allowOverwrite = AllowOverwrite.FALSE;
    private boolean autoCreateKey = false;

    protected void buildInfo(String function, String keyPath, String valName, Object arguments) {
        String outKey = keyPath;
        String outVal = valName;
        String outArgs = null;
        if (arguments != null) {
            outArgs = arguments instanceof String ? "\"" + (String)arguments + "\"" : (arguments instanceof Integer ? String.valueOf((Integer)arguments) : "<Raw Data>");
        }
        this.completeKeyPath = this.checkRoot(this.findKeyCaseIndependent(keyPath));
        int p = this.completeKeyPath.indexOf(92);
        this.partKeyPath = this.completeKeyPath.substring(p + 1);
        this.keyExists = this.root.getKey(this.completeKeyPath) != null;
        this.valExists = false;
        this.infoValName = null;
        this.valParentKey = null;
        if (this.keyExists) {
            outKey = this.partKeyPath;
            if (valName != null) {
                this.valParentKey = this.root.getKey(this.completeKeyPath);
                this.infoValName = this.findValCaseIndependent(this.valParentKey, valName);
                if (this.infoValName != null) {
                    this.valExists = true;
                    outVal = this.infoValName;
                }
            }
        }
        if (!this.lockFunctionText) {
            this.errorCode = HiveError.Success;
            this.functionText = function + "(\"" + outKey + "\"";
            if (outVal != null) {
                this.functionText = this.functionText + ",\"" + outVal + "\"";
                if (outArgs != null) {
                    this.functionText = this.functionText + "," + outArgs;
                }
            }
            this.functionText = this.functionText + ");";
        }
        this.lockFunctionText = true;
    }

    protected void buildInfo(String function, String keyPath) {
        this.buildInfo(function, keyPath, null, null);
    }

    protected void buildInfo(String function, String keyPath, String valName) {
        this.buildInfo(function, keyPath, valName, null);
    }

    public boolean hasError() {
        return this.errorCode != HiveError.Success;
    }

    public HiveError getErrorCode() {
        return this.errorCode;
    }

    public String getErrorText() {
        String text2 = "";
        switch (this.errorCode) {
            case Success: {
                text2 = "Everything is ok: " + this.functionText;
                break;
            }
            case NoKey: {
                text2 = "Key does not exist: " + this.functionText;
                break;
            }
            case NoVal: {
                text2 = "Value does not exist: " + this.functionText;
                break;
            }
            case NoMulti: {
                text2 = "Multi-string does not exist: " + this.functionText;
                break;
            }
            case KeyExists: {
                text2 = "Key already exists: " + this.functionText;
                break;
            }
            case ValExists: {
                text2 = "Value already exists: " + this.functionText;
                break;
            }
            case OverWroteDiff: {
                text2 = "Overwrote existing value with different data: " + this.functionText;
                break;
            }
            case MultiExists: {
                text2 = "Multi-string partial value already exists: " + this.functionText;
                break;
            }
            case NoMultiType: {
                text2 = "Value is not of type MultiString: " + this.functionText;
                break;
            }
            case NoHive: {
                text2 = "Hive does not exist: " + this.filename;
                break;
            }
            case HiveInUse: {
                text2 = "Hive in use: " + this.filename;
                break;
            }
            case InvalidData: {
                text2 = "Invalid data format: " + this.functionText;
                break;
            }
            case IOError: {
                text2 = "Unknown IO error: " + this.functionText;
                break;
            }
            case HiveCorrupted: {
                text2 = "Illegal state of hive: " + this.functionText;
            }
        }
        return text2;
    }

    public void setSaveName(String filePath) {
        this.savename = filePath;
    }

    public String getSaveName() {
        return this.savename;
    }

    public RegHeader(String filePath) {
        this.errorCode = HiveError.Success;
        this.functionText = filePath;
        this.savename = this.filename = filePath;
        File hive = new File(filePath);
        if (!hive.exists()) {
            this.errorCode = HiveError.NoHive;
            return;
        }
        this.hiveWinName = hive.getName();
        long len = hive.length();
        this.buffer = new byte[(int)len];
        try {
            FileInputStream stream = new FileInputStream(hive);
            try {
                stream.read(this.buffer);
                String start = new String(Arrays.copyOfRange(this.buffer, 0, 4));
                if (!start.equals("regf")) {
                    this.errorCode = HiveError.InvalidData;
                    return;
                }
            }
            catch (IOException ex) {
                this.errorCode = HiveError.IOError;
                return;
            }
            try {
                stream.close();
            }
            catch (IOException ex) {
                this.errorCode = HiveError.IOError;
                return;
            }
        }
        catch (FileNotFoundException ex) {
            this.errorCode = HiveError.HiveInUse;
            return;
        }
        this.read(this.buffer, 0);
    }

    public void setAllowValOverwrite(AllowOverwrite val) {
        this.allowOverwrite = val;
    }

    public void setAutoCreateKey(boolean val) {
        this.autoCreateKey = val;
    }

    public RegKey buildTree() {
        if (this.buffer == null) {
            throw new NullPointerException();
        }
        this.root = new RegKey(this, this.buffer, 4096 + this.rootOff);
        this.root.setKeyName(this.hiveWinName);
        return this.root;
    }

    public void buildStorage() {
        RegBin tmp;
        if (this.buffer == null) {
            throw new NullPointerException();
        }
        this.mark = 4096;
        this.storage = new Vector(this.buffer.length / 4096 + 15);
        while (this.mark < this.buffer.length && (tmp = new RegBin(this.buffer, this.mark)).getSize() != 0) {
            this.storage.add(tmp);
            this.mark += tmp.getSize();
        }
    }

    public void release() {
        this.buffer = null;
        if (this.otherHive != null) {
            this.otherHive.release();
        }
        System.gc();
    }

    public void makeDirty() {
        this.isDirty = true;
    }

    public void commit(boolean setDirty) throws IOException {
        this.isDirty = setDirty;
        this.commit();
    }

    public void commit() throws IOException {
        if (this.isDirty) {
            File save = new File(this.savename);
            if (this.buffer == null) {
                File hive = new File(this.filename);
                if (!hive.exists()) {
                    throw new FileNotFoundException(this.filename);
                }
                long len = hive.length();
                this.buffer = new byte[(int)len];
                FileInputStream stream = new FileInputStream(hive);
                stream.read(this.buffer);
                stream.close();
            }
            if (this.root == null) {
                throw new IllegalStateException();
            }
            this.write(this.buffer, 0);
            this.root.commit(this.buffer);
            for (int i = 0; i < this.storage.size(); ++i) {
                this.storage.elementAt(i).commit(this.buffer);
            }
            FileOutputStream stream = new FileOutputStream(save);
            stream.write(this.buffer);
            stream.close();
            this.savename = this.filename;
            this.isDirty = false;
        }
    }

    @Override
    public void read(byte[] buff, int offset) {
        this.seq1 = Converter.byteArrayToInt(buff, offset + 4);
        this.seq2 = Converter.byteArrayToInt(buff, offset + 8);
        this.time = Converter.byteArrayToLong(buff, offset + 12);
        this.majorV = Converter.byteArrayToInt(buff, offset + 20);
        this.minorV = Converter.byteArrayToInt(buff, offset + 24);
        this.rootOff = Converter.byteArrayToInt(buff, offset + 36);
        this.lastHbinOff = Converter.byteArrayToInt(buff, offset + 40);
        this.name = new String(buff, offset + 48, 64);
        this.checksum = Converter.byteArrayToInt(buff, offset + 508);
    }

    @Override
    public void write(byte[] buff, int offset) {
        Converter.intToByteArray(this.seq1, buff, offset + 4);
        Converter.intToByteArray(this.seq2, buff, offset + 8);
        Converter.longToByteArray(this.time, buff, offset + 12);
        Converter.intToByteArray(this.majorV, buff, offset + 20);
        Converter.intToByteArray(this.minorV, buff, offset + 24);
        Converter.intToByteArray(this.rootOff, buff, offset + 36);
        Converter.intToByteArray(this.lastHbinOff, buff, offset + 40);
        try {
            byte[] arr = this.name.getBytes("US-ASCII");
            System.arraycopy(arr, 0, buff, offset + 48, arr.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (this.isEnlarged) {
            this.checksum = Converter.byteArrayToInt(this.buffer, 0);
            for (int i = 4; i < 508; i += 4) {
                this.checksum ^= Converter.byteArrayToInt(this.buffer, i);
            }
        }
        Converter.intToByteArray(this.checksum, buff, offset + 508);
    }

    public boolean createSingleKey(String name, RegKey parent) {
        this.newKey = null;
        if (parent == null) {
            return false;
        }
        this.newKey = new RegKey(this, (RegCell)parent, name, null);
        this.newKey.setOffset(this.allocate(this.newKey.getSize()).getOffset());
        parent.addKey(this.newKey);
        return true;
    }

    public RegKey getNewKey() {
        return this.newKey;
    }

    public boolean createKey(String parentKey, String newKey) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("createKey", parentKey);
        if (!this.keyExists && !this.autoCreateKey) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoKey;
            return false;
        }
        this.lockFunctionText = true;
        boolean res = this.createKey(parentKey + "\\" + newKey);
        this.lockFunctionText = wasLocked;
        return res;
    }

    public boolean createKey(String keyPath) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("createKey", keyPath);
        if (this.keyExists) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.KeyExists;
            return false;
        }
        String parentPath = this.completeKeyPath;
        Stack<String> nameStack = new Stack<String>();
        while (parentPath.indexOf(92) != -1 && this.root.getKey(parentPath) == null) {
            nameStack.push(parentPath.substring(parentPath.lastIndexOf(92) + 1));
            parentPath = parentPath.substring(0, parentPath.lastIndexOf(92));
        }
        RegKey parent = null;
        this.lockFunctionText = true;
        while (!nameStack.isEmpty()) {
            parent = this.root.getKey(parentPath);
            String name = (String)nameStack.pop();
            if (!name.equals("")) {
                this.createSingleKey(name, parent);
            }
            parentPath = parentPath + "\\" + name;
        }
        this.lockFunctionText = wasLocked;
        this.isDirty = true;
        return true;
    }

    public boolean deleteKey(String keyPath) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("deleteKey", keyPath);
        if (!this.keyExists) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoKey;
            return false;
        }
        String name = this.completeKeyPath.substring(this.completeKeyPath.lastIndexOf(92) + 1);
        String parentPath = this.completeKeyPath.substring(0, this.completeKeyPath.lastIndexOf(92));
        RegKey parent = this.root.getKey(parentPath);
        boolean res = parent.removeKey(name);
        this.lockFunctionText = wasLocked;
        this.isDirty = true;
        return res;
    }

    public RegKey readKey(String keyPath) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("readKey", keyPath);
        this.lockFunctionText = wasLocked;
        RegKey res = this.root.getKey(this.completeKeyPath);
        return res;
    }

    public boolean createValue(String keyPath, String valName, int type, Object value) {
        RegData dt;
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("createValue", keyPath, valName, value);
        if (!this.keyExists) {
            if (!this.autoCreateKey) {
                this.lockFunctionText = wasLocked;
                this.errorCode = HiveError.NoKey;
                return false;
            }
            this.createKey(keyPath);
            this.buildInfo("createValue", keyPath, valName);
        } else if (this.infoValName != null) {
            if (this.allowOverwrite.equals((Object)AllowOverwrite.FALSE)) {
                this.lockFunctionText = wasLocked;
                this.errorCode = HiveError.ValExists;
                return false;
            }
            byte[] oldVal = this.getValueRaw(keyPath, valName);
            boolean res = this.modifyValue(keyPath, valName, value);
            byte[] newVal = this.getValueRaw(keyPath, valName);
            if (!Arrays.equals(oldVal, newVal)) {
                this.errorCode = HiveError.OverWroteDiff;
            }
            this.lockFunctionText = wasLocked;
            return res;
        }
        RegVal newVal = null;
        byte[] newBytes = null;
        int dataLen = -1;
        if (value instanceof String) {
            switch (type) {
                case 1: 
                case 2: {
                    String srcStr = (String)value;
                    srcStr = srcStr.replaceAll("\\\\\"", "\"");
                    byte[] tmpStr = new byte[]{0, 0};
                    try {
                        tmpStr = srcStr.getBytes("UTF-16LE");
                    }
                    catch (UnsupportedEncodingException e) {
                        this.errorCode = HiveError.InvalidData;
                        return false;
                    }
                    newBytes = new byte[tmpStr.length + 2];
                    System.arraycopy(tmpStr, 0, newBytes, 0, tmpStr.length);
                    dataLen = newBytes.length;
                    break;
                }
                case 3: {
                    String cleanedData = ((String)value).replaceAll(",", "");
                    cleanedData = cleanedData.replaceAll("\"", "");
                    cleanedData = cleanedData.replaceAll(" ", "");
                    cleanedData = cleanedData.replace("hex(03):", "");
                    int numberChars = cleanedData.length();
                    newBytes = new byte[numberChars / 2];
                    for (int i = 0; i < numberChars; i += 2) {
                        newBytes[i / 2] = (byte)Integer.parseInt(cleanedData.substring(i, i + 2), 16);
                    }
                    dataLen = newBytes.length;
                    break;
                }
                case 7: {
                    int i;
                    String[] srcMul = ((String)value).split(", ");
                    int total = 0;
                    int curr = 0;
                    for (i = 0; i < srcMul.length; ++i) {
                        total += 2 * (srcMul[i].length() + 1);
                    }
                    if (total > 0) {
                        total += 2;
                    }
                    newBytes = new byte[total];
                    try {
                        for (i = 0; i < srcMul.length; ++i) {
                            byte[] tmp = srcMul[i].getBytes("UTF-16LE");
                            System.arraycopy(tmp, 0, newBytes, curr, tmp.length);
                            curr += tmp.length + 2;
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        this.errorCode = HiveError.InvalidData;
                        return false;
                    }
                    dataLen = newBytes.length;
                    break;
                }
            }
        } else {
            switch (type) {
                case 4: {
                    newBytes = new byte[4];
                    Integer num = new Integer(value.toString());
                    Converter.intToByteArray(num, newBytes);
                    dataLen = newBytes.length;
                    break;
                }
                case 0: {
                    newBytes = new byte[]{};
                    dataLen = 0;
                    break;
                }
                default: {
                    newBytes = (byte[])value;
                    dataLen = newBytes.length;
                }
            }
        }
        if (dataLen == -1) {
            dt = new RegData(this, value, type);
            dt.setOffset(this.allocate(dt.getSize()).getOffset());
            newVal = new RegVal(this, this.valParentKey, valName, dt, type, dt.getData().length);
        } else if (dataLen <= 4) {
            newVal = new RegVal(this, this.valParentKey, valName, type, newBytes);
        } else {
            dt = new RegData(this, newBytes);
            dt.setOffset(this.allocate(dt.getSize()).getOffset());
            newVal = new RegVal(this, this.valParentKey, valName, dt, type, dt.getData().length);
        }
        newVal.setOffset(this.allocate(newVal.getSize()).getOffset());
        this.valParentKey.addValue(newVal);
        this.lockFunctionText = wasLocked;
        this.isDirty = true;
        return true;
    }

    public boolean createValueRaw(String keyPath, String valName, int type, byte[] newBytes) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("createValueRaw", keyPath, valName, newBytes);
        if (!this.keyExists) {
            if (!this.autoCreateKey) {
                this.lockFunctionText = wasLocked;
                this.errorCode = HiveError.NoKey;
                return false;
            }
            this.createKey(keyPath);
            this.buildInfo("createValueRaw", keyPath, valName);
        } else if (this.infoValName != null) {
            if (this.allowOverwrite.equals((Object)AllowOverwrite.FALSE)) {
                this.lockFunctionText = wasLocked;
                this.errorCode = HiveError.ValExists;
                return false;
            }
            byte[] oldVal = this.getValueRaw(keyPath, valName);
            boolean res = this.modifyValueRaw(keyPath, valName, newBytes);
            if (oldVal != newBytes) {
                this.errorCode = HiveError.OverWroteDiff;
            }
            this.lockFunctionText = wasLocked;
            return res;
        }
        RegVal newVal = null;
        int dataLen = newBytes.length;
        if (dataLen <= 4) {
            newVal = new RegVal(this, this.valParentKey, valName, type, newBytes);
        } else {
            RegData dt = new RegData(this, newBytes);
            dt.setOffset(this.allocate(dt.getSize()).getOffset());
            newVal = new RegVal(this, this.valParentKey, valName, dt, type, dt.getData().length);
        }
        newVal.setOffset(this.allocate(newVal.getSize()).getOffset());
        this.valParentKey.addValue(newVal);
        this.lockFunctionText = wasLocked;
        this.isDirty = true;
        return true;
    }

    public boolean modifyValueRaw(String keyPath, String valName, byte[] newBytes) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("modifyValueRaw", keyPath, valName, newBytes);
        if (!this.keyExists) {
            if (!this.autoCreateKey) {
                this.errorCode = HiveError.NoKey;
                this.lockFunctionText = wasLocked;
                return false;
            }
            this.createKey(keyPath);
            this.buildInfo("modifyValueRaw", keyPath, valName);
        } else if (!this.valExists) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoVal;
            return false;
        }
        RegVal actVal = this.valParentKey.getVal(this.infoValName);
        int actValType = actVal.getType();
        this.deleteValue(this.completeKeyPath, valName);
        this.createValue(this.completeKeyPath, valName, actValType, newBytes);
        this.lockFunctionText = wasLocked;
        this.isDirty = true;
        return true;
    }

    public boolean deleteValue(String keyPath, String valName) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("deleteValue", keyPath, valName);
        if (this.infoValName == null) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoVal;
            return false;
        }
        this.valParentKey.removeValue(this.infoValName);
        this.lockFunctionText = wasLocked;
        this.isDirty = true;
        return true;
    }

    public boolean modifyValue(String keyPath, String valName, Object value) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("modifyValue", keyPath, valName, value);
        if (!this.keyExists) {
            if (!this.autoCreateKey) {
                this.lockFunctionText = wasLocked;
                this.errorCode = HiveError.NoKey;
                return false;
            }
            this.createKey(keyPath);
            this.buildInfo("modifyValue", keyPath, valName);
        } else if (!this.valExists) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoVal;
            return false;
        }
        RegVal actVal = this.valParentKey.getVal(this.infoValName);
        int actValType = actVal.getType();
        this.deleteValue(this.completeKeyPath, this.infoValName);
        boolean res = this.createValue(this.completeKeyPath, this.infoValName, actValType, value);
        this.lockFunctionText = wasLocked;
        this.isDirty = true;
        return res;
    }

    public boolean modifyValueMulti(String keyPath, String valName, String value, int insertIndex) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("modifyValueMulti", keyPath, valName, value);
        if (!this.keyExists) {
            if (!this.autoCreateKey) {
                this.lockFunctionText = wasLocked;
                this.errorCode = HiveError.NoKey;
                return false;
            }
            this.createKey(keyPath);
            this.buildInfo("modifyValueMulti", keyPath, valName);
        } else if (!this.valExists) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoMulti;
            return false;
        }
        RegVal actVal = this.valParentKey.getVal(this.infoValName);
        int actValType = actVal.getType();
        if (actValType != 7) {
            this.errorCode = HiveError.NoMultiType;
            this.lockFunctionText = wasLocked;
            return false;
        }
        String actString = this.getValueString(this.completeKeyPath, this.infoValName);
        ArrayList<String> items = new ArrayList<String>(Arrays.asList(actString.split(",")));
        for (int i = 0; i < items.size(); ++i) {
            if (!value.equalsIgnoreCase(items.get(i))) continue;
            this.errorCode = HiveError.MultiExists;
            this.lockFunctionText = wasLocked;
            return false;
        }
        int index = insertIndex;
        if (index == -1) {
            index = items.size();
        }
        items.add(index, value);
        String newVal = "";
        for (int i = 0; i < items.size(); ++i) {
            if (!newVal.equals("")) {
                newVal = newVal + ", ";
            }
            newVal = newVal + items.get(i).trim();
        }
        this.deleteValue(this.completeKeyPath, this.infoValName);
        boolean res = this.createValue(this.completeKeyPath, this.infoValName, actValType, newVal);
        this.lockFunctionText = wasLocked;
        this.isDirty = true;
        return res;
    }

    public RegBin enlargeBuffer(int delta) throws FileNotFoundException, IOException {
        if (this.mark + delta > this.buffer.length) {
            int block = 262144;
            FileOutputStream fos = new FileOutputStream(new File(this.filename));
            fos.write(this.buffer);
            byte[] addOn = new byte[262144];
            fos.write(addOn);
            fos.close();
            this.buffer = new byte[this.buffer.length + 262144];
            FileInputStream fis = new FileInputStream(new File(this.filename));
            fis.read(this.buffer);
            fis.close();
        }
        Converter.strToByteArray("hbin", this.buffer, this.mark);
        Converter.intToByteArray(this.mark - 4096, this.buffer, this.mark + 4);
        Converter.intToByteArray(delta, this.buffer, this.mark + 8);
        Converter.intToByteArray(delta, this.buffer, this.mark + 28);
        Converter.intToByteArray(delta - 32, this.buffer, this.mark + 32);
        RegBin tmp = new RegBin(this.buffer, this.mark);
        this.storage.add(tmp);
        this.mark += delta;
        this.lastHbinOff += delta;
        Converter.intToByteArray(this.lastHbinOff, this.buffer, 40);
        this.isEnlarged = true;
        return tmp;
    }

    public RegCell resAllocate(int desiredSize) {
        return this.comAllocate(desiredSize, true);
    }

    public RegCell allocate(int desiredSize) {
        return this.comAllocate(desiredSize, false);
    }

    private RegCell comAllocate(int desiredSize, boolean reserve) {
        if (this.storage == null) {
            return null;
        }
        desiredSize = Math.abs(desiredSize);
        int optimal = 0;
        int minSiz = Integer.MAX_VALUE;
        RegCell min = null;
        for (int i = 0; i < this.storage.size(); ++i) {
            RegCell tmp = this.storage.elementAt(i).findFree(desiredSize);
            if (tmp == null) continue;
            int tmpSiz = tmp.getSize();
            if (tmpSiz == desiredSize) {
                min = tmp;
                optimal = i;
                break;
            }
            if (tmpSiz >= minSiz) continue;
            min = tmp;
            optimal = i;
            minSiz = tmpSiz;
        }
        if (min == null) {
            int delta;
            for (delta = 4096; delta < desiredSize + 32; delta += 4096) {
            }
            try {
                RegBin newBin = this.enlargeBuffer(delta);
                min = newBin.findFree(desiredSize);
                optimal = this.storage.size() - 1;
            }
            catch (IOException ex) {
                Logger.getLogger(RegHeader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        RegBin bin = this.storage.elementAt(optimal);
        min = bin.allocate(min.getOffset(), desiredSize);
        min.binIndex = optimal;
        if (reserve && bin.getFreeBlocks() == 1 & bin.getTakenBlocks() == 1) {
            bin.createReserve();
        }
        return min;
    }

    public void resDeallocate(RegCell ref) {
        this.comDeallocate(ref, true);
    }

    public void deallocate(RegCell ref) {
        this.comDeallocate(ref, false);
    }

    private void comDeallocate(RegCell ref, boolean reserve) {
        if (this.storage == null || ref == null) {
            return;
        }
        if (ref.binIndex == -1) {
            for (int i = 0; i < this.storage.size(); ++i) {
                if (ref.getOffset() <= 4096 + this.storage.elementAt(i).getOffFromFirst() || ref.getOffset() >= 4096 + this.storage.elementAt(i).getOffFromFirst() + this.storage.elementAt(i).getSize()) continue;
                this.doDeallocate(i, ref, reserve);
                return;
            }
        } else {
            this.doDeallocate(ref.binIndex, ref, reserve);
        }
    }

    private void doDeallocate(int index, RegCell ref, boolean reserve) {
        RegBin bin = this.storage.elementAt(index);
        if (reserve && bin.getFreeBlocks() == 0 & bin.getTakenBlocks() == 2) {
            bin.freeReserve();
        }
        bin.deallocate(ref.getOffset());
    }

    private String checkRoot(String parentPath) {
        String result = parentPath;
        String rootKey = this.root.getKeyName();
        int p = result.indexOf(92);
        if (p == -1 || !result.substring(0, p).equals(rootKey)) {
            result = rootKey + "\\" + result;
        }
        return result;
    }

    private void updateTime() {
        this.time = Converter.systemTimeToFileTime(Calendar.getInstance().getTimeInMillis());
    }

    public boolean existKey(String keyPath) {
        boolean wasLocked = this.lockFunctionText;
        this.lockFunctionText = true;
        this.buildInfo("existKey", keyPath);
        this.lockFunctionText = wasLocked;
        return this.keyExists;
    }

    public boolean existVal(String keyPath, String valName) {
        boolean wasLocked = this.lockFunctionText;
        this.lockFunctionText = true;
        this.buildInfo("existKey", keyPath, valName);
        this.lockFunctionText = wasLocked;
        return this.valExists;
    }

    public byte[] getValueRaw(String keyPath, String valName) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("getValueRaw", keyPath, valName);
        if (!this.keyExists) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoKey;
            return null;
        }
        if (!this.valExists) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoVal;
            return null;
        }
        RegVal actVal = this.valParentKey.getVal(this.infoValName);
        byte[] rawVal = actVal.getValueRaw();
        this.lockFunctionText = wasLocked;
        return rawVal;
    }

    public int getValueType(String keyPath, String valName) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("getValueType", keyPath, valName);
        if (!this.keyExists) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoKey;
            return -1;
        }
        if (!this.valExists) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoVal;
            return -1;
        }
        RegVal actVal = this.valParentKey.getVal(this.infoValName);
        int res = actVal.getType();
        this.lockFunctionText = wasLocked;
        return res;
    }

    public String getValueString(String keyPath, String valName) {
        boolean wasLocked = this.lockFunctionText;
        this.buildInfo("getValueString", keyPath, valName);
        if (!this.keyExists) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoKey;
            return null;
        }
        if (!this.valExists) {
            this.lockFunctionText = wasLocked;
            this.errorCode = HiveError.NoVal;
            return null;
        }
        RegVal actVal = this.valParentKey.getVal(this.infoValName);
        String res = actVal.toString();
        this.lockFunctionText = wasLocked;
        return res;
    }

    private String findKeyCaseIndependent(String keyPath) {
        String parentPath = Converter.preformatPath(keyPath);
        String caseFree = this.findKeyCaseIndependent(this.root, parentPath);
        if (caseFree.endsWith("\\")) {
            caseFree = caseFree.substring(0, caseFree.length() - 1);
        }
        parentPath = caseFree + parentPath.substring(caseFree.length());
        return parentPath;
    }

    private String findKeyCaseIndependent(RegKey key, String path) {
        String actTest;
        String actPath = path;
        String result = "";
        String found = "";
        RegKey actKey = key;
        int p = actPath.indexOf("\\");
        if (p == -1) {
            actTest = actPath;
            actPath = "";
        } else {
            actTest = actPath.substring(0, p);
            actPath = actPath.substring(p + 1);
        }
        RegKeyList keys = key.getChildList();
        if (keys != null) {
            Vector<RegKey> list = keys.getSubkeys();
            Iterator<RegKey> i$ = list.iterator();
            while (i$.hasNext()) {
                RegKey current;
                actKey = current = i$.next();
                found = current.getKeyName();
                if (!actTest.equalsIgnoreCase(found)) continue;
                if (!result.equals("")) {
                    result = result + "\\";
                }
                result = result + found;
                if (!actPath.equals("")) {
                    result = result + "\\" + this.findKeyCaseIndependent(actKey, actPath);
                }
                found = "";
                break;
            }
            if (!found.equals("")) {
                if (!result.equals("")) {
                    result = result + "\\";
                }
                result = result + actTest + "\\" + actPath;
            }
        }
        return result;
    }

    private String findValCaseIndependent(RegKey parent, String valName) {
        RegValList list = parent.getValList();
        if (list != null) {
            for (RegVal val : list.getVals()) {
                if (!val.getName().equalsIgnoreCase(valName)) continue;
                return val.getName();
            }
        }
        return null;
    }

    private void copyKey(RegKey startKey, String targetPath, boolean recursiv) {
        RegKeyList childKeys;
        this.createKey(targetPath);
        RegValList childVals = startKey.getValList();
        if (childVals != null) {
            Vector<RegVal> values = childVals.getVals();
            for (RegVal value : values) {
                this.createValueRaw(targetPath, value.getName(), value.getType(), value.getValueRaw());
            }
        }
        if (recursiv && (childKeys = startKey.getChildList()) != null) {
            Vector<RegKey> subkeys = childKeys.getSubkeys();
            for (RegKey subKey : subkeys) {
                this.copyKey(subKey, targetPath + "\\" + subKey.getKeyName(), recursiv);
            }
        }
    }

    public void fetchRelease() {
        this.otherHive.release();
        this.otherHive = null;
    }

    public boolean fetchOpen(String otherHivePath) {
        if (this.otherHive != null) {
            this.otherHive.release();
        }
        this.otherHive = new RegHeader(otherHivePath);
        if (this.otherHive == null) {
            return false;
        }
        this.otherHive.open();
        return true;
    }

    public boolean fetchValue(String key, String value) {
        RegKey otherKey = this.otherHive.readKey(key);
        String otherKeyPath = otherKey.getPath();
        byte[] raw = this.getValueRaw(otherKeyPath, value);
        int type = this.getValueType(otherKeyPath, value);
        this.createValueRaw(key, value, type, raw);
        return true;
    }

    public boolean fetchKey(String key) {
        return this.fetchKey(key, true, true);
    }

    public boolean fetchKeyPreserve(String key) {
        return this.fetchKey(key, false, true);
    }

    public boolean fetchKeyNotRecursive(String key) {
        return this.fetchKey(key, false, false);
    }

    public boolean fetchKey(String key, boolean deletePrevious, boolean recursiv) {
        RegKey otherKey;
        this.buildInfo("fetchKey", key);
        if (deletePrevious && this.keyExists) {
            this.errorCode = HiveError.KeyExists;
            this.deleteKey(key);
        }
        if ((otherKey = this.otherHive.readKey(key)) == null) {
            return false;
        }
        String targetPath = this.partKeyPath;
        this.copyKey(otherKey, targetPath, recursiv);
        this.isDirty = true;
        return true;
    }

    public boolean importReg(String regName) {
        boolean savCreate = this.autoCreateKey;
        AllowOverwrite savOverwrite = this.allowOverwrite;
        this.setAutoCreateKey(true);
        this.setAllowValOverwrite(AllowOverwrite.TRUE);
        boolean result = false;
        try {
            RegImport regImport = new RegImport(regName);
            if (!regImport.isValid()) {
                result = false;
                this.errorCode = HiveError.InvalidReg;
            } else {
                result = true;
            }
            block6: while (regImport.isValid()) {
                String lin = regImport.getNextLine();
                RegImport.LineType lineType = regImport.getLineType();
                if (lineType == RegImport.LineType.KEY) {
                    if (!regImport.actKey.startsWith("-")) continue;
                    this.deleteKey(regImport.actKey.substring(1));
                    continue;
                }
                if (lineType != RegImport.LineType.VALUE) continue;
                if ("-".equals(regImport.actData)) {
                    result |= this.deleteValue(regImport.actKey, regImport.actValue);
                    continue;
                }
                switch (regImport.actType) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 7: {
                        result |= this.createValueRaw(regImport.actKey, regImport.actValue, regImport.actType, regImport.actRawData);
                        continue block6;
                    }
                }
                result |= this.createValue(regImport.actKey, regImport.actValue, regImport.actType, regImport.actData);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(RegHeader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(RegHeader.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.autoCreateKey = savCreate;
        this.allowOverwrite = savOverwrite;
        return result;
    }

    public void open() {
        this.buildStorage();
        this.buildTree();
    }

    public RegKey getRootKey() {
        return this.root;
    }

    public String getFilePath() {
        return this.filename;
    }

    public String getHiveName() {
        return this.hiveWinName;
    }

    public static enum HiveError {
        Success,
        NoKey,
        NoVal,
        KeyExists,
        ValExists,
        NoHive,
        HiveInUse,
        InvalidData,
        IOError,
        NoMulti,
        MultiExists,
        NoMultiType,
        OverWroteDiff,
        HiveCorrupted,
        InvalidReg;

    }

    public static enum AllowOverwrite {
        TRUE,
        FALSE;

    }
}

