/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import reg.RegKey;
import reg.RegKeyList;
import reg.RegVal;
import reg.RegValList;

public class RegExport {
    private RegKey theKey;
    private File theFile;
    private FileOutputStream theStream;
    private int lineLength;
    final String coding = "UTF_16LE";
    final byte[] byteMarker = new byte[]{-1, -2};
    final byte[] byteCRLF = new byte[]{13, 0, 10, 0};
    final byte[] byteComma = new byte[]{44, 0};
    final byte[] byteBreak = new byte[]{92, 0, 13, 0, 10, 0, 32, 0, 32, 0};
    final byte[] HexBytes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public RegExport(RegKey key, File file) {
        this.theKey = key;
        this.theFile = file;
        try {
            this.theFile.createNewFile();
            this.theStream = new FileOutputStream(this.theFile);
            this.theStream.write(this.byteMarker);
            String firstLine = "Windows Registry Editor Version 5.00\r\n";
            byte[] hBytes = firstLine.getBytes("UTF_16LE");
            this.theStream.write(hBytes);
        }
        catch (IOException ex) {
            Logger.getLogger(RegExport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    String checkKey(String key, String ori, String repl) {
        String lowOri;
        String lowKey = key.toLowerCase();
        if (lowKey.startsWith(lowOri = ori.toLowerCase())) {
            return repl + key.substring(ori.length());
        }
        return key;
    }

    public boolean close() {
        try {
            this.theStream.close();
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(RegExport.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    private String formatKeyPath(String inCode) {
        String keyPath = this.checkKey(inCode, "DEFAULT", "HKEY_CURRENT_USER");
        keyPath = this.checkKey(keyPath, "SOFTWARE", "HKEY_LOCAL_MACHINE\\Software");
        keyPath = this.checkKey(keyPath, "SYSTEM", "HKEY_LOCAL_MACHINE\\System");
        return keyPath;
    }

    public boolean action() {
        String keyPath = this.formatKeyPath(this.theKey.getPath());
        return this.transferKey(this.theKey, keyPath);
    }

    public boolean addKey(RegKey toAdd) {
        String keyPath = this.formatKeyPath(toAdd.getPath());
        return this.transferKey(toAdd, keyPath);
    }

    public boolean markDeleteKey(RegKey toMark) {
        String keyPath = this.formatKeyPath(toMark.getPath());
        keyPath = "[-" + keyPath + "]";
        try {
            this.theStream.write(this.byteCRLF);
            byte[] byteLine = keyPath.getBytes("UTF_16LE");
            this.theStream.write(byteLine);
            this.theStream.write(this.byteCRLF);
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(RegExport.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean outputKey(RegKey toMark) {
        String keyPath = this.formatKeyPath(toMark.getPath());
        keyPath = "[" + keyPath + "]";
        try {
            this.theStream.write(this.byteCRLF);
            byte[] byteLine = keyPath.getBytes("UTF_16LE");
            this.theStream.write(byteLine);
            this.theStream.write(this.byteCRLF);
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(RegExport.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean outputVal(RegVal val) {
        return this.outputVal(val, false);
    }

    public boolean outputVal(RegVal val, boolean flagDelete) {
        String valNam = val.getName();
        String value = valNam.equals("") ? "@=" : "\"" + valNam + "\"=";
        try {
            byte[] byteLine = value.getBytes("UTF_16LE");
            this.theStream.write(byteLine);
            if (flagDelete) {
                value = "-";
                byteLine = value.getBytes("UTF_16LE");
                this.theStream.write(byteLine);
                this.theStream.write(this.byteCRLF);
            } else {
                this.lineLength = byteLine.length;
                int type = val.getType();
                switch (type) {
                    case 1: {
                        value = "\"" + val.getValue() + "\"";
                        byteLine = value.getBytes("UTF_16LE");
                        this.theStream.write(byteLine);
                        this.theStream.write(this.byteCRLF);
                        break;
                    }
                    case 4: {
                        String hexVal = val.toString();
                        value = "dword:" + hexVal.substring(2, 10).toLowerCase();
                        byteLine = value.getBytes("UTF_16LE");
                        this.theStream.write(byteLine);
                        this.theStream.write(this.byteCRLF);
                        break;
                    }
                    default: {
                        this.outBinary(val.getName(), val);
                        this.theStream.write(this.byteCRLF);
                    }
                }
            }
            return true;
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(RegExport.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(RegExport.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    byte[] byteToHex(byte bt) {
        int v = bt & 0xFF;
        byte[] hex = new byte[4];
        hex[0] = this.HexBytes[v >>> 4];
        hex[2] = this.HexBytes[v & 0xF];
        return hex;
    }

    void writeByte(byte bt) throws IOException {
        this.theStream.write(this.byteComma);
        this.lineLength += 2;
        if (this.lineLength > 153) {
            this.theStream.write(this.byteBreak);
            this.lineLength = 4;
        }
        byte[] byteLine = this.byteToHex(bt);
        this.theStream.write(byteLine);
        this.lineLength += 4;
    }

    void outBinary(String name, RegVal val) throws UnsupportedEncodingException, IOException {
        String head;
        int type = val.getType();
        switch (type) {
            case 3: {
                head = "hex:";
                break;
            }
            default: {
                Integer t = new Integer(type);
                head = "hex(" + t.toString() + "):";
            }
        }
        byte[] byteLine = head.getBytes("UTF_16LE");
        this.theStream.write(byteLine);
        this.lineLength += byteLine.length;
        byte[] rawBytes = val.getValueRaw();
        if (rawBytes.length > 0) {
            byteLine = this.byteToHex(rawBytes[0]);
            this.theStream.write(byteLine);
            this.lineLength += 4;
            for (int i = 1; i < rawBytes.length; ++i) {
                this.writeByte(rawBytes[i]);
            }
        }
    }

    private boolean transferKey(RegKey actKey, String keyPath) {
        String keyName = "[" + keyPath + "]";
        try {
            RegKeyList keys;
            RegValList vals = actKey.getValList();
            if (vals != null) {
                ArrayList<RegVal> theValList = new ArrayList<RegVal>();
                for (RegVal val : vals.getVals()) {
                    theValList.add(val);
                }
                Collections.sort(theValList, new Comparator<RegVal>(){

                    @Override
                    public int compare(RegVal val1, RegVal val2) {
                        return val1.getName().compareToIgnoreCase(val2.getName());
                    }
                });
                this.theStream.write(this.byteCRLF);
                byte[] byteLine = keyName.getBytes("UTF_16LE");
                this.theStream.write(byteLine);
                this.theStream.write(this.byteCRLF);
                block8: for (RegVal val : vals.getVals()) {
                    String valNam = val.getName();
                    String value = valNam.equals("") ? "@=" : "\"" + val.getName() + "\"=";
                    byteLine = value.getBytes("UTF_16LE");
                    this.theStream.write(byteLine);
                    this.lineLength = byteLine.length;
                    int type = val.getType();
                    switch (type) {
                        case 1: {
                            value = "\"" + val.getValue() + "\"";
                            byteLine = value.getBytes("UTF_16LE");
                            this.theStream.write(byteLine);
                            this.theStream.write(this.byteCRLF);
                            continue block8;
                        }
                        case 4: {
                            String hexVal = val.toString();
                            value = "dword:" + hexVal.substring(2, 10).toLowerCase();
                            byteLine = value.getBytes("UTF_16LE");
                            this.theStream.write(byteLine);
                            this.theStream.write(this.byteCRLF);
                            continue block8;
                        }
                    }
                    this.outBinary(val.getName(), val);
                    this.theStream.write(this.byteCRLF);
                }
            }
            if ((keys = actKey.getChildList()) != null) {
                ArrayList<RegKey> theKeyList = new ArrayList<RegKey>();
                for (RegKey key : keys.getSubkeys()) {
                    theKeyList.add(key);
                }
                Collections.sort(theKeyList, new Comparator<RegKey>(){

                    @Override
                    public int compare(RegKey key1, RegKey key2) {
                        return key1.getKeyName().compareToIgnoreCase(key2.getKeyName());
                    }
                });
                for (RegKey key : theKeyList) {
                    String newPath = keyPath + "\\" + key.getKeyName();
                    this.transferKey(key, newPath);
                }
            }
            return true;
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(RegExport.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(RegExport.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }
}

