/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import reg.Converter;
import reg.RegBigData;
import reg.RegCell;
import reg.RegHeader;

public class RegData
extends RegCell {
    private byte[] data;
    private int dataLen;
    byte[] buffer;
    private RegBigData bigData;

    public RegData(RegHeader head, byte[] buff, int offset) {
        this.buffer = buff;
        this.header = head;
        this.read(buff, offset);
    }

    public RegData(RegHeader head, byte[] buff, int offset, int datLen) {
        this.header = head;
        this.buffer = buff;
        this.dataLen = datLen;
        this.read(buff, offset);
    }

    public DataFormat getDataFormat() {
        int datLen;
        if (this.dataLen == 0) {
            this.dataLen = this.data.length;
        }
        if ((datLen = this.dataLen & Integer.MAX_VALUE) <= 4) {
            return DataFormat.SHORT;
        }
        if (datLen <= 16344) {
            return DataFormat.STANDARD;
        }
        return DataFormat.BIG;
    }

    public RegData(RegHeader head, byte[] newData) {
        this.header = head;
        this.buffer = this.header.buffer;
        this.dataLen = newData.length;
        if (this.getDataFormat() == DataFormat.BIG) {
            this.dataLen = newData.length;
            this.bigData = new RegBigData(this.header, newData);
            this.bigData.allocate();
            this.bigData.setOffset(this.bigData.getOffset());
            this.data = (byte[])this.bigData.getRecord().clone();
            this.size = -Converter.round8(this.bigData.getSize() + 4);
        } else {
            this.data = Arrays.copyOf(newData, newData.length);
            this.size = -Converter.round8(newData.length + 4);
        }
    }

    public RegData(RegHeader head, Object value, int type) {
        this.header = head;
        if (value == null) {
            throw new IllegalArgumentException();
        }
        byte[] raw = new byte[]{0, 0};
        switch (type) {
            case 0: 
            case 3: {
                byte[] srcArr = (byte[])value;
                raw = Arrays.copyOf(srcArr, srcArr.length);
                break;
            }
            case 4: 
            case 5: {
                raw = new byte[4];
                Integer srcInt = Integer.parseInt(value.toString());
                Converter.intToByteArray(srcInt, raw, 0);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                String srcStr = (String)value;
                byte[] tmpStr = new byte[]{0, 0};
                try {
                    tmpStr = srcStr.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                raw = new byte[tmpStr.length + 2];
                System.arraycopy(tmpStr, 0, raw, 0, tmpStr.length);
                break;
            }
            case 7: {
                int i;
                List srcMul = (List)value;
                int total = 0;
                int curr = 0;
                for (i = 0; i < srcMul.size(); ++i) {
                    total += 2 * ((String)srcMul.get(i)).length();
                }
                if (total > 0) {
                    total += 2 * srcMul.size() + 2;
                }
                raw = new byte[total];
                try {
                    for (i = 0; i < srcMul.size(); ++i) {
                        byte[] tmp = ((String)srcMul.get(i)).getBytes("UTF-16LE");
                        System.arraycopy(tmp, 0, raw, curr, tmp.length);
                        curr += tmp.length + 2;
                    }
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case 11: {
                raw = new byte[8];
                Long srcLng = (Long)value;
                Converter.longToByteArray(srcLng, raw, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.data = Arrays.copyOf(raw, raw.length);
        this.size = -Converter.round8(this.data.length + 4);
    }

    @Override
    public void read(byte[] buff, int offset) {
        super.read(buff, offset);
        this.data = Arrays.copyOfRange(buff, offset + 4, offset + 4 + Math.abs(this.size));
        switch (this.getDataFormat()) {
            case SHORT: {
                break;
            }
            case STANDARD: {
                break;
            }
            case BIG: {
                this.bigData = new RegBigData(this.header, this.buffer, offset, this.dataLen);
                this.data = (byte[])this.bigData.getRecord().clone();
            }
        }
    }

    @Override
    public void write(byte[] buff, int offset) {
        super.write(buff, offset);
        System.arraycopy(this.data, 0, buff, offset + 4, this.data.length);
    }

    public byte[] getData() {
        if (this.getDataFormat() == DataFormat.BIG) {
            return this.bigData.getData();
        }
        return this.data;
    }

    public byte[] getDataRecord() {
        return this.data;
    }

    public void replaceDataRecord(byte[] newBytes) {
        System.arraycopy(newBytes, 0, this.data, 0, newBytes.length);
    }

    public void commit(byte[] buffer) {
        this.write(buffer, this.absOffset);
        if (this.getDataFormat() == DataFormat.BIG) {
            this.bigData.commit(buffer);
        }
    }

    public void cleanup() {
        if (this.getDataFormat() == DataFormat.BIG) {
            this.bigData.cleanup();
        }
        this.deallocate();
    }

    static enum DataFormat {
        SHORT,
        STANDARD,
        BIG;

    }
}

