/*
 * Decompiled with CFR 0.152.
 */
package reg;

import reg.Converter;
import reg.RegEntity;
import reg.RegHeader;
import reg.RegKeyList;

public class RegCell
extends RegEntity {
    protected int absOffset;
    protected int size;
    protected RegHeader header;
    protected RegCell owner;
    protected int binIndex = -1;

    public RegCell() {
        this.absOffset = -1;
        this.size = 0;
    }

    public RegCell(byte[] buff, int offset) {
        this.read(buff, offset);
    }

    public RegCell(int offset, int size) {
        this.absOffset = offset;
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getOffset() {
        return this.absOffset;
    }

    public int getBinIndex() {
        return this.binIndex;
    }

    public RegCell getOwner() {
        return this.owner;
    }

    public RegHeader getHeader() {
        return this.header;
    }

    @Override
    public void read(byte[] buff, int offset) {
        this.absOffset = offset;
        this.size = Converter.byteArrayToInt(buff, offset);
    }

    @Override
    public void write(byte[] buff, int offset) {
        Converter.intToByteArray(this.size, buff, offset);
    }

    public void setOffset(int newOffset) {
        this.absOffset = newOffset;
    }

    public void setBinIndex(int index) {
        this.binIndex = index;
    }

    public int allocate() {
        this.absOffset = RegKeyList.class.isAssignableFrom(this.getClass()) ? this.header.resAllocate(this.size).getOffset() : this.header.allocate(this.size).getOffset();
        return this.size;
    }

    public void deallocate() {
        if (RegKeyList.class.isAssignableFrom(this.getClass())) {
            this.header.resDeallocate(this);
        } else {
            this.header.deallocate(this);
        }
    }

    public int reallocate() {
        this.deallocate();
        return this.allocate();
    }
}

