/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.util.Vector;
import reg.Converter;
import reg.RegCell;
import reg.RegEntity;

public class RegBin
extends RegEntity {
    private int offFromFirst;
    private int size;
    private int offToNext;
    private Vector<RegCell> taken;
    private Vector<RegCell> free;
    private boolean tainted = false;

    public RegBin(byte[] buff, int offset) {
        this.read(buff, offset);
    }

    public int getFreeBlocks() {
        return this.free.size();
    }

    public int getTakenBlocks() {
        return this.taken.size();
    }

    public void freeReserve() {
        this.deallocate(this.taken.elementAt(1).getOffset());
    }

    public void createReserve() {
        this.free.elementAt(0).setSize(-this.free.elementAt(0).getSize());
        this.taken.add(this.free.elementAt(0));
        this.free.clear();
    }

    @Override
    public void read(byte[] buff, int offset) {
        RegCell tmp;
        int ti;
        this.offFromFirst = Converter.byteArrayToInt(buff, offset + 4);
        this.size = Converter.byteArrayToInt(buff, offset + 8);
        this.offToNext = Converter.byteArrayToInt(buff, offset + 28);
        this.taken = new Vector();
        this.free = new Vector();
        for (int i = 32; i < this.size && (ti = (tmp = new RegCell(buff, offset + i)).getSize()) != 0; i += Math.abs(ti)) {
            if (ti < 0) {
                this.taken.add(tmp);
                continue;
            }
            this.free.add(tmp);
        }
    }

    @Override
    public void write(byte[] buff, int offset) {
        int i;
        if (!this.tainted) {
            return;
        }
        Converter.intToByteArray(this.offFromFirst, buff, offset + 4);
        Converter.intToByteArray(this.size, buff, offset + 8);
        Converter.intToByteArray(this.offToNext, buff, offset + 28);
        for (i = 0; i < this.taken.size(); ++i) {
            this.taken.elementAt(i).write(buff, this.taken.elementAt(i).getOffset());
        }
        for (i = 0; i < this.free.size(); ++i) {
            this.free.elementAt(i).write(buff, this.free.elementAt(i).getOffset());
        }
    }

    public RegCell allocate(int offset, int desiredSize) {
        RegCell desired = null;
        for (int i = 0; i < this.free.size(); ++i) {
            if (this.free.elementAt(i).getOffset() != offset) continue;
            if (this.free.elementAt(i).getSize() > desiredSize) {
                desired = new RegCell(this.free.elementAt(i).getOffset(), -desiredSize);
                this.free.elementAt(i).setSize(this.free.elementAt(i).getSize() - desiredSize);
                this.free.elementAt(i).setOffset(this.free.elementAt(i).getOffset() + desiredSize);
                this.taken.add(desired);
                return desired;
            }
            if (this.free.elementAt(i).getSize() != desiredSize) continue;
            desired = new RegCell(this.free.elementAt(i).getOffset(), -desiredSize);
            this.taken.add(desired);
            this.free.remove(i);
            return desired;
        }
        return null;
    }

    public void deallocate(int offset) {
        int i;
        RegCell target = null;
        for (i = 0; i < this.taken.size(); ++i) {
            if (this.taken.elementAt(i).getOffset() != offset) continue;
            target = this.taken.elementAt(i);
            this.taken.remove(i);
        }
        if (target == null) {
            return;
        }
        target.setSize(-target.getSize());
        for (i = 0; i < this.free.size(); ++i) {
            if (this.free.elementAt(i).getOffset() + this.free.elementAt(i).getSize() == target.getOffset()) {
                this.free.elementAt(i).setSize(this.free.elementAt(i).getSize() + target.getSize());
                return;
            }
            if (target.getOffset() + target.getSize() != this.free.elementAt(i).getOffset()) continue;
            target.setSize(target.getSize() + this.free.elementAt(i).getSize());
            this.free.remove(i);
            this.free.add(target);
            return;
        }
        this.free.add(target);
    }

    public RegCell findFree(int desiredSize) {
        if ((desiredSize = Converter.round8(desiredSize)) < 0 || desiredSize > this.size) {
            return null;
        }
        RegCell minCell = null;
        for (int i = 0; i < this.free.size(); ++i) {
            if (minCell == null && (this.free.elementAt(i).getSize() - desiredSize >= 4 || this.free.elementAt(i).getSize() == desiredSize)) {
                minCell = this.free.elementAt(i);
                continue;
            }
            if (minCell == null || this.free.elementAt(i).getSize() != desiredSize && this.free.elementAt(i).getSize() - desiredSize < 4 || this.free.elementAt(i).getSize() >= minCell.getSize()) continue;
            minCell = this.free.elementAt(i);
            if (this.free.elementAt(i).getSize() == desiredSize) break;
        }
        return minCell;
    }

    public int getOffFromFirst() {
        return this.offFromFirst;
    }

    public void setOffFromFirst(int offFromFirst) {
        this.offFromFirst = offFromFirst;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getOffToNext() {
        return this.offToNext;
    }

    public void setOffToNext(int offToNext) {
        this.offToNext = offToNext;
    }

    public void commit(byte[] buffer) {
        int i;
        this.write(buffer, 4096 + this.offFromFirst);
        for (i = 0; i < this.taken.size(); ++i) {
            this.taken.elementAt(i).write(buffer, this.taken.elementAt(i).getOffset());
        }
        for (i = 0; i < this.free.size(); ++i) {
            this.free.elementAt(i).write(buffer, this.free.elementAt(i).getOffset());
        }
    }
}

