/*
 * Decompiled with CFR 0.152.
 */
package reg;

import reg.Converter;
import reg.RegCell;
import reg.RegHeader;

public class RegBigDataOffsetList
extends RegCell {
    byte[] offsetList;
    int listSize;
    short numEntries;

    public RegBigDataOffsetList(RegHeader head, byte[] buff, int offset, short entNum) {
        this.header = head;
        this.numEntries = entNum;
        this.listSize = this.numEntries * 4;
        this.absOffset = offset;
        this.read(buff);
    }

    public RegBigDataOffsetList(RegHeader head, byte[] buff, short entNum) {
        this.header = head;
        this.numEntries = entNum;
        this.listSize = this.numEntries * 4;
        this.offsetList = new byte[this.listSize];
        this.size = -Converter.round8(this.listSize + 4);
        this.allocate();
    }

    public byte[] getList() {
        return this.offsetList;
    }

    public void setSingleOffset(int index, int offset) {
        Converter.intToByteArray(offset, this.offsetList, 4 * index);
    }

    public short getNumEntries() {
        return this.numEntries;
    }

    public final void read(byte[] buff) {
        super.read(buff, this.absOffset);
        this.offsetList = new byte[this.listSize];
        System.arraycopy(buff, this.absOffset + 4, this.offsetList, 0, this.listSize);
    }

    public void write(byte[] buff) {
        super.write(buff, this.absOffset);
        System.arraycopy(this.offsetList, 0, buff, this.absOffset + 4, this.listSize);
    }

    public void commit(byte[] buffer) {
        this.write(buffer);
    }
}

