/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.util.Vector;
import reg.Converter;
import reg.RegBigDataFragment;
import reg.RegBigDataOffsetList;
import reg.RegCell;
import reg.RegHeader;

public class RegBigDataFragmentList
extends RegCell {
    private int dataLen;
    private short entNum;
    private Vector<RegBigDataFragment> fragments;
    RegBigDataOffsetList offsetList;

    public RegBigDataFragmentList(RegHeader head, byte[] buff, int offset, int len, short numEntries) {
        this.header = head;
        this.dataLen = len;
        this.entNum = numEntries;
        this.offsetList = new RegBigDataOffsetList(this.header, buff, offset, this.entNum);
        this.entNum = this.offsetList.getNumEntries();
        byte[] listData = this.offsetList.getList();
        int readLen = this.dataLen;
        this.fragments = new Vector(this.entNum);
        for (int i = 0; i < this.entNum; ++i) {
            int actOffs = Converter.byteArrayToInt(listData, i * 4);
            RegBigDataFragment frag = new RegBigDataFragment(this.header, buff, 4096 + actOffs, readLen);
            readLen -= frag.getReadSize();
            this.fragments.add(frag);
        }
    }

    public RegBigDataFragmentList(RegHeader head, byte[] data) {
        this.header = head;
        this.dataLen = data.length;
        float num = (float)(this.dataLen / 16344) + 0.99f;
        this.entNum = (short)Math.round(num);
        this.fragments = new Vector(this.entNum);
        this.offsetList = new RegBigDataOffsetList(this.header, data, this.entNum);
        int actOffset = 0;
        for (int i = 0; i < this.entNum; ++i) {
            RegBigDataFragment frag = new RegBigDataFragment(this.header, data, actOffset);
            this.fragments.add(frag);
            this.offsetList.setSingleOffset(i, frag.getOffset() - 4096);
            actOffset += 16344;
        }
    }

    public byte[] getData() {
        byte[] data = new byte[this.dataLen];
        int off = 0;
        for (int i = 0; i < this.entNum; ++i) {
            int len = this.fragments.elementAt(i).getReadSize();
            byte[] tmp = this.fragments.elementAt(i).getData();
            System.arraycopy(tmp, 0, data, off, len);
            off += len;
        }
        return data;
    }

    @Override
    public int getOffset() {
        return this.offsetList.getOffset() - 4096;
    }

    public void cleanup() {
        for (int i = 0; i < this.entNum; ++i) {
            this.fragments.get(i).deallocate();
        }
        this.offsetList.deallocate();
    }

    public void commit(byte[] buffer) {
        this.offsetList.commit(buffer);
        for (int i = 0; i < this.entNum; ++i) {
            this.fragments.get(i).commit(buffer);
        }
    }

    public short getNumEntries() {
        return this.entNum;
    }

    public RegBigDataFragment get(int index) {
        return this.fragments.elementAt(index);
    }
}

