/*
 * Decompiled with CFR 0.152.
 */
package reg;

import reg.Converter;
import reg.RegCell;
import reg.RegHeader;

public class RegBigDataFragment
extends RegCell {
    private int readSize;
    private byte[] data;

    RegBigDataFragment(RegHeader head, byte[] buffer, int offset, int readLen) {
        this.header = head;
        this.readSize = readLen > 16344 ? 16344 : readLen;
        this.read(buffer, offset);
    }

    RegBigDataFragment(RegHeader head, byte[] allData, int dataOffset) {
        this.header = head;
        this.size = -Converter.round8(16348);
        this.readSize = allData.length - dataOffset;
        if (this.readSize > 16344) {
            this.readSize = 16344;
        }
        this.data = new byte[this.readSize];
        System.arraycopy(allData, dataOffset, this.data, 0, this.readSize);
        this.allocate();
    }

    public int getReadSize() {
        return this.readSize;
    }

    @Override
    public void read(byte[] buff, int offset) {
        super.read(buff, offset);
        this.data = new byte[this.readSize];
        System.arraycopy(buff, offset + 4, this.data, 0, this.readSize);
    }

    @Override
    public void write(byte[] buff, int offset) {
        super.write(buff, offset);
        if (this.data.length < 16344) {
            byte[] allData = new byte[16344];
            System.arraycopy(this.data, 0, allData, 0, this.data.length);
            System.arraycopy(allData, 0, buff, offset + 4, allData.length);
        } else {
            System.arraycopy(this.data, 0, buff, offset + 4, this.data.length);
        }
    }

    public void write(byte[] buffer) {
        this.write(buffer, this.absOffset);
    }

    public byte[] getData() {
        return this.data;
    }

    public void commit(byte[] buffer) {
        this.write(buffer, this.absOffset);
    }
}

