/*
 * Decompiled with CFR 0.152.
 */
package reg;

import reg.Converter;
import reg.RegBigDataFragmentList;
import reg.RegCell;
import reg.RegHeader;

public class RegBigData
extends RegCell {
    int bigDataListPointer;
    int dataLength;
    short numFragments;
    RegBigDataFragmentList fragments;
    final int dataSize = 12;
    byte[] bigDataRecord = new byte[12];

    public RegBigData(RegHeader head, byte[] buff, int offset, int dataLen) {
        this.size = -Converter.round8(16);
        this.header = head;
        this.dataLength = dataLen;
        this.read(buff, offset);
    }

    public RegBigData(RegHeader head, byte[] newData) {
        this.header = head;
        this.size = -Converter.round8(16);
        this.fragments = new RegBigDataFragmentList(this.header, newData);
        this.numFragments = this.fragments.getNumEntries();
        this.bigDataListPointer = this.fragments.getOffset();
        Converter.shortToByteArray((short)25188, this.bigDataRecord, 0);
        Converter.shortToByteArray(this.numFragments, this.bigDataRecord, 2);
        Converter.intToByteArray(this.bigDataListPointer, this.bigDataRecord, 4);
    }

    @Override
    public final void read(byte[] buff, int offs) {
        super.read(buff, offs);
        this.bigDataListPointer = Converter.byteArrayToInt(buff, offs + 4 + 4);
        this.fragments = new RegBigDataFragmentList(this.header, buff, this.bigDataListPointer + 4096, this.dataLength, this.numFragments);
        Converter.shortToByteArray((short)25188, this.bigDataRecord, 0);
        Converter.shortToByteArray(this.numFragments, this.bigDataRecord, 2);
        Converter.intToByteArray(this.bigDataListPointer, this.bigDataRecord, 4);
    }

    @Override
    public void write(byte[] buff, int offs) {
        Converter.shortToByteArray(this.numFragments, buff, offs + 4 + 2);
        Converter.intToByteArray(this.bigDataListPointer, buff, offs + 4 + 4);
    }

    public void write(byte[] buff) {
        this.write(buff, this.absOffset);
    }

    public short getEntNum() {
        return this.numFragments;
    }

    public byte[] getData() {
        return this.fragments.getData();
    }

    @Override
    public int getSize() {
        return Math.abs(this.size) - 4;
    }

    public byte[] getRecord() {
        return this.bigDataRecord;
    }

    public void commit(byte[] buff) {
        this.fragments.commit(buff);
        this.write(buff, this.absOffset);
    }

    public void cleanup() {
        this.fragments.cleanup();
        this.deallocate();
    }
}

