/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import reg.RegHeader;
import reg.RegKey;
import reg.RegKeyList;
import reg.RegVal;
import reg.RegValList;

public class HivePatcher {
    private final RegHeader header;
    private boolean isPatched;
    private static final String C = "C:\\";
    private static final String D = "D:\\";
    DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");

    public HivePatcher(String filePath) {
        this.header = new RegHeader(filePath);
        this.header.setAllowValOverwrite(RegHeader.AllowOverwrite.TRUE);
    }

    public HivePatcher(RegHeader header) {
        this.header = header;
        header.setAllowValOverwrite(RegHeader.AllowOverwrite.TRUE);
    }

    public void release() {
        this.header.release();
    }

    private String patchString(String content, String letter) {
        StringBuilder result = new StringBuilder(content);
        int pos = result.indexOf(letter);
        if (pos != -1) {
            this.isPatched = true;
            do {
                result.setCharAt(pos, 'X');
            } while ((pos = result.indexOf(letter)) != -1);
        }
        return result.toString();
    }

    public void patchLetter(String keyName) {
        RegKey key = this.header.readKey(keyName);
        this.patchLetter(key);
    }

    public void patchLetter(RegKey key) {
        RegKeyList keyList;
        RegValList vals = key.getValList();
        byte[] newBytes = null;
        if (vals != null) {
            for (int v = 0; v < vals.getNumEntries(); ++v) {
                String result = "";
                this.isPatched = false;
                RegVal val = vals.getVal(v);
                int theType = val.getType();
                if (theType == 1 || theType == 2) {
                    result = this.patchString((String)val.getValue(), D);
                    result = this.patchString(result, C);
                    try {
                        newBytes = result.getBytes("UTF-16LE");
                    }
                    catch (UnsupportedEncodingException ex) {
                        Logger.getLogger(HivePatcher.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (theType == 7 && val.getValueRaw().length > 4) {
                    Vector valList = (Vector)val.getValue();
                    int adr = 0;
                    for (int m = 0; m < valList.size(); ++m) {
                        String content = this.patchString((String)valList.elementAt(m), D);
                        content = this.patchString(content, C);
                        newBytes = new byte[val.getValueRaw().length];
                        byte[] tst = null;
                        try {
                            tst = content.getBytes("UTF-16LE");
                        }
                        catch (UnsupportedEncodingException ex) {
                            Logger.getLogger(HivePatcher.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        System.arraycopy(tst, 0, newBytes, adr, tst.length);
                        adr += tst.length + 2;
                    }
                }
                if (!this.isPatched) continue;
                val.replaceDataRecord(newBytes);
            }
        }
        if ((keyList = key.getChildList()) != null) {
            Vector<RegKey> keys = keyList.getSubkeys();
            for (int k = 0; k < keys.size(); ++k) {
                this.patchLetter(keys.elementAt(k));
            }
        }
    }

    private void log(String msg) {
        System.out.println(this.dateFormat.format(Calendar.getInstance().getTime()) + " " + msg);
    }

    private void commit() throws IOException {
        this.header.commit(true);
    }

    public void patchHiveFile() {
        this.header.open();
        this.patchLetter(this.header.root);
        try {
            this.commit();
        }
        catch (IOException ex) {
            Logger.getLogger(HivePatcher.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.release();
    }

    public static void main(String[] args) throws IOException {
        HivePatcher theHive = new HivePatcher("V:\\WB2_A\\WB2\\winbuilder\\run\\lib\\sourcehives\\de-DE.7601.0\\install\\SOFTWARE");
        theHive.patchHiveFile();
    }
}

