/*
 * Decompiled with CFR 0.152.
 */
package re7zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.sevenzipjbinding.ArchiveFormat;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.ISevenZipInArchive;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import re7zip.HttpIInStream;
import re7zip.MonitorIInStream;

public class HttpIsoReader {
    ISevenZipInArchive archive;

    private static void version() {
        System.out.println("\nre7zip version: 0.1");
        System.out.println("Website: http://code.google.com/p/re7zip/\n");
    }

    private static void usage() {
        String archive_types = "";
        System.out.println("\nUsage:    java -jar re7zip.jar [OPTIONS]\n");
        System.out.println("Options:");
        System.out.println("          /t  -t    archive filetype:");
        for (ArchiveFormat archive_format : ArchiveFormat.values()) {
            String archive_type = archive_format.toString().toLowerCase();
            if (archive_types.length() == 0) {
                archive_types = "                      " + archive_type;
                continue;
            }
            if (archive_types.length() < 70) {
                archive_types = archive_types + ", " + archive_type;
                continue;
            }
            System.out.println(archive_types + ", " + archive_type + ",");
            archive_types = "";
        }
        if (archive_types.length() != 0) {
            System.out.println(archive_types);
        }
        System.out.println("          /a  -a    archive filename or URL location of archive");
        System.out.println("          /e  -e    filename to extract out of the archive");
        System.out.println("          /o  -o    output filename for the extracted file");
        System.out.println("          /v  -v    show version info\n");
        System.out.println("Example:");
        System.out.println("          java -jar re7zip.jar /t=iso\n                               /a=http://test.com/test.iso\n                               /e=some\\file.txt\n                               /o=file.txt\n");
        System.out.println("          java -jar re7zip.jar -t=iso\n                               -a=http://test.com/test.iso\n                               -e=some/file.txt\n                               -o=file.txt\n");
    }

    public Boolean open(String URL2) {
        return this.open(URL2, null);
    }

    public Boolean open(String URL2, ArchiveFormat type) {
        try {
            this.archive = SevenZip.openInArchive(type, new MonitorIInStream(new HttpIInStream(URL2)));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Boolean open(File file) {
        return this.open(file, null);
    }

    public Boolean open(File file, ArchiveFormat type) {
        try {
            this.archive = SevenZip.openInArchive(type, new MonitorIInStream(new RandomAccessFileInStream(new RandomAccessFile(file, "r"))));
            return true;
        }
        catch (Exception ex) {
            System.err.println(ex.getLocalizedMessage());
            return false;
        }
    }

    public void getFile(String sourceFilePath, String targetFilePath) throws IOException, SevenZipException {
        File f = new File(targetFilePath);
        final FileOutputStream fos = new FileOutputStream(f);
        try {
            int index = this.lookupIndex(sourceFilePath);
            if (index == -1) {
                throw new SevenZipException("File [" + sourceFilePath + "]is not found");
            }
            ISimpleInArchiveItem item = this.archive.getSimpleInterface().getArchiveItem(index);
            int[] hash = new int[]{0};
            if (!item.isFolder()) {
                long[] sizeArray = new long[1];
                final Long size = item.getSize();
                ExtractOperationResult result = item.extractSlow(new ISequentialOutStream(){
                    long loaded = 0L;

                    @Override
                    public int write(byte[] data) throws SevenZipException {
                        try {
                            fos.write(data);
                            this.loaded += (long)data.length;
                            System.out.println(String.format("Percentage : %3s Reading %9s of %9s bytes", this.loaded * 100L / size, this.loaded, size));
                            return data.length;
                        }
                        catch (IOException ex) {
                            throw new SevenZipException(ex);
                        }
                    }
                });
                if (result == ExtractOperationResult.OK) {
                    fos.flush();
                    fos.close();
                } else {
                    System.err.println("Error extracting item: " + (Object)((Object)result));
                }
            }
        }
        catch (IOException ex) {
            throw new SevenZipException(ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                throw new SevenZipException(ex);
            }
        }
    }

    public void close() {
        try {
            this.archive.close();
        }
        catch (SevenZipException ex) {
            Logger.getLogger(HttpIsoReader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private int lookupIndex(String sourceFilePath) throws SevenZipException {
        int numberOfItems = this.archive.getNumberOfItems();
        for (int i = 0; i < numberOfItems; ++i) {
            if (!this.archive.getSimpleInterface().getArchiveItem(i).getPath().equals(sourceFilePath)) continue;
            return i;
        }
        return -1;
    }

    public static void main(String[] a) throws Exception {
        String archive_filename = null;
        ArchiveFormat archive_type = null;
        String extract_filename = null;
        String output_filename = null;
        for (String arg : a) {
            String arg_lower = arg.toLowerCase();
            if (arg_lower.startsWith("/t=") || arg_lower.startsWith("-t=")) {
                String archive_type_arg = arg.substring(3).toUpperCase();
                if (archive_type_arg.equals("7Z")) {
                    archive_type_arg = "SEVEN_ZIP";
                }
                try {
                    archive_type = ArchiveFormat.valueOf(archive_type_arg);
                }
                catch (IllegalArgumentException e) {
                    System.out.println("\nInvalid File Type : " + archive_type_arg + "\n");
                    HttpIsoReader.usage();
                    System.exit(1);
                }
                continue;
            }
            if (arg_lower.startsWith("/a=") || arg_lower.startsWith("-a=")) {
                archive_filename = arg.substring(3);
                continue;
            }
            if (arg_lower.startsWith("/e=") || arg_lower.startsWith("-e=")) {
                extract_filename = arg.substring(3);
                continue;
            }
            if (arg_lower.startsWith("/o=") || arg_lower.startsWith("-o=")) {
                output_filename = arg.substring(3);
                continue;
            }
            if (!arg_lower.startsWith("/v") && !arg_lower.startsWith("-v") && !arg_lower.startsWith("--v")) continue;
            HttpIsoReader.version();
            System.exit(0);
        }
        if (archive_type == null || archive_filename == null || extract_filename == null || output_filename == null) {
            HttpIsoReader.usage();
            System.exit(1);
        }
        long start = System.currentTimeMillis();
        HttpIsoReader reader = new HttpIsoReader();
        Boolean result = false;
        if (archive_filename.toLowerCase().startsWith("http://")) {
            System.out.println("Opening HTTP archive '" + archive_filename + "'.");
            result = reader.open(archive_filename, archive_type);
        } else {
            System.out.println("Opening FILE archive '" + archive_filename + "'.");
            try {
                result = reader.open(new File(archive_filename), archive_type);
            }
            catch (Exception e) {
                System.out.println("Invalid '" + (Object)((Object)archive_type) + "'  file '" + archive_filename + "'.");
                HttpIsoReader.usage();
                System.exit(1);
            }
        }
        if (result.booleanValue()) {
            System.out.println("Archive '" + archive_filename + "' is open.");
        } else {
            System.out.println("Failed to open archive '" + archive_filename + "'.");
            System.exit(1);
        }
        extract_filename = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 ? extract_filename.replaceAll("/", "\\\\").replaceAll("^\\\\*", "") : extract_filename.replaceAll("\\\\", "/").replaceAll("^/*", "");
        System.out.println("Extracting file '" + extract_filename + "' ...");
        try {
            reader.getFile(extract_filename, output_filename);
            reader.close();
        }
        catch (Exception e) {
            System.out.println("Filename '" + extract_filename + "' is not found in the archive.");
            System.exit(1);
        }
        long end = System.currentTimeMillis();
        long time2 = (end - start) / 1000L;
        if (archive_filename.toLowerCase().startsWith("http://")) {
            System.out.println("Done. Downloaded in " + time2 / 60L + " minutes and " + time2 % 60L + " seconds.");
        } else {
            System.out.println("Done. Processed in " + time2 / 60L + " minutes and " + time2 % 60L + " seconds.");
        }
        System.exit(0);
    }
}

