/*
 * Decompiled with CFR 0.152.
 */
package re7zip;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.SevenZipException;

public class HttpIInStream
implements IInStream {
    URL url;
    URLConnection conexion;
    long length;
    InputStream stream;
    long position = 0L;

    public HttpIInStream(String url) throws Exception {
        this.url = new URL(url);
        this.conexion = this.url.openConnection();
        this.length = Long.parseLong(this.conexion.getHeaderField("Content-Length"));
    }

    private void positionStream(long pos) throws Exception {
        if (this.position == pos) {
            return;
        }
        if (this.stream != null) {
            this.stream.close();
        }
        this.position = pos;
        if (pos == this.length) {
            return;
        }
        this.conexion = this.url.openConnection();
        this.conexion.setRequestProperty("Range", "bytes=" + pos + "-");
        this.conexion.connect();
        this.stream = this.conexion.getInputStream();
        this.position = pos;
    }

    @Override
    public long seek(long offset, int seekOrigin) throws SevenZipException {
        try {
            switch (seekOrigin) {
                case 0: {
                    this.positionStream(offset);
                    break;
                }
                case 1: {
                    this.positionStream(offset + this.position);
                    break;
                }
                case 2: {
                    this.positionStream(this.length + offset);
                    break;
                }
                default: {
                    throw new RuntimeException("Seek: unknown origin: " + seekOrigin);
                }
            }
            return this.position;
        }
        catch (Exception e) {
            throw new SevenZipException("Error while seek operation", e);
        }
    }

    @Override
    public int read(byte[] data) throws SevenZipException {
        try {
            int read = this.stream.read(data);
            if (read == -1) {
                System.out.println("Read Only");
                return 0;
            }
            this.position += (long)read;
            return read;
        }
        catch (IOException e) {
            throw new SevenZipException("Error reading random access file", e);
        }
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

