/*
 * Decompiled with CFR 0.152.
 */
package re7zip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import net.sf.sevenzipjbinding.ArchiveFormat;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.ISevenZipInArchive;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import utils.files;

public class Extract {
    private String archive;
    private String outputDirectory;
    private File outputDirectoryFile;
    ArchiveFormat archiveFormat = ArchiveFormat.UDF;

    public void setArchiveFormat(ArchiveFormat archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public Extract(String archive, String outputDirectory) {
        this.archive = archive;
        this.outputDirectory = outputDirectory;
        File dir2 = new File(outputDirectory);
        if (dir2.exists()) {
            files.deleteDir(dir2);
            files.mkdirs(dir2);
        }
    }

    public void extract() throws ExtractionException {
        this.checkArchiveFile();
        this.prepareOutputDirectory();
        this.extractArchive();
    }

    private void prepareOutputDirectory() throws ExtractionException {
        this.outputDirectoryFile = new File(this.outputDirectory);
        if (!this.outputDirectoryFile.exists()) {
            this.outputDirectoryFile.mkdirs();
        } else if (this.outputDirectoryFile.list().length != 0) {
            throw new ExtractionException("Output directory not empty: " + this.outputDirectory);
        }
    }

    private void checkArchiveFile() throws ExtractionException {
        if (!new File(this.archive).exists()) {
            throw new ExtractionException("Archive file not found: " + this.archive);
        }
        if (!new File(this.archive).canRead()) {
            System.out.println("Can't read archive file: " + this.archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractArchive() throws ExtractionException {
        RandomAccessFile randomAccessFile;
        boolean ok = false;
        try {
            randomAccessFile = new RandomAccessFile(this.archive, "r");
        }
        catch (FileNotFoundException e) {
            throw new ExtractionException("File not found", e);
        }
        try {
            this.extractArchive(randomAccessFile);
            ok = true;
        }
        finally {
            block10: {
                try {
                    randomAccessFile.close();
                }
                catch (Exception e) {
                    if (!ok) break block10;
                    throw new ExtractionException("Error closing archive file", e);
                }
            }
        }
    }

    private void extractArchive(RandomAccessFile file) throws ExtractionException {
        ISevenZipInArchive inArchive;
        boolean ok = false;
        try {
            inArchive = SevenZip.openInArchive(this.archiveFormat, new RandomAccessFileInStream(file));
        }
        catch (SevenZipException e) {
            throw new ExtractionException("Error opening archive", e);
        }
        try {
            ExtractCallback ex = new ExtractCallback(inArchive);
            inArchive.extract(null, false, ex);
            ex.closeOutputStream();
            ok = true;
        }
        catch (SevenZipException e) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error extracting archive '");
            stringBuilder.append(this.archive);
            stringBuilder.append("': ");
            stringBuilder.append(e.getMessage());
            if (e.getCause() != null) {
                stringBuilder.append(" (");
                stringBuilder.append(e.getCause().getMessage());
                stringBuilder.append(')');
            }
            String message = stringBuilder.toString();
            throw new ExtractionException(message, e);
        }
        finally {
            block13: {
                try {
                    inArchive.close();
                }
                catch (SevenZipException e) {
                    if (!ok) break block13;
                    throw new ExtractionException("Error closing archive", e);
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            new Extract("d:\\udf\\win7sp1-X17-59183.iso", "d:\\udf\\test").extract();
            System.out.println("Extraction successfull");
        }
        catch (ExtractionException e) {
            System.err.println("ERROR: " + e.getLocalizedMessage());
        }
    }

    class ExtractCallback
    implements IArchiveExtractCallback {
        private ISevenZipInArchive inArchive;
        private int index;
        private Boolean skipExtraction;
        private OutputStream outputStream;
        private File file;

        ExtractCallback(ISevenZipInArchive inArchive) {
            this.inArchive = inArchive;
        }

        @Override
        public void setTotal(long total) throws SevenZipException {
        }

        @Override
        public void setCompleted(long completeValue) throws SevenZipException {
        }

        @Override
        public ISequentialOutStream getStream(int index, ExtractAskMode extractAskMode) throws SevenZipException {
            this.closeOutputStream();
            this.index = index;
            this.skipExtraction = (Boolean)this.inArchive.getProperty(index, PropID.IS_FOLDER);
            String path = (String)this.inArchive.getProperty(index, PropID.PATH);
            this.file = new File(Extract.this.outputDirectoryFile, path);
            if (this.skipExtraction.booleanValue() || extractAskMode != ExtractAskMode.EXTRACT) {
                this.createDirectory(this.file);
                return null;
            }
            this.createDirectory(this.file.getParentFile());
            System.out.println(path);
            try {
                this.outputStream = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new SevenZipException("Error opening file: " + this.file.getAbsolutePath(), e);
            }
            return new ISequentialOutStream(){

                @Override
                public int write(byte[] data) throws SevenZipException {
                    try {
                        ExtractCallback.this.outputStream.write(data);
                    }
                    catch (IOException e) {
                        throw new SevenZipException("Error writing to file: " + ExtractCallback.this.file.getAbsolutePath());
                    }
                    return data.length;
                }
            };
        }

        private void createDirectory(File parentFile) throws SevenZipException {
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new SevenZipException("Error creating directory: " + parentFile.getAbsolutePath());
            }
        }

        private void closeOutputStream() throws SevenZipException {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    throw new SevenZipException("Error closing file: " + this.file.getAbsolutePath());
                }
            }
        }

        @Override
        public void prepareOperation(ExtractAskMode extractAskMode) throws SevenZipException {
        }

        @Override
        public void setOperationResult(ExtractOperationResult extractOperationResult) throws SevenZipException {
            if (this.skipExtraction.booleanValue()) {
                return;
            }
            if (extractOperationResult != ExtractOperationResult.OK) {
                String path = (String)this.inArchive.getProperty(this.index, PropID.PATH);
                throw new SevenZipException("Extraction error: " + path);
            }
        }
    }

    static class ExtractionException
    extends Exception {
        private static final long serialVersionUID = -5108931481040742838L;

        ExtractionException(String msg) {
            super(msg);
        }

        public ExtractionException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

