/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.util.parse;

public class ParseBuffer {
    protected String cache;
    protected char[] buf;
    protected int count;

    public ParseBuffer() {
        this(16);
    }

    public ParseBuffer(int size) {
        this.buf = new char[size];
    }

    public void append(char c) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count++] = c;
    }

    public void append(String text2) {
        this.ensureCapacity(this.count + text2.length());
        text2.getChars(0, text2.length(), this.buf, this.count);
        this.count += text2.length();
    }

    public void reset(String text2) {
        this.clear();
        this.append(text2);
    }

    public void append(ParseBuffer text2) {
        this.append(text2.buf, 0, text2.count);
    }

    public void reset(ParseBuffer text2) {
        this.clear();
        this.append(text2);
    }

    public void append(char[] c, int off, int len) {
        this.ensureCapacity(this.count + len);
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count += len;
    }

    public void append(String str, int off, int len) {
        this.ensureCapacity(this.count + len);
        str.getChars(off, len, this.buf, this.count);
        this.count += len;
    }

    public void append(ParseBuffer text2, int off, int len) {
        this.append(text2.buf, off, len);
    }

    protected void ensureCapacity(int min) {
        if (this.buf.length < min) {
            int size = this.buf.length * 2;
            int max = Math.max(min, size);
            char[] temp = new char[max];
            System.arraycopy(this.buf, 0, temp, 0, this.count);
            this.buf = temp;
        }
    }

    public void clear() {
        this.cache = null;
        this.count = 0;
    }

    public int length() {
        return this.count;
    }

    public String toString() {
        if (this.count <= 0) {
            return null;
        }
        if (this.cache != null) {
            return this.cache;
        }
        this.cache = new String(this.buf, 0, this.count);
        return this.cache;
    }
}

