/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.parse;

import java.util.Calendar;
import java.util.TimeZone;
import org.simpleframework.util.parse.Parser;

public class DateParser
extends Parser {
    private static final TimeZone ZONE = TimeZone.getTimeZone("GMT");
    private static final String[] WKDAYS = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private static final String[] WEEKDAYS = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private int month;
    private int year;
    private int day;
    private int weekday;
    private int hour;
    private int mins;
    private int secs;

    public static String getDate() {
        long time2 = System.currentTimeMillis();
        return new DateParser(time2).toString();
    }

    public DateParser() {
        this.init();
    }

    public DateParser(long date) {
        this();
        this.parse(date);
    }

    public DateParser(String date) {
        this();
        this.parse(date);
    }

    public void parse(long date) {
        Calendar calendar = Calendar.getInstance(ZONE);
        calendar.setTimeInMillis(date);
        this.weekday = calendar.get(7);
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.mins = calendar.get(12);
        this.secs = calendar.get(13);
        this.month = this.month > 11 ? 11 : this.month;
        this.weekday = (this.weekday + 5) % 7;
    }

    public long convert(String date) {
        this.parse(date);
        return this.toLong();
    }

    public String convert(long date) {
        this.parse(date);
        return this.toString();
    }

    protected void init() {
        this.off = 0;
        this.secs = 0;
        this.mins = 0;
        this.hour = 0;
        this.weekday = 0;
        this.day = 0;
        this.year = 0;
        this.month = 0;
    }

    protected void parse() {
        if (this.buf.length < 4) {
            return;
        }
        if (this.buf[3] == ',') {
            this.rfc1123();
        } else if (this.buf[3] == ' ') {
            this.asctime();
        } else {
            this.rfc850();
        }
    }

    private void rfc1123() {
        this.wkday();
        this.off += 2;
        this.date1();
        ++this.off;
        this.time();
    }

    private void rfc850() {
        this.weekday();
        this.off += 2;
        this.date2();
        ++this.off;
        this.time();
    }

    private void asctime() {
        this.wkday();
        ++this.off;
        this.date3();
        ++this.off;
        this.time();
        ++this.off;
        this.year4();
    }

    private void date1() {
        this.day();
        ++this.off;
        this.month();
        ++this.off;
        this.year4();
    }

    private void date2() {
        this.day();
        ++this.off;
        this.month();
        ++this.off;
        this.year2();
    }

    private void date3() {
        this.month();
        ++this.off;
        this.day();
    }

    private void day() {
        if (this.space(this.buf[this.off])) {
            ++this.off;
        }
        while (this.off < this.count && this.digit(this.buf[this.off])) {
            this.day *= 10;
            this.day += this.buf[this.off];
            this.day -= 48;
            ++this.off;
        }
    }

    private void year2() {
        int mill = 2000;
        int cent = 0;
        while (this.off < this.count && this.digit(this.buf[this.off])) {
            cent *= 10;
            cent += this.buf[this.off];
            cent -= 48;
            ++this.off;
        }
        this.year = mill + cent;
    }

    private void year4() {
        while (this.off < this.count && this.digit(this.buf[this.off])) {
            this.year *= 10;
            this.year += this.buf[this.off];
            this.year -= 48;
            ++this.off;
        }
    }

    private void time() {
        this.hours();
        ++this.off;
        this.mins();
        ++this.off;
        this.secs();
    }

    private void hours() {
        while (this.off < this.count && this.digit(this.buf[this.off])) {
            this.hour *= 10;
            this.hour += this.buf[this.off];
            this.hour -= 48;
            ++this.off;
        }
    }

    private void mins() {
        while (this.off < this.count && this.digit(this.buf[this.off])) {
            this.mins *= 10;
            this.mins += this.buf[this.off];
            this.mins -= 48;
            ++this.off;
        }
    }

    private void secs() {
        while (this.off < this.count && this.digit(this.buf[this.off])) {
            this.secs *= 10;
            this.secs += this.buf[this.off];
            this.secs -= 48;
            ++this.off;
        }
    }

    private void wkday() {
        for (int i = 0; i < WKDAYS.length; ++i) {
            if (!this.skip(WKDAYS[i])) continue;
            this.weekday = i;
            return;
        }
    }

    private void weekday() {
        for (int i = 0; i < WKDAYS.length; ++i) {
            if (!this.skip(WEEKDAYS[i])) continue;
            this.weekday = i;
            return;
        }
    }

    private void month() {
        for (int i = 0; i < MONTHS.length; ++i) {
            if (!this.skip(MONTHS[i])) continue;
            this.month = i;
            return;
        }
    }

    private void date(StringBuilder builder) {
        builder.append(WKDAYS[this.weekday]);
        builder.append(", ");
        if (this.day <= 9) {
            builder.append('0');
        }
        builder.append(this.day);
        builder.append(' ');
        builder.append(MONTHS[this.month]);
        builder.append(' ');
        builder.append(this.year);
        builder.append(' ');
    }

    private void time(StringBuilder builder) {
        if (this.hour <= 9) {
            builder.append('0');
        }
        builder.append(this.hour);
        builder.append(':');
        if (this.mins <= 9) {
            builder.append('0');
        }
        builder.append(this.mins);
        builder.append(':');
        if (this.secs <= 9) {
            builder.append('0');
        }
        builder.append(this.secs);
        builder.append(' ');
    }

    private void zone(StringBuilder builder) {
        builder.append("GMT");
    }

    public long toLong() {
        Calendar calendar = Calendar.getInstance(ZONE);
        calendar.set(this.year, this.month, this.day, this.hour, this.mins, this.secs);
        return calendar.getTime().getTime();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(30);
        this.date(builder);
        this.time(builder);
        this.zone(builder);
        return builder.toString();
    }
}

