/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import org.simpleframework.http.ContentType;
import org.simpleframework.http.Cookie;
import org.simpleframework.http.ResponseHeader;
import org.simpleframework.http.core.Message;
import org.simpleframework.http.parse.ContentParser;

class ResponseMessage
extends Message
implements ResponseHeader {
    private String text = "OK";
    private int major = 1;
    private int minor = 1;
    private int code = 200;

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text2) {
        this.text = text2;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public ContentType getContentType() {
        String value = this.getValue("Content-Type");
        if (value == null) {
            return null;
        }
        return new ContentParser(value);
    }

    public int getContentLength() {
        return this.getInteger("Content-Length");
    }

    public String getTransferEncoding() {
        return this.getValue("Transfer-Encoding");
    }

    protected byte[] getMessage() throws IOException {
        return this.toString().getBytes("ISO-8859-1");
    }

    public String toString() {
        StringBuilder head = new StringBuilder(256);
        head.append("HTTP/").append(this.major);
        head.append('.').append(this.minor);
        head.append(' ').append(this.code);
        head.append(' ').append(this.text);
        head.append("\r\n");
        for (String name : this.getNames()) {
            for (String value : this.getAll(name)) {
                head.append(name);
                head.append(": ");
                head.append(value);
                head.append("\r\n");
            }
        }
        for (Cookie cookie : this.getCookies()) {
            head.append("Set-Cookie: ");
            head.append(cookie);
            head.append("\r\n");
        }
        return head.append("\r\n").toString();
    }
}

