/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.cache.AbstractFilesCache;
import org.apache.commons.vfs.cache.FileSystemAndNameKey;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.util.Messages;

public class SoftRefFilesCache
extends AbstractFilesCache {
    private Log log = LogFactory.getLog(class$org$apache$commons$vfs$cache$SoftRefFilesCache == null ? (class$org$apache$commons$vfs$cache$SoftRefFilesCache = SoftRefFilesCache.class$("org.apache.commons.vfs.cache.SoftRefFilesCache")) : class$org$apache$commons$vfs$cache$SoftRefFilesCache);
    private final Map filesystemCache = new HashMap();
    private final Map refReverseMap = new HashMap(100);
    private final ReferenceQueue refqueue = new ReferenceQueue();
    private SoftRefReleaseThread softRefReleaseThread = null;
    static /* synthetic */ Class class$org$apache$commons$vfs$cache$SoftRefFilesCache;
    static /* synthetic */ Class class$org$apache$commons$vfs$cache$SoftRefFilesCache$SoftRefReleaseThread;

    private void startThread() {
        if (this.softRefReleaseThread != null) {
            throw new IllegalStateException(Messages.getString("vfs.impl/SoftRefReleaseThread-already-running.warn"));
        }
        this.softRefReleaseThread = new SoftRefReleaseThread();
        this.softRefReleaseThread.start();
    }

    private void endThread() {
        if (this.softRefReleaseThread != null) {
            this.softRefReleaseThread.requestEnd = true;
            this.softRefReleaseThread.interrupt();
            this.softRefReleaseThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFile(FileObject file) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("putFile: " + file.getName());
        }
        Map files2 = this.getOrCreateFilesystemCache(file.getFileSystem());
        Reference ref = this.createReference(file, this.refqueue);
        FileSystemAndNameKey key = new FileSystemAndNameKey(file.getFileSystem(), file.getName());
        Map map = files2;
        synchronized (map) {
            files2.put(file.getName(), ref);
            this.refReverseMap.put(ref, key);
        }
    }

    protected Reference createReference(FileObject file, ReferenceQueue refqueue) {
        return new SoftReference<FileObject>(file, refqueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFile(FileSystem filesystem, FileName name) {
        Map files2;
        Map map = files2 = this.getOrCreateFilesystemCache(filesystem);
        synchronized (map) {
            Reference ref = (Reference)files2.get(name);
            if (ref == null) {
                return null;
            }
            FileObject fo = (FileObject)ref.get();
            if (fo == null) {
                this.removeFile(filesystem, name);
            }
            return fo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(FileSystem filesystem) {
        boolean closeFilesystem;
        Map files2;
        Map map = files2 = this.getOrCreateFilesystemCache(filesystem);
        synchronized (map) {
            Iterator iterKeys = this.refReverseMap.values().iterator();
            while (iterKeys.hasNext()) {
                FileSystemAndNameKey key = (FileSystemAndNameKey)iterKeys.next();
                if (key.getFileSystem() != filesystem) continue;
                iterKeys.remove();
                files2.remove(key.getFileName());
            }
            closeFilesystem = files2.size() < 1;
        }
        if (closeFilesystem) {
            this.filesystemClose(filesystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filesystemClose(FileSystem filesystem) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("close fs: " + filesystem.getRootName());
        }
        Map map = this.filesystemCache;
        synchronized (map) {
            this.filesystemCache.remove(filesystem);
            if (this.filesystemCache.size() < 1) {
                this.endThread();
            }
        }
        ((DefaultFileSystemManager)this.getContext().getFileSystemManager())._closeFileSystem(filesystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        this.endThread();
        Map map = this.filesystemCache;
        synchronized (map) {
            this.filesystemCache.clear();
        }
        this.refReverseMap.clear();
    }

    public void removeFile(FileSystem filesystem, FileName name) {
        if (this.removeFile(new FileSystemAndNameKey(filesystem, name))) {
            this.filesystemClose(filesystem);
        }
    }

    public void touchFile(FileObject file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFile(FileSystemAndNameKey key) {
        Map files2;
        if (this.log.isDebugEnabled()) {
            this.log.debug("removeFile: " + key.getFileName());
        }
        Map map = files2 = this.getOrCreateFilesystemCache(key.getFileSystem());
        synchronized (map) {
            Object ref = files2.remove(key.getFileName());
            if (ref != null) {
                this.refReverseMap.remove(ref);
            }
            return files2.size() < 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getOrCreateFilesystemCache(FileSystem filesystem) {
        Map map = this.filesystemCache;
        synchronized (map) {
            TreeMap files2;
            if (this.filesystemCache.size() < 1) {
                this.startThread();
            }
            if ((files2 = (TreeMap)this.filesystemCache.get(filesystem)) == null) {
                files2 = new TreeMap();
                this.filesystemCache.put(filesystem, files2);
            }
            return files2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SoftRefReleaseThread
    extends Thread {
        private boolean requestEnd = false;

        private SoftRefReleaseThread() {
            this.setName((class$org$apache$commons$vfs$cache$SoftRefFilesCache$SoftRefReleaseThread == null ? (class$org$apache$commons$vfs$cache$SoftRefFilesCache$SoftRefReleaseThread = SoftRefFilesCache.class$("org.apache.commons.vfs.cache.SoftRefFilesCache$SoftRefReleaseThread")) : class$org$apache$commons$vfs$cache$SoftRefFilesCache$SoftRefReleaseThread).getName());
            this.setDaemon(true);
        }

        public void run() {
            while (!this.requestEnd && !Thread.currentThread().isInterrupted()) {
                try {
                    FileSystemAndNameKey key;
                    Reference ref = SoftRefFilesCache.this.refqueue.remove(1000L);
                    if (ref == null || (key = (FileSystemAndNameKey)SoftRefFilesCache.this.refReverseMap.get(ref)) == null || !SoftRefFilesCache.this.removeFile(key)) continue;
                    SoftRefFilesCache.this.filesystemClose(key.getFileSystem());
                }
                catch (InterruptedException e) {
                    if (this.requestEnd) break;
                    VfsLog.warn(SoftRefFilesCache.this.getLogger(), SoftRefFilesCache.this.log, Messages.getString("vfs.impl/SoftRefReleaseThread-interrupt.info"));
                    break;
                }
            }
        }
    }
}

