/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.cache.AbstractFilesCache;

public class DefaultFilesCache
extends AbstractFilesCache {
    private final Map filesystemCache = new HashMap(10);

    public void putFile(FileObject file) {
        Map files2 = this.getOrCreateFilesystemCache(file.getFileSystem());
        files2.put(file.getName(), file);
    }

    public FileObject getFile(FileSystem filesystem, FileName name) {
        Map files2 = this.getOrCreateFilesystemCache(filesystem);
        return (FileObject)files2.get(name);
    }

    public void clear(FileSystem filesystem) {
        Map files2 = this.getOrCreateFilesystemCache(filesystem);
        files2.clear();
    }

    protected Map getOrCreateFilesystemCache(FileSystem filesystem) {
        TreeMap files2 = (TreeMap)this.filesystemCache.get(filesystem);
        if (files2 == null) {
            files2 = new TreeMap();
            this.filesystemCache.put(filesystem, files2);
        }
        return files2;
    }

    public void close() {
        super.close();
        this.filesystemCache.clear();
    }

    public void removeFile(FileSystem filesystem, FileName name) {
        Map files2 = this.getOrCreateFilesystemCache(filesystem);
        files2.remove(name);
    }

    public void touchFile(FileObject file) {
    }
}

