/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.sf.sevenzipjbinding.ArchiveFormat;
import net.sf.sevenzipjbinding.IArchiveOpenCallback;
import net.sf.sevenzipjbinding.ICryptoGetTextPassword;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.ISevenZipInArchive;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.SevenZipNativeInitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SevenZip {
    private static final String SYSTEM_PROPERTY_TMP = "java.io.tmpdir";
    private static final String SYSTEM_PROPERTY_SEVEN_ZIP_NO_DO_PRIVILEGED_INITIALIZATION = "sevenzip.no_doprivileged_initialization";
    private static final String PROPERTY_SEVENZIPJBINDING_LIBNAME = "sevenzipjbinding.libname.%s";
    private static final String PROPERTY_BUILD_REF = "build.ref";
    private static final String SEVENZIPJBINDING_LIB_PROPERTIES_FILENAME = "sevenzipjbinding-lib.properties";
    private static final String SEVENZIPJBINDING_PLATFORMS_PROPRETIES_FILENAME = "/sevenzipjbinding-platforms.properties";
    private static boolean autoInitializationWillOccur = true;
    private static boolean initializationSuccessful = false;
    private static SevenZipNativeInitializationException lastInitializationException = null;
    private static List<String> availablePlatforms = null;
    private static String usedPlatform = null;
    private static File[] temporaryArtifacts = null;

    private SevenZip() {
    }

    public static boolean isInitializedSuccessfully() {
        return initializationSuccessful;
    }

    public static Throwable getLastInitializationException() {
        return lastInitializationException;
    }

    public static boolean isAutoInitializationWillOccur() {
        return autoInitializationWillOccur;
    }

    public static String getUsedPlatform() {
        return usedPlatform;
    }

    public static List<String> getPlatformList() throws SevenZipNativeInitializationException {
        String string;
        if (availablePlatforms != null) {
            return availablePlatforms;
        }
        InputStream inputStream = SevenZip.class.getResourceAsStream(SEVENZIPJBINDING_PLATFORMS_PROPRETIES_FILENAME);
        if (inputStream == null) {
            throw new SevenZipNativeInitializationException("Can not find 7-Zip-JBinding platform property file /sevenzipjbinding-platforms.properties. Make sure the 'sevenzipjbinding-<Platform>.jar' file is in the class path or consider initializing SevenZipJBinding manualy using one of the offered initialization methods: 'net.sf.sevenzipjbinding.SevenZip.init*()'");
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            SevenZip.throwInitException(iOException, "Error loading existing property file /sevenzipjbinding-platforms.properties");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        while ((string = properties.getProperty("platform." + n)) != null) {
            arrayList.add(string);
            ++n;
        }
        availablePlatforms = arrayList;
        return availablePlatforms;
    }

    public static File[] getTemporaryArtifacts() {
        return temporaryArtifacts;
    }

    public static void initSevenZipFromPlatformJAR() throws SevenZipNativeInitializationException {
        SevenZip.initSevenZipFromPlatformJARIntern(null, null);
    }

    public static void initSevenZipFromPlatformJAR(File file) throws SevenZipNativeInitializationException {
        SevenZip.initSevenZipFromPlatformJARIntern(null, file);
    }

    public static void initSevenZipFromPlatformJAR(String string, File file) throws SevenZipNativeInitializationException {
        SevenZip.initSevenZipFromPlatformJARIntern(string, file);
    }

    public static void initSevenZipFromPlatformJAR(String string) throws SevenZipNativeInitializationException {
        SevenZip.initSevenZipFromPlatformJARIntern(string, null);
    }

    private static void initSevenZipFromPlatformJARIntern(String string, File file) throws SevenZipNativeInitializationException {
        try {
            autoInitializationWillOccur = false;
            if (initializationSuccessful) {
                return;
            }
            SevenZip.determineAndSetUsedPlatform(string);
            Properties properties = SevenZip.loadSevenZipJBindingLibProperties();
            File file2 = SevenZip.createOrVerifyTmpDir(file);
            File file3 = SevenZip.getOrCreateSevenZipJBindingTmpDir(file2, properties);
            List<File> list = SevenZip.copyOrSkipLibraries(properties, file3);
            SevenZip.loadNativeLibraries(list);
            SevenZip.nativeInitialization();
        }
        catch (SevenZipNativeInitializationException sevenZipNativeInitializationException) {
            lastInitializationException = sevenZipNativeInitializationException;
            throw sevenZipNativeInitializationException;
        }
    }

    private static void determineAndSetUsedPlatform(String string) throws SevenZipNativeInitializationException {
        usedPlatform = string == null ? SevenZip.getPlatformBestMatch() : string;
    }

    private static Properties loadSevenZipJBindingLibProperties() throws SevenZipNativeInitializationException {
        String string = "/" + usedPlatform + "/";
        InputStream inputStream = SevenZip.class.getResourceAsStream(string + SEVENZIPJBINDING_LIB_PROPERTIES_FILENAME);
        if (inputStream == null) {
            SevenZip.throwInitException("error loading property file '" + string + SEVENZIPJBINDING_LIB_PROPERTIES_FILENAME + "' from a jar-file 'sevenzipjbinding-<Platform>.jar'. Is the platform jar-file not in the class path?");
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            SevenZip.throwInitException("error loading property file 'sevenzipjbinding-lib.properties' from a jar-file 'sevenzipjbinding-<Platform>.jar'");
        }
        return properties;
    }

    private static File createOrVerifyTmpDir(File file) throws SevenZipNativeInitializationException {
        File file2;
        if (file != null) {
            file2 = file;
        } else {
            String string = System.getProperty(SYSTEM_PROPERTY_TMP);
            if (string == null) {
                SevenZip.throwInitException("can't determinte tmp directory. Use may use -Djava.io.tmpdir=<path to tmp dir> parameter for jvm to fix this.");
            }
            file2 = new File(string);
        }
        if (!file2.exists() || !file2.isDirectory()) {
            SevenZip.throwInitException("invalid tmp directory '" + file + "'");
        }
        if (!file2.canWrite()) {
            SevenZip.throwInitException("can't create files in '" + file2.getAbsolutePath() + "'");
        }
        return file2;
    }

    private static File getOrCreateSevenZipJBindingTmpDir(File file, Properties properties) throws SevenZipNativeInitializationException {
        String string = SevenZip.getOrGenerateBuildRef(properties);
        File file2 = new File(file.getAbsolutePath() + File.separator + "SevenZipJBinding-" + string);
        if (!file2.exists() && !file2.mkdir()) {
            SevenZip.throwInitException("Directory '" + file.getAbsolutePath() + "' couldn't be created");
        }
        return file2;
    }

    private static String getOrGenerateBuildRef(Properties properties) {
        String string = properties.getProperty(PROPERTY_BUILD_REF);
        if (string == null) {
            string = Integer.toString(new Random().nextInt(10000000));
        }
        return string;
    }

    private static List<File> copyOrSkipLibraries(Properties properties, File file) throws SevenZipNativeInitializationException {
        ArrayList<File> arrayList = new ArrayList<File>(5);
        int n = 1;
        while (true) {
            File file2;
            String string;
            String string2;
            if ((string2 = properties.getProperty(string = String.format(PROPERTY_SEVENZIPJBINDING_LIBNAME, n))) == null) {
                if (arrayList.size() != 0) break;
                SevenZip.throwInitException("property file 'sevenzipjbinding-lib.properties' from a jar-file 'sevenzipjbinding-<Platform>.jar' don't contain the property named '" + string + "'");
            }
            if (!(file2 = new File(file.getAbsolutePath() + File.separatorChar + string2)).exists()) {
                InputStream inputStream = SevenZip.class.getResourceAsStream("/" + usedPlatform + "/" + string2);
                if (inputStream == null) {
                    SevenZip.throwInitException("error loading native library '" + string2 + "' from a jar-file 'sevenzipjbinding-<Platform>.jar'.");
                }
                SevenZip.copyLibraryToFS(file2, inputStream);
            }
            arrayList.add(file2);
            ++n;
        }
        SevenZip.applyTemporaryArtifacts(file, arrayList);
        return arrayList;
    }

    private static void applyTemporaryArtifacts(File file, List<File> list) {
        temporaryArtifacts = new File[list.size() + 1];
        list.toArray(temporaryArtifacts);
        SevenZip.temporaryArtifacts[SevenZip.temporaryArtifacts.length - 1] = file;
    }

    private static void loadNativeLibraries(List<File> list) throws SevenZipNativeInitializationException {
        for (int i = list.size() - 1; i != -1; --i) {
            String string = list.get(i).getAbsolutePath();
            try {
                System.load(string);
                continue;
            }
            catch (Throwable throwable) {
                throw new SevenZipNativeInitializationException("7-Zip-JBinding initialization failed: Error loading native library: '" + string + "'", throwable);
            }
        }
    }

    public static void initLoadedLibraries() throws SevenZipNativeInitializationException {
        if (initializationSuccessful) {
            return;
        }
        autoInitializationWillOccur = false;
        SevenZip.nativeInitialization();
    }

    private static void nativeInitialization() throws SevenZipNativeInitializationException {
        String string = System.getProperty(SYSTEM_PROPERTY_SEVEN_ZIP_NO_DO_PRIVILEGED_INITIALIZATION);
        final String[] stringArray = new String[1];
        final Throwable[] throwableArray = new Throwable[1];
        if (string == null || string.trim().equals("0")) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        stringArray[0] = SevenZip.nativeInitSevenZipLibrary();
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                    return null;
                }
            });
        } else {
            stringArray[0] = SevenZip.nativeInitSevenZipLibrary();
        }
        if (stringArray[0] != null || throwableArray[0] != null) {
            String string2 = stringArray[0];
            if (string2 == null) {
                string2 = "No message";
            }
            lastInitializationException = new SevenZipNativeInitializationException("Error initializing 7-Zip-JBinding: " + string2, throwableArray[0]);
            throw lastInitializationException;
        }
        initializationSuccessful = true;
    }

    public static ISevenZipInArchive openInArchive(ArchiveFormat archiveFormat, IInStream iInStream, IArchiveOpenCallback iArchiveOpenCallback) throws SevenZipException {
        SevenZip.ensureLibraryIsInitialized();
        if (archiveFormat != null) {
            return SevenZip.callNativeOpenArchive(archiveFormat.getMethodName(), iInStream, iArchiveOpenCallback);
        }
        return SevenZip.callNativeOpenArchive(null, iInStream, iArchiveOpenCallback);
    }

    public static ISevenZipInArchive openInArchive(ArchiveFormat archiveFormat, IInStream iInStream, String string) throws SevenZipException {
        SevenZip.ensureLibraryIsInitialized();
        if (archiveFormat != null) {
            return SevenZip.callNativeOpenArchive(archiveFormat.getMethodName(), iInStream, new ArchiveOpenCryptoCallback(string));
        }
        return SevenZip.callNativeOpenArchive(null, iInStream, new ArchiveOpenCryptoCallback(string));
    }

    public static ISevenZipInArchive openInArchive(ArchiveFormat archiveFormat, IInStream iInStream) throws SevenZipException {
        SevenZip.ensureLibraryIsInitialized();
        if (archiveFormat != null) {
            return SevenZip.callNativeOpenArchive(archiveFormat.getMethodName(), iInStream, new DummyOpenArchiveCallback());
        }
        return SevenZip.callNativeOpenArchive(null, iInStream, new DummyOpenArchiveCallback());
    }

    private static void ensureLibraryIsInitialized() {
        if (autoInitializationWillOccur) {
            autoInitializationWillOccur = false;
            try {
                SevenZip.initSevenZipFromPlatformJAR();
            }
            catch (SevenZipNativeInitializationException sevenZipNativeInitializationException) {
                lastInitializationException = sevenZipNativeInitializationException;
                throw new RuntimeException("SevenZipJBinding couldn't be initialized automaticly using initialization from platform depended JAR and the default temporary directory. Please, make sure the correct 'sevenzipjbinding-<Platform>.jar' file is in the class path or consider initializing SevenZipJBinding manualy using one of the offered initialization methods: 'net.sf.sevenzipjbinding.SevenZip.init*()'", sevenZipNativeInitializationException);
            }
        }
        if (!initializationSuccessful) {
            throw new RuntimeException("SevenZipJBinding wasn't initialized successfully last time.", lastInitializationException);
        }
    }

    private static void throwInitException(String string) throws SevenZipNativeInitializationException {
        SevenZip.throwInitException(null, string);
    }

    private static void throwInitException(Exception exception, String string) throws SevenZipNativeInitializationException {
        throw new SevenZipNativeInitializationException("Error loading SevenZipJBinding native library into JVM: " + string + " [You may also try different SevenZipJBinding initialization methods " + "'net.sf.sevenzipjbinding.SevenZip.init*()' in order to solve this problem] ", exception);
    }

    private static void copyLibraryToFS(File file, InputStream inputStream) {
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Error initializing SevenZipJBinding native library: can't copy native library out of a resource file to the temporary location: '" + file.getAbsolutePath() + "'", exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            try {
                if (inputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static String getPlatformBestMatch() throws SevenZipNativeInitializationException {
        List<String> list = SevenZip.getPlatformList();
        if (list.size() == 1) {
            return list.get(0);
        }
        String string = System.getProperty("os.arch");
        String string2 = System.getProperty("os.name").split(" ")[0];
        if (list.contains(string2 + "-" + string)) {
            return string2 + "-" + string;
        }
        StringBuilder stringBuilder = new StringBuilder("Can't find suited platform for os.arch=");
        stringBuilder.append(string);
        stringBuilder.append(", os.name=");
        stringBuilder.append(string2);
        stringBuilder.append("... Available list of platforms: ");
        for (String string3 : list) {
            stringBuilder.append(string3);
            stringBuilder.append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        SevenZip.throwInitException(stringBuilder.toString());
        return null;
    }

    private static ISevenZipInArchive callNativeOpenArchive(String string, IInStream iInStream, IArchiveOpenCallback iArchiveOpenCallback) throws SevenZipException {
        if (iInStream == null) {
            throw new NullPointerException("SevenZip.callNativeOpenArchive(...): inStream parameter is null");
        }
        return SevenZip.nativeOpenArchive(string, iInStream, iArchiveOpenCallback);
    }

    private static native ISevenZipInArchive nativeOpenArchive(String var0, IInStream var1, IArchiveOpenCallback var2) throws SevenZipException;

    private static native String nativeInitSevenZipLibrary();

    private static final class ArchiveOpenCryptoCallback
    implements IArchiveOpenCallback,
    ICryptoGetTextPassword {
        private final String passwordForOpen;

        public ArchiveOpenCryptoCallback(String string) {
            this.passwordForOpen = string;
        }

        public void setCompleted(Long l, Long l2) {
        }

        public void setTotal(Long l, Long l2) {
        }

        public String cryptoGetTextPassword() throws SevenZipException {
            return this.passwordForOpen;
        }
    }

    private static class DummyOpenArchiveCallback
    implements IArchiveOpenCallback,
    ICryptoGetTextPassword {
        private DummyOpenArchiveCallback() {
        }

        public void setCompleted(Long l, Long l2) {
        }

        public void setTotal(Long l, Long l2) {
        }

        public String cryptoGetTextPassword() throws SevenZipException {
            throw new SevenZipException("No password was provided for opening protected archive.");
        }
    }
}

