/*
 * Decompiled with CFR 0.152.
 */
package net.didion.loopy.iso9660;

import net.didion.loopy.FileEntry;
import net.didion.loopy.iso9660.ISO9660FileSystem;
import net.didion.loopy.iso9660.Util;

public final class ISO9660FileEntry
implements FileEntry {
    public static final char ID_SEPARATOR = ';';
    private ISO9660FileSystem fileSystem;
    private String parentPath;
    private final int entryLength;
    private final long startSector;
    private final int dataLength;
    private final long lastModifiedTime;
    private final int flags;
    private final String identifier;

    public ISO9660FileEntry(ISO9660FileSystem fileSystem, byte[] block, int pos) {
        this(fileSystem, null, block, pos);
    }

    public ISO9660FileEntry(ISO9660FileSystem fileSystem, String parentPath, byte[] block, int startPos) {
        this.fileSystem = fileSystem;
        this.parentPath = parentPath;
        int offset = startPos - 1;
        this.entryLength = Util.getUInt8(block, offset + 1);
        this.startSector = Util.getUInt32LE(block, offset + 3);
        this.dataLength = (int)Util.getUInt32LE(block, offset + 11);
        this.lastModifiedTime = Util.getDateTime(block, offset + 19);
        this.flags = Util.getUInt8(block, offset + 26);
        this.identifier = this.getFileIdentifier(block, offset, this.isDirectory());
    }

    private String getFileIdentifier(byte[] block, int offset, boolean isDir) {
        String id;
        int sepIdx;
        int fidLength = Util.getUInt8(block, offset + 33);
        if (isDir) {
            int buff34 = Util.getUInt8(block, offset + 34);
            if (fidLength == 1 && buff34 == 0) {
                return ".";
            }
            if (fidLength == 1 && buff34 == 1) {
                return "..";
            }
        }
        if ((sepIdx = (id = Util.getDChars(block, offset + 34, fidLength, this.fileSystem.getEncoding())).indexOf(59)) >= 0) {
            return id.substring(0, sepIdx);
        }
        return id;
    }

    @Override
    public String getName() {
        return this.identifier;
    }

    @Override
    public String getPath() {
        if (".".equals(this.getName())) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (null != this.parentPath) {
            buf.append(this.parentPath);
        }
        buf.append(this.getName());
        if (this.isDirectory()) {
            buf.append("/");
        }
        return buf.toString();
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public boolean isDirectory() {
        return (this.flags & 3) != 0;
    }

    @Override
    public int getSize() {
        return this.dataLength;
    }

    public long getStartBlock() {
        return this.startSector;
    }

    public int getEntryLength() {
        return this.entryLength;
    }

    public final boolean isLastEntry() {
        return (this.flags & 0x40) == 0;
    }
}

