/*
 * Decompiled with CFR 0.152.
 */
package net.didion.loopy.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.didion.loopy.FileSystem;
import net.didion.loopy.LoopyException;

public abstract class AbstractFileSystem
implements FileSystem {
    private File file;
    private boolean readOnly;
    private RandomAccessFile channel;

    protected AbstractFileSystem(File file, boolean readOnly) throws LoopyException {
        if (!readOnly) {
            throw new IllegalArgumentException("Currrently, only read-only is supported");
        }
        this.file = file;
        this.readOnly = readOnly;
        try {
            this.checkFile();
            this.channel = new RandomAccessFile(this.file, this.getMode(readOnly));
        }
        catch (IOException ex) {
            throw new LoopyException("Error opening the file", ex);
        }
    }

    private void checkFile() throws FileNotFoundException {
        if (this.readOnly && !this.file.exists()) {
            throw new FileNotFoundException("File does not exist: " + this.file);
        }
    }

    private String getMode(boolean readOnly) {
        return readOnly ? "r" : "rw";
    }

    @Override
    public synchronized void close() throws LoopyException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.channel.close();
        }
        catch (IOException ex) {
            throw new LoopyException("Error closing file system", ex);
        }
        finally {
            this.channel = null;
        }
    }

    @Override
    public boolean isClosed() {
        return null == this.channel;
    }

    protected void ensureOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("File has been closed");
        }
    }

    protected void seek(long pos) throws IOException {
        this.ensureOpen();
        this.channel.seek(pos);
    }

    protected int read(byte[] buffer, int bufferOffset, int len) throws IOException {
        this.ensureOpen();
        return this.channel.read(buffer, bufferOffset, len);
    }
}

