/*
 * Decompiled with CFR 0.152.
 */
package net.didion.loopy.impl;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import net.didion.loopy.FileEntry;
import net.didion.loopy.LoopyException;
import net.didion.loopy.impl.AbstractFileSystem;
import net.didion.loopy.impl.VolumeDescriptor;

public abstract class AbstractBlockFileSystem
extends AbstractFileSystem {
    private int blockSize;
    private int reservedBytes;
    private VolumeDescriptor volumeDescriptor;

    protected AbstractBlockFileSystem(File file, boolean readOnly, int blockSize, int reservedBytes) throws LoopyException {
        super(file, readOnly);
        this.blockSize = blockSize;
        this.reservedBytes = reservedBytes;
    }

    @Override
    public Enumeration getEntries() {
        this.ensureOpen();
        if (null == this.volumeDescriptor) {
            try {
                this.readDescriptor();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.enumerate(this.volumeDescriptor.getRootEntry());
    }

    protected void readDescriptor() throws IOException {
        byte[] buffer = new byte[this.blockSize];
        this.volumeDescriptor = this.createVolumeDescriptor();
        int block = this.reservedBytes / this.blockSize;
        while (this.readBlock(block++, buffer) && this.volumeDescriptor.read(buffer)) {
        }
    }

    protected boolean readBlock(long block, byte[] buffer) throws IOException {
        int bytesRead = this.readData(block * (long)this.blockSize, buffer, 0, this.blockSize);
        if (bytesRead <= 0) {
            return false;
        }
        if (this.blockSize != bytesRead) {
            throw new IOException("Could not read a complete block (" + this.blockSize + " bytes)");
        }
        return true;
    }

    protected synchronized int readData(long startPos, byte[] buffer, int bufferOffset, int len) throws IOException {
        this.seek(startPos);
        return this.read(buffer, bufferOffset, len);
    }

    protected abstract Enumeration enumerate(FileEntry var1);

    protected abstract VolumeDescriptor createVolumeDescriptor();
}

