/*
 * Decompiled with CFR 0.152.
 */
package net.didion.loopy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.didion.loopy.FileSystem;

public abstract class AbstractFileSystem
implements FileSystem {
    private RandomAccessFile channel;

    protected AbstractFileSystem(File file, boolean readOnly) throws IOException {
        if (!readOnly) {
            throw new IllegalArgumentException("Currrently, only read-only is supported");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist: " + file);
        }
        this.channel = new RandomAccessFile(file, "r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.channel.close();
        }
        finally {
            this.channel = null;
        }
    }

    @Override
    public boolean isClosed() {
        return null == this.channel;
    }

    protected void ensureOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("File has been closed");
        }
    }

    protected void seek(long pos) throws IOException {
        this.ensureOpen();
        this.channel.seek(pos);
    }

    protected int read(byte[] buffer, int offset, int length) throws IOException {
        this.ensureOpen();
        return this.channel.read(buffer, offset, length);
    }
}

